<?php

/**
 * This is the model class for table "reopenclaim".
 *
 * The followings are the available columns in table 'reopenclaim':
 * @property integer $id
 * @property integer $claim_id
 * @property integer $status
 * @property integer $open_by
 * @property integer $closed_by
 * @property string $close_date
 * @property string $created
 * @property string $modified
 *
 * The followings are the available model relations:
 * @property Claim $claim
 * @property User $openBy
 * @property User $closedBy
 */
class Reopenclaim extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Reopenclaim the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'reopenclaim';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('claim_id, open_by, created, modified', 'required'),
			array('claim_id, status, open_by, closed_by', 'numerical', 'integerOnly'=>true),
			array('close_date', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, claim_id, status, open_by, closed_by, close_date, created, modified', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'claim' => array(self::BELONGS_TO, 'Claim', 'claim_id'),
			'openBy' => array(self::BELONGS_TO, 'User', 'open_by'),
			'closedBy' => array(self::BELONGS_TO, 'User', 'closed_by'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'claim_id' => 'Claim',
			'status' => 'Status',
			'open_by' => 'Open By',
			'closed_by' => 'Closed By',
			'close_date' => 'Close Date',
			'created' => 'Created',
			'modified' => 'Modified',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('claim_id',$this->claim_id);
		$criteria->compare('status',$this->status);
		$criteria->compare('open_by',$this->open_by);
		$criteria->compare('closed_by',$this->closed_by);
		$criteria->compare('close_date',$this->close_date,true);
		$criteria->compare('created',$this->created,true);
		$criteria->compare('modified',$this->modified,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}