<?php

/**
 * This is the model class for table "messageinbox".
 *
 * The followings are the available columns in table 'messageinbox':
 * @property integer $id
 * @property integer $frommsg
 * @property integer $tomsg
 * @property string $subject
 * @property string $message
 * @property string $msgdate
 * @property integer $replyid
 * @property string $created
 * @property string $modified
 *
 * The followings are the available model relations:
 * @property User $frommsg0
 * @property User $tomsg0
 */
class Messageinbox extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Messageinbox the static model class
	 */
    public $fromuser;
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'messageinbox';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('frommsg, tomsg, message, msgdate', 'required'),
			array('frommsg, tomsg, replyid', 'numerical', 'integerOnly'=>true),
			array('subject', 'safe'),
                      array('fromuser,accept', 'safe'),   
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, frommsg, tomsg, subject, message, msgdate, replyid, created, modified', 'safe', 'on'=>'search'),
		
                     array(
                                        'modified','default',
                                        'value'=>new CDbExpression('NOW()'),
                                        'setOnEmpty'=>false,'on'=>'update'
                                    ),
                            array(
                                'created,modified','default',
                                'value'=>new CDbExpression('NOW()'),
                                'setOnEmpty'=>false,'on'=>'insert'
                                ),  
                    
                    );
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'frommsg0' => array(self::BELONGS_TO, 'User', 'frommsg'),
			'tomsg0' => array(self::BELONGS_TO, 'User', 'tomsg'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			 'id' => 'ID',
			'frommsg' => 'From',
			'tomsg' => 'To',
			'subject' => 'Subject',
			'message' => 'Message',
			'msgdate' => 'Date',
			'created' => 'Created',
			'modified' => 'Modified',
			'replyid' => 'Replyid',
			 
		);
	}
        public function getuserid($usr)
        {
            $model=new User;
            $c=new CDbCriteria;
            $c->compare('t.username',$usr);
            $mode=$model->find($c);
            //echo $mode->id;
            if($mode!=null)
                return $mode->id;
           
        }
	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
        public function fullsearch($lgu=null)
        {
                    $criteria=new CDbCriteria;
                    $criteria->join=" left join messagestatus on messagestatus.inbox_id=t.id";
                    $criteria->compare('messagestatus.active',1);
                    $id="";
                    $searchtxt="";
                    $cond="";
                    if(isset($_POST['searchtxt']))
                    {
                     $searchtxt=ltrim(rtrim($_POST['searchtxt']));
                     if($searchtxt!="")
                     {
                        
                         $id=  $this->getuserid($searchtxt);
                    }
                    
                     }
                        
                    $lgu=Yii::app()->user->id;
                    if(isset($_POST['sent']))
                    {   //$lgu=Yii::app()->user->id;
                     // $criteria->compare('frommsg',$lgu,true);
                      //$criteria->compare('messagestatus.type_id',2);
                         if( $searchtxt!="")
                         {
                             $cond="and (t.subject='".$searchtxt."'";
                             if($id!="")
                                $cond.=" OR t.tomsg=".$id.")";
                              else
                                 $cond.=")";
                         }
                       $criteria->condition=" (messagestatus.active=1 and messagestatus.type_id=2 and"
                            . " messagestatus.by_user=".$lgu.") ".$cond;
                    }
                    else if(isset($_POST['trash']))
                    {   
                        /*$criteria->compare('messagestatus.type_id',3,'true');
                        $criteria->compare('messagestatus.by_user',$lgu,true,'and');
                          //$criteria->compare('id',$this->id);
                         $criteria->compare('frommsg',$id,true,'or');
                         $criteria->compare('tomsg',$id,true,'or');
                         $criteria->compare('subject',$searchtxt,true,'or');
                         $criteria->compare('message',$searchtxt,true,'or');*/
                         if( $searchtxt!="")
                         {
                             $cond="and (t.subject='".$searchtxt."'";
                             if($id!="")
                                $cond.=" or t.frommsg=".$id." or t.tomsg=".$id.")";
                             else
                                 $cond.=")";
                         }
                    $criteria->condition=" (messagestatus.active=1 and messagestatus.type_id=3 and"
                            . " messagestatus.by_user=".$lgu.") ".$cond;
                    }
                     else if(isset($_POST['archive']))
                    {   
                        //$criteria->compare('messagestatus.type_id',4,'true');
                       // $criteria->compare('messagestatus.by_user',$lgu,true,'and');
                          if( $searchtxt!="")
                          {
                              $cond="and (t.subject='".$searchtxt."'";
                              if($id!="")
                                  $cond.=" or t.frommsg=".$id." or t.tomsg=".$id.")";
                              else {
                                  $cond.=")";
                              }
                          }
                          $criteria->condition=" (messagestatus.active=1 and messagestatus.type_id=4 and"
                            . " messagestatus.by_user=".$lgu.") ".$cond;
                    
                    }
                    else
                    {
                       // $criteria->compare('tomsg',$lgu,true);
                        // $criteria->compare('messagestatus.type_id',1);
                        if( $searchtxt!="")
                        {   $cond="and (t.subject='".$searchtxt."'";
                            if($id!="")
                                $cond.=" or t.frommsg=".$id.")";
                            else
                                $cond.=")";
                            
                        }
                        
                          $criteria->condition=" (messagestatus.active=1 and messagestatus.type_id=1 and"
                            . " messagestatus.by_user=".$lgu.") ". $cond;
                    } 
                    //if(isset($_POST['search']))
                  
                    if($searchtxt!="")
                    {
                                                 
                        
                         //$criteria->compare('msgdate',$this->msgdate,true);
                         //$criteria->compare('replyid',$this->replyid);
                         //$criteria->compare('created',$this->created,true);
                         //$criteria->compare('modified',$this->modified,true);
                    }
                   
                 // var_dump($criteria);
		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
        }
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('frommsg',$this->frommsg);
		$criteria->compare('tomsg',$this->tomsg);
		$criteria->compare('subject',$this->subject,true);
		$criteria->compare('message',$this->message,true);
		$criteria->compare('msgdate',$this->msgdate,true);
		$criteria->compare('replyid',$this->replyid);
		$criteria->compare('created',$this->created,true);
		$criteria->compare('modified',$this->modified,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}