<?php

/**
 * This is the model class for table "menuitem".
 *
 * The followings are the available columns in table 'menuitem':
 * @property integer $item_id
 * @property integer $parent_id
 * @property integer $menu_id
 * @property string $label
 * @property string $url
 * @property string $description
 * @property string $date_added
 * @property string $last_updated
 * @property integer $sort_order
 * @property string $status
 *
 * The followings are the available model relations:
 * @property Menu $menu
 * @property Menuitem $parent
 * @property Menuitem[] $menuitems
 */
class Menuitem extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Menuitem the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'menuitem';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('menu_id, label, url, description,   sort_order, status,login', 'required'),
			array('parent_id, menu_id, sort_order', 'numerical', 'integerOnly'=>true),
			array('label', 'length', 'max'=>255),
			array('status', 'length', 'max'=>8),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('item_id, parent_id, menu_id,login, label, url, description, date_added, last_updated, sort_order, status', 'safe', 'on'=>'search'),
                     array(
                                        'last_updated','default',
                                        'value'=>new CDbExpression('NOW()'),
                                        'setOnEmpty'=>false,'on'=>'update'
                        ),
                        array(
                                'date_added,last_updated','default',
                                'value'=>new CDbExpression('NOW()'),
                                'setOnEmpty'=>false,'on'=>'insert'
                        ),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'menu' => array(self::BELONGS_TO, 'Menu', 'menu_id'),
			'parent' => array(self::BELONGS_TO, 'Menuitem', 'parent_id'),
			'menuitems' => array(self::HAS_MANY, 'Menuitem', 'parent_id'),
                        'authitems' => array(self::BELONGS_TO, 'Authitem', 'authitem_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'item_id' => 'Item',
			'parent_id' => 'Parent',
			'menu_id' => 'Menu',
			'label' => 'Label',
			'url' => 'Url',
			'description' => 'Description',
			'date_added' => 'Date Added',
			'last_updated' => 'Last Updated',
			'sort_order' => 'Sort Order',
			'status' => 'Status',
                        
                    'login'=>'Log In',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('item_id',$this->item_id);
		$criteria->compare('parent_id',$this->parent_id);
		$criteria->compare('menu_id',$this->menu_id);
		$criteria->compare('label',$this->label,true);
		$criteria->compare('url',$this->url,true);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('date_added',$this->date_added,true);
		$criteria->compare('last_updated',$this->last_updated,true);
		$criteria->compare('sort_order',$this->sort_order);
		$criteria->compare('status',$this->status,true);
               
                $criteria->compare('login',$this->login);
		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
        public function homepagelist()
        {
            $results = Yii::app()->getDb()->createCommand();
            $results->select('label, url')->from('menuitem');
            $results->where('login=0 AND status="active" AND (menu_id=3 OR menu_id=1)');
            $results->order('sort_order ASC, label ASC');
        $arr=array();
        $results = $results->queryAll();
         foreach($results AS $result)
        {
           
           if( Yii::app()->user->checkAccess($result['url']) ){
               $url=str_replace(".","/",$result['url']);
               $temp=array($url=>$result['label']);
               $arr=  array_merge($temp,$arr);
           }
        }
        return $arr;
        }
        public  function  getItems($menu_id, $parent_id=null)
{
        $results = Yii::app()->getDb()->createCommand();
        $results->select('item_id, label, url')->from('menuitem');
            if(Yii::app()->user->isGuest)
                $login=1;
            else {
                $login=0;
            }
           $status='active';
        if($parent_id === null)
                $results->where('menu_id=:mid AND login=:lgn AND parent_id IS NULL and status="active"', array(':mid'=>(int)$menu_id,':lgn'=>(int)$login));
        else
                $results->where('menu_id=:mid AND parent_id=:pid AND login=:lgn AND status="active"', array(':mid'=>(int)$menu_id, ':pid'=>$parent_id,':lgn'=>(int)$login));
 
        $results->order('sort_order ASC, label ASC');
        
        $results = $results->queryAll();
 //var_dump($results);
        $items = array();
       // echo UserController::getMe(Yii::app()->user->id);
        if(empty($results))
                return $items;
// echo Yii::app()->user->checkAccess('salesinvoice.create');
        foreach($results AS $result)
        {
           
           if( Yii::app()->user->checkAccess($result['url']) || Yii::app()->user->isGuest){
               $url=str_replace(".","/",$result['url']);
              // $url='http://claimsflowsolutions.us/index.php?r='.$url;
            $childItems=$this->getItems($menu_id, $result['item_id']); 
            if($menu_id==3)
                $mark='<span style="color:#000;">>> </span>';
            else {
                $mark='';
            }
            $items[] = array(
              'label'         => $mark.$result['label'],
              'url'           => Yii::app()->createUrl($url),
             'itemOptions'   =>  array('class'=>'listItem'),
            'linkOptions'   =>  array('class'=>'listItemLink', 'title'=>$result['label']),
               'submenuOptions'=> array('class'=>'dropdown'),
             'items'         => $childItems,
               
               // array('label'=>$result['label'], 'url'=>array('/'.$result['label'])),
             );
        }
        }
       // var_dump($items);
        return $items;
}
}