<?php

/**
 * This is the model class for table "claim_assigned".
 *
 * The followings are the available columns in table 'claim_assigned':
 * @property integer $id
 * @property integer $claim_id
 * @property string $assigned
 * @property string $created
 * @property string $modified
 */
class ClaimAssigned extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'claim_assigned';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('claim_id, assigned', 'required'),
			array('claim_id', 'numerical', 'integerOnly'=>true),
			//array('assigned', 'length', 'max'=>10),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, claim_id, assigned,assignee_type,group_type, created, modified', 'safe', 'on'=>'search'),
                     array(
                                        'modified','default',
                                        'value'=>new CDbExpression('NOW()'),
                                        'setOnEmpty'=>false,'on'=>'update'
                              ),
                        array(
                                'created,modified','default',
                                'value'=>new CDbExpression('NOW()'),
                                'setOnEmpty'=>false,'on'=>'insert'
                              ),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'claim_id' => 'Claim',
			'assigned' => 'Assigned',
                        'assignee_type'=>'Assignee Type',
			'created' => 'Created',
			'modified' => 'Modified',
                        'group_type'=>'Group Type',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('claim_id',$this->claim_id);
		$criteria->compare('assigned',$this->assigned,true);
		$criteria->compare('created',$this->created,true);
		$criteria->compare('modified',$this->modified,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return ClaimAssigned the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
