<?php

class ReferencenumberController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column2';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			//'accessControl', // perform access control for CRUD operations
			//'postOnly + delete', // we only allow deletion via POST request
			'rights',
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
        {
            
                $mod=new Referencenumber;
                $q=new CDbCriteria;
                $q->compare('t.id',$id);
                $model=$mod->find($q);
                if($model!=null)
                {
                $q=new CDbCriteria;
                    $q->compare('t.ref_id',$model->id);
                   $mitem=  Referenceparts::model()->findAll($q);
                       $this->render('view',array(
                           'model'=>$model,
                           'dataProvider'=>$mitem,
                   ));
                }  else {
                    throw new CHttpException(404,'The requested reference number does not exist.');
		return $mod;
                }
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model=new Referencenumber;
                $parts=new Referenceparts;
               /* $mode=new Referencenumber;
                $c = new CDbCriteria;
                 $c->compare('claim_id',$_POST['Claim_id']);
                $df = $mode->find($c);
                     if($df)
                    {
                       // $this->actionEdit($_REQUEST['Claim_id']);
                        $this->redirect(array('update','id'=>$df->id));
                        //exit();
                    }   */
		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Referencenumber']))
		{
                    $model->attributes=$_POST['Referencenumber'];
                   //$model->claim_id=$_REQUEST['Claim_id'];
                    $model->user_id=Yii::app()->user->id;
                     $maxRefNumber = Yii::app()->db->createCommand()
                    ->select('max(reference_number) as max')
                    ->from('referencenumber')
                    ->queryScalar();
                  $model->reference_number = $maxRefNumber + 1;
                  //$model->claim_id=
                  if($maxRefNumber==0)
                      $model->reference_number=1001;
			
			if($model->save())
			{	$refid = $model->id;
                        $size=count($_POST['part_name']);
                          $i=0;
                          $today=date("Y-m-d H:i:s");
                       
                              
                               
                              
                            for($i=0;$i<$size;$i++)
                            { 
                            $meta=new Referenceparts; 
                                //echo $key."=".$val;
                                
                                $meta->ref_id=$refid;
                               $meta->part_name =$_POST['part_name'][$i];
                              $meta->price = $_POST['price'][$i];
                                   
                                   $meta->created = $today;
                                   $meta->modified=$today;
                                 if($meta->validate())
                                   $meta->save();
                                   //
                                  }
                               $this->redirect(array('view','id'=>$model->id));
                        }
		}
                        //$claimid=$_REQUEST['Claim_id'];
                         /*$claim=new Claim;        
                         $q=new CDbCriteria;
                         $q->compare("t.id",$claimid);
                         $claims=$claim->find($q);*/
		$this->render('create',array(
			'model'=>$model,
                        'parts'=>$parts,
                        //'claims'=>$claims,
                        
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);
                $q=new CDbCriteria;
                    $q->compare('t.ref_id',$id);
                   $parts=  Referenceparts::model()->findAll($q);
                   $pp=array();
                  //if($parts==null)
                      $pp=new Referenceparts;
		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Referencenumber']))
		{
			$model->attributes=$_POST['Referencenumber'];
			if($model->save())
                        {
                            $refid = $model->id;
                        $size=count($_POST['part_name']);
                          $i=0;
                          $today=date("Y-m-d H:i:s");
                       
                              
                               
                              
                            for($i=0;$i<$size;$i++)
                            { 
                            $meta=new Referenceparts; 
                                //echo $key."=".$val;
                                
                                $meta->ref_id=$refid;
                               $meta->part_name =$_POST['part_name'][$i];
                              $meta->price = $_POST['price'][$i];
                                   
                                   $meta->created = $today;
                                   $meta->modified=$today;
                                 if($meta->validate())
                                 {
                                    
                                     if($_POST['id'][$i]!=null)
                                     {
                                        
                                         Referenceparts::model()->updateAll(array('part_name'=>$_POST['part_name'][$i],'price'=>$_POST['price'][$i],'modified'=>$today), 'id='.$_POST['id'][$i]) ;
            
                                     }
                                     else
                                       
                                        $meta->save();
                                 }
                                   //
                                  }
				$this->redirect(array('view','id'=>$model->id));
                        }
                }

		$this->render('update',array(
			'model'=>$model,
                        'parts'=>$parts,
                        'pp'=>$pp,
                        
                        
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		$this->loadModel($id)->delete();

		// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
		if(!isset($_GET['ajax']))
			$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		$dataProvider=new CActiveDataProvider('Referencenumber');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new Referencenumber('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['Referencenumber']))
			$model->attributes=$_GET['Referencenumber'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer $id the ID of the model to be loaded
	 * @return Referencenumber the loaded model
	 * @throws CHttpException
	 */
	public function loadModel($id)
	{
		$model=Referencenumber::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested reference number does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param Referencenumber $model the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='referencenumber-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
}
