<?php

class ClaimfilesController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column2';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
			'postOnly + delete', // we only allow deletion via POST request
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model=new Claimfiles;
                /*if(isset($_FILES['Claimfiles']['estimate']['name']))
                {
                var_dump($_FILES['myfile']['name']);
    $i=0;
    foreach($_FILES['myfile']['name'] as $fl)
    {
        
    $uploaddir =realpath( Yii::app()->basePath . '/../upload').'/'.$fl;   
   move_uploaded_file($_FILES['myfile']['tmp_name'][$i], $uploaddir);
   $i++;
    }
                }*/
		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Claimfiles']))
		{
                    
                     $imageUploadFile_estimate = CUploadedFile::getInstance($model, 'estimate');
                     $imageUploadFile_additional_files = CUploadedFile::getInstance($model, 'additional_files');
                     $imageUploadFile_ems = CUploadedFile::getInstance($model, 'ems');
                     $imageUploadFile_image = CUploadedFile::getInstance($model, 'image');
                     
                        if($imageUploadFile_estimate !== null){ // only do if file is really uploaded
                            $imageFileName_estimate = $imageUploadFile_estimate->name;
                            $model->estimate = $imageFileName_estimate;
                        }   
                         if($imageUploadFile_additional_files !== null){ // only do if file is really uploaded
                            $imageFileName_additional_files = $imageUploadFile_additional_files->name;
                            $model->additional_files = $imageFileName_additional_files;
                        } 
                         if($imageUploadFile_ems !== null){ // only do if file is really uploaded
                            $imageFileName_ems = $imageUploadFile_ems->name;
                            $model->ems= $imageFileName_ems;
                        } 
                         if($imageUploadFile_image !== null){ // only do if file is really uploaded
                            $imageFileName_image = $imageUploadFile_image->name;
                            $model->image = $imageFileName_image;
                        } 
			$model->attributes=$_POST['Claimfiles'];
			if($model->save())
                         {
                            if($imageUploadFile !== null) // validate to save file
                            { $images_path = realpath(Yii::app()->basePath . '/../upload');
                                   
                              $imageUploadFile->saveAs($images_path . '/' . $model->estimate);
                              $imageUploadFile->saveAs($images_path . '/' . $model->additional_files);
                              $imageUploadFile->saveAs($images_path . '/' . $model->ems);
                              $imageUploadFile->saveAs($images_path . '/' . $model->image);
                               // $imageUploadFile->saveAs(Article::FOLDER_IMAGE.$imageFileName);
                            }
 
                           // $this->redirect(array('view','id'=>$model->id));
                        }
                        
		}

		$this->render('create',array(
			'model'=>$model,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Claimfiles']))
		{
			$model->attributes=$_POST['Claimfiles'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id));
		}

		$this->render('update',array(
			'model'=>$model,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		$this->loadModel($id)->delete();

		// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
		if(!isset($_GET['ajax']))
			$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		$dataProvider=new CActiveDataProvider('Claimfiles');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new Claimfiles('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['Claimfiles']))
			$model->attributes=$_GET['Claimfiles'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer $id the ID of the model to be loaded
	 * @return Claimfiles the loaded model
	 * @throws CHttpException
	 */
	public function loadModel($id)
	{
		$model=Claimfiles::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param Claimfiles $model the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='claimfiles-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
}
