<?php

class BranchController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column2';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			//'accessControl', // perform access control for CRUD operations
			//'postOnly + delete', // we only allow deletion via POST request
			'rights'
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
        public function actionViewbranch($id=null)
	{
            if($id==null)
            {
                $uid=Yii::app()->user->id;
                $mod=User::model()->findByPk($uid);
                $id=$mod->branch_id;
                
            }
            $md=new User;
            $q=new CDbCriteria;
            $q->compare('t.branch_id','='.$id);
            $umod=$md->findAll($q);
            $type=new Authitem;
                $q=new CDbCriteria;
                $q->compare('t.type','2');
                $types=$type->findAll($q);
		$this->render('_viewbranch',array(
			'data'=>$this->loadModel($id),
                        'id'=>$id,
                       'row'=>$umod,
                    'types'=>$types,
		));
	}
	public function actionView($id=null)
	{
            /*if($id==null)
            {
               $m= UserController::getUserDetail(Yii::app()->user->id);
                $id=$m->branch_id;//Yii::app()->user->branch_id;
                
            }
            
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));*/
            
            if($id==null)
            {
                $uid=Yii::app()->user->id;
                $mod=User::model()->findByPk($uid);
                $id=$mod->branch_id;
                
            }
            $md=new User;
            $q=new CDbCriteria;
            $q->compare('t.branch_id','='.$id);
            $umod=$md->findAll($q);
            $type=new Authitem;
                $q=new CDbCriteria;
                $q->compare('t.type','2');
                $types=$type->findAll($q);
		$this->render('_viewbranch',array(
			'data'=>$this->loadModel($id),
                        'id'=>$id,
                       'row'=>$umod,
                    'types'=>$types,
		));
	}
         public function allowedActions()
        { 
            return 'getCmp,coveragedelete,Getdetail,Getadjuster,Gettpaadjuster,Getadjusterdetail,getdetail,getadjuster,gettpaadjuster,getadjusterdetail';
        }
        public function actiongetCmp()
        {
            
            $typ = new Company;
                $c = new CDbCriteria;
				$c->select='t.id,t.name';
                $c->join = 'left join branch on branch.company_id=t.id';
                $c->compare('t.id',$_REQUEST['User']['branch_id']); 
                $data = $typ->findAll($c);
				
                $data=CHtml::listData($data,'id','name');                
                echo CHtml::tag('option',
                               array('value'=>''),'Select',true);
				if($_POST['Company']['type_id']!="")
				{   
					foreach($data as $value=>$name)
					{
						echo CHtml::tag('option',
						array('value'=>$value),CHtml::encode($name),true);
					}
				}
        }
        public function actionGetdetail()
        {
            $model=new Branch;
            $rs=  Branch::model()->findByPk($_POST['branchid']);
            echo CJSON::encode($rs);
            Yii::app()->end();
        }
        public function actionGetadjuster()
        {
            
             $usr = new User;
             $sql= 'SELECT t.id,t.first_name,t.last_name FROM user t left join authassignment on authassignment.userid=t.id '
                     . 'WHERE t.branch_id = :brch and authassignment.itemname=:type  order by t.first_name,t.last_name';
                $type = '19';//and  authassignment.itemname = :type
        $data= Yii::app()->db->createCommand($sql)->queryAll(true,array(':brch'=>$_POST['branchid'],':type'=>$type));
 
                
                echo CJSON::encode($data);
                    Yii::app()->end();
				
        }
         public function actionGettpaadjuster()
        {
            
             $usr = new User;
             $sql= 'SELECT t.id,t.first_name,t.last_name FROM user t left join authassignment on authassignment.userid=t.id '
                     . 'WHERE t.branch_id = :brch and authassignment.itemname=:type  order by t.first_name,t.last_name';
                $type = '27';//and  authassignment.itemname = :type)
        $data= Yii::app()->db->createCommand($sql)->queryAll(true,array(':brch'=>$_POST['branchid'],':type'=>$type));
 
                
                echo CJSON::encode($data);
                    Yii::app()->end();
				
        }
        public function actionGetadjusterdetail()
        {
            
            $rs=User::model()->findByPk($_POST['uid']);
            echo CJSON::encode($rs);
            Yii::app()->end();
        }
        
        public function actionEditzipcoverage()
        {}
        public function actionBranchcoverage()
        {
            $model=new Branch;
           // $c=new CdbCriteria;
           
            if(isset($_POST['zipcoverage']))
            {
                $size=count($_POST['zipcoverage']);
                 for($i=0;$i<$size;$i++)
                  { 
                      Branch::model()->updateAll(array('zipcodecoverage'=>$_POST['zipcoverage'][$i]), 'id='.$_POST['id'][$i]) ;
                  
                        Yii::app()->user->setFlash('success','Zip Coverage saved Successfully');
                         
                  }
            }
             $m=$model->findAll();
		$this->render('branchcoverage',array(
			'dataProvider'=>$m,
                        'model'=>$model,
                
		));       
        }
        public  function actionCoveragedelete()
        {
            if($_POST['id']!='')
            {
                 Branch::model()->updateAll(array('zipcodecoverage'=>''), 'id='.$_POST['id']) ;
                 return true;
          
            }
        }
        /**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model=new Branch;
		$cmp=new Company;
		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);
                    $uid=  Yii::app()->user->id;
                    //$rs          = User::model()->findByPk($uid);
                    $q=new CDbCriteria;
                    $q->select='t.id,t.name,t.type_id';
                    $q->join='left join branch on branch.company_id=t.id left join user on user.branch_id=branch.id';
                    $q->compare('user.id',$uid);
                    $companies=$cmp->findAll($q,array('id','name'));
                    $cc=$cmp->find($q);
                   // echo $cc->type_id;
                  $type=new Companytype;
                  $q=new CDbCriteria;
                  $q->compare('t.id',$cc->type_id);
		$types=$type->findAll($q,array('id','type'));
                $ctype=$type->find($q);
               $roles=Rights::getAssignedRoles(Yii::app()->user->id);
               
                if(strtoupper($ctype->type)=="CFS")
                {
                    $q=new CDbCriteria;
                    $q->select='t.id,t.name,t.type_id';
                     $q->compare('t.type_id',$ctype->id);
                    $companies=$cmp->findAll($q,array('id','name'));
                }
		if(isset($_POST['Branch']))
		{
			$model->attributes=$_POST['Branch'];
                        $model->aftermiles=$_POST['Branch']['aftermiles'];
                        if($model->validate())
                        {
                            if($_POST['Company']['type_id']!='')
                            {
                                if($model->save())
				$this->redirect(array('view','id'=>$model->id));
                            }
                        }
		}
		
		 $q=new CDbCriteria;
		$stt=new State;
		$states=$stt->findAll('',array('id','name'));
		$this->render('create',array(
			'model'=>$model,
			'type'=>$type,
			'types'=>$types,
			'companies'=>$companies,
			'cmp'=>$cmp,
			'states'=>$states,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);
 
		$cmp=new Company;
		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);
                    $uid=  Yii::app()->user->id;
                    //$rs          = User::model()->findByPk($uid);
                    $q=new CDbCriteria;
                    $q->select='t.id,t.name,t.type_id';
                    $q->join='left join branch on branch.company_id=t.id left join user on user.branch_id=branch.id';
                    $q->compare('user.id',$uid);
                    $companies=$cmp->findAll($q,array('id','name'));
                    $cc=$cmp->find($q);
                   // echo $cc->type_id;
                  $type=new Companytype;
                  $q=new CDbCriteria;
                  $q->compare('t.id',$cc->type_id);
		$types=$type->findAll($q,array('id','type'));
                $ctype=$type->find($q);
               $roles=Rights::getAssignedRoles(Yii::app()->user->id);
               
                if(strtoupper($ctype->type)=="CFS")
                {
                    $q=new CDbCriteria;
                    $q->select='t.id,t.name,t.type_id';
                     $q->compare('t.type_id',$ctype->id);
                    $companies=$cmp->findAll($q,array('id','name'));
                }
		if(isset($_POST['Branch']))
		{
			$model->attributes=$_POST['Branch'];
                        $model->aftermiles=$_POST['Branch']['aftermiles'];
                        if($model->validate())
                        {
                            if($_POST['Company']['type_id']!='')
                            {
                                if($model->save())
				$this->redirect(array('view','id'=>$model->id));
                            }
                        }
		}
		
		 $q=new CDbCriteria;
		$stt=new State;
		$states=$stt->findAll('',array('id','name'));
		$this->render('update',array(
			'model'=>$model,
			'type'=>$type,
			'types'=>$types,
			'companies'=>$companies,
			'cmp'=>$cmp,
			'states'=>$states,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		$this->loadModel($id)->delete();

		// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
		if(!isset($_GET['ajax']))
			$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		$dataProvider=new CActiveDataProvider('Branch');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new Branch('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['Branch']))
			$model->attributes=$_GET['Branch'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer $id the ID of the model to be loaded
	 * @return Branch the loaded model
	 * @throws CHttpException
	 */
	public function loadModel($id)
	{
		$model=Branch::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param Branch $model the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='branch-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
}
