<?php

class BodyshopSelectionController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column2';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			//'accessControl', // perform access control for CRUD operations
			//'postOnly + delete', // we only allow deletion via POST request
                    'rights',
		);
	}
      

        /**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}
        public function allowedActions() {
            return 'setdrp,unsetdrp';
        }
        public function actionUnsetdrp()
        {
            if(isset($_POST['body_id']))
            { 
                  
               BodyshopSelection::model()->deleteAll(array("condition"=>"bodyshop_id=".$_POST['body_id']." and selected_by=".Yii::app()->user->id));
          
            }
        }

        public function actionSetdrp()
        {
            if(isset($_POST['body_id']))
            {
                $model=new BodyshopSelection;
                $criteria=new CDbCriteria;
                $criteria->compare('t.bodyshop_id',$_POST['body_id']);
                $criteria->compare('t.selected_by',Yii::app()->user->id);
                $m=$model->find($criteria);
                if ($m==null)
                {   $model->bodyshop_id=$_POST['body_id'];
                      $model->selected_by=Yii::app()->user->id;
                      $model->save();
                }
            }
        }
  public static function Getme($cid)
        {
            $model=new BodyshopSelection;
            $criteria=new CDbCriteria;
            $criteria->compare('t.bodyshop_id',$cid);
           $criteria->compare('t.selected_by',Yii::app()->user->id);
            $m=$model->find($criteria);
          if ($m!=null)
          { //echo $m->bodyshop_id;
            if($m->bodyshop_id==$cid)
                return true;
          }
          else {
              return false;
          }
        }
        /**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{ 
		$model=new BodyshopSelection('search');
                $states=  State::model()->findAll();
                $criteria=new CDbCriteria;
                $criteria->join=' left join state on state.id=t.state_id';
                $criteria->compare('type_id',3);
                
                if(isset($_POST['state']) )
 				{ if($_POST['state']!='')
                    $criteria->compare('t.state_id',$_POST['state']);
					}
                $criteria->order=' t.name,state.name';
                //var_dump($criteria);
                 $cmp=new CActiveDataProvider('Company', array(
			'criteria'=>$criteria,
		));
                
		
		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['BodyshopSelection']))
		{
			$model->attributes=$_POST['BodyshopSelection'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id));
		}

		$this->render('create',array(
			'model'=>$model,
                        'cmp'=>$cmp,
                        'states'=>$states,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['BodyshopSelection']))
		{
			$model->attributes=$_POST['BodyshopSelection'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id));
		}

		$this->render('update',array(
			'model'=>$model,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		$this->loadModel($id)->delete();

		// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
		if(!isset($_GET['ajax']))
			$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		$dataProvider=new CActiveDataProvider('BodyshopSelection');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new BodyshopSelection('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['BodyshopSelection']))
			$model->attributes=$_GET['BodyshopSelection'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer $id the ID of the model to be loaded
	 * @return BodyshopSelection the loaded model
	 * @throws CHttpException
	 */
	public function loadModel($id)
	{
		$model=BodyshopSelection::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param BodyshopSelection $model the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='bodyshop-selection-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
}
