<?php
if(!defined('__SWS__')) exit;
$xtpl = new XTemplate("stubs/claim/appraiser_invoice_view.html");
$xtpl->assign("URL",$_SESSION['URL']);
require_once('include/CommanModels/Claim.php');
$focus = New Claim();
if($_REQUEST['id']) $focus->retrieve($_REQUEST['id']);

if(base64_decode($_REQUEST['status']) == 'claim-saved') {
  $xtpl->assign("FLASH_MESSAGE", "Claim has been saved successfully...");
  $xtpl->assign("MSG_CLASS",     'success');
} else if(base64_decode($_REQUEST['status']) == 'claim-updated') {
  $xtpl->assign("FLASH_MESSAGE", "Claim has been updated successfully...");
  $xtpl->assign("MSG_CLASS",     'success');
} else if(base64_decode($_REQUEST['status']) == 'required-fields') {
  $xtpl->assign("FLASH_MESSAGE", "Please fill the indicates required fields!");
  $xtpl->assign("MSG_CLASS",     'failure');
} else if(base64_decode($_REQUEST['status']) == 'summary-created') {
  $xtpl->assign("FLASH_MESSAGE", "Claim Summary been saved successfully...");
  $xtpl->assign("MSG_CLASS",     'success');
} 
if(isset($_REQUEST['status']) && $_REQUEST['status'] !='') $xtpl->parse("main.flash_message");

$xtpl->assign("LBL_REQUIRED_SYMBOL",    $LBL_REQUIRED_SYMBOL);
$xtpl->assign("CLAIM_NAME_HEADING",     ($focus->name) ? ' - '.stripslashes($focus->name) : '');

if($_REQUEST['id']) {
  $xtpl->assign("FILE_NUMBER",                      $focus->claim_name);
  $xtpl->assign("CLAIM_CREATED_DATE",               date("M. dS, Y - H:i:s A", strtotime($focus->date_created)) );
  $xtpl->assign("CLAIM_AGE",                        returnHTMLClaimAge($focus->date_created));
} else {
  $xtpl->assign("FILE_NUMBER",                      getNewFileNumber());
  $xtpl->assign("CLAIM_CREATED_DATE",               date("M. dS, Y - H:i:s A"));
}

if($focus->id) {
  $claim_assigned_info = getClaimAssignedTo($focus->id);
  $xtpl->assign("CLAIM_ASSIGNED_TO",            $claim_assigned_info['claim_assigned_to']['company_name']);
  $xtpl->assign("CLAIM_INSPECTED_BY",           $claim_assigned_info['claim_inspected_by']['user_name']);
  $xtpl->assign("CLAIM_REINSPECTED_BY",         $claim_assigned_info['claim_reinspected_by']['user_name']);
  $xtpl->assign("CLAIM_REVIEWED_BY",            $claim_assigned_info['claim_reviewed_by']['user_name']);
}

$xtpl->assign("CLAIM_ID",                           $focus->id);
$xtpl->assign("CLAIM_NUM",                          $focus->claim_num);
$xtpl->assign("POLICY_NUM",                         $focus->policy_num);
$xtpl->assign("POLICY_LIMIT",                       $focus->policy_limit);
$xtpl->assign("DEDUCTIBLE",                         $focus->deductible);
$xtpl->assign("WAVE_DEDUCTIBLE_CHECKED",            ($focus->wave_deductible == 1) ? 'checked="checked"' : '');
$xtpl->assign("DATE_OF_LOSS",                       ($focus->date_of_loss != '0000-00-00 00:00:00') ? date("Y-m-d", strtotime($focus->date_of_loss)) : '' );

$xtpl->assign("ASSIGNMENT_TYPE_OTHER",              $focus->assignment_type_other);
$xtpl->assign("ASSIGNMENT_TYPE_OTHER_STY",          ($focus->assignment_type_other !='') ? '' : 'none');

$xtpl->assign("ASSIGNMENT_TYPE_DOM",                $assignment_type_dom[$focus->assignment_type]);
$xtpl->assign("LOSS_TYPE_DOM",                      $loss_type_dom[$focus->loss_type]);

$xtpl->assign("LOSS_TYPE_OTHER",                    $focus->loss_type_other);
$xtpl->assign("LOSS_TYPE_OTHER_STY",                ($focus->loss_type_other !='') ? '' : 'none');

$xtpl->assign("REPORT_DATE",                        ($focus->report_date != '0000-00-00 00:00:00') ? date("Y-m-d", strtotime($focus->report_date)) : '' );
$xtpl->assign("WHOSE_CLAIM_DOM",                    $whose_claim_dom[$focus->claim_owner]);
$xtpl->assign("COVERAGE_TYPE",                      $focus->coverage_type);

$xtpl->assign("COMPANY_DOM",                        getCompanyNameById($focus->company_id));
$xtpl->assign("ADJUSTER_DOM",                       getUserNameById($focus->adjuster));

$xtpl->assign("OTHER_INSURANCE_COMPANY",             $focus->other_insurance_company);
$xtpl->assign("OTHER_INSURANCE_COMPANY_STY",         ($focus->other_insurance_company !='') ? '' : 'none');

$xtpl->assign("OTHER_COMPANY_ADJUSTER",             $focus->other_company_adjuster);
$xtpl->assign("OTHER_COMPANY_ADJUSTER_STY",         ($focus->other_company_adjuster !='') ? '' : 'none');

$xtpl->assign("INSURED_FIRSTNAME",                  $focus->insured_firstname);
$xtpl->assign("INSURED_LASTNAME",                   $focus->insured_lastname);
$xtpl->assign("INSURED_ADDRESS_1",                  $focus->insured_address_1);
$xtpl->assign("INSURED_ADDRESS_2",                  $focus->insured_address_2);
$xtpl->assign("INSURED_CITY",                       $focus->insured_city);
$xtpl->assign("INSURED_STATE_DOM",                  getStateById($focus->insured_state));
$xtpl->assign("INSURED_ZIP_CODE",                   $focus->insured_zip_code);
$xtpl->assign("INSURED_HOME_PHONE_NUM",             $focus->insured_home_phone_num);
$xtpl->assign("INSURED_WORK_PHONE_NUM",             $focus->insured_work_phone_num);
$xtpl->assign("INSURED_MOBILE_PHONE_NUM",           $focus->insured_mobile_phone_num);
$xtpl->assign("INSURED_FAX_NUM",                    $focus->insured_fax_num);
$xtpl->assign("INSURED_EMAIL",                      $focus->insured_email);

$xtpl->assign("CLAIMANT_FIRSTNAME",                 $focus->claimant_firstname);
$xtpl->assign("CLAIMANT_LASTNAME",                  $focus->claimant_lastname);
$xtpl->assign("CLAIMANT_ADDRESS_1",                 $focus->claimant_address_1);
$xtpl->assign("CLAIMANT_ADDRESS_2",                 $focus->claimant_address_2);
$xtpl->assign("CLAIMANT_CITY",                      $focus->claimant_city);
$xtpl->assign("CLAIMANT_STATE_DOM",                 getStateById($focus->claimant_state));
$xtpl->assign("CLAIMANT_ZIP_CODE",                  $focus->claimant_zip_code);
$xtpl->assign("CLAIMANT_HOME_PHONE_NUM",            $focus->claimant_home_phone_num);
$xtpl->assign("CLAIMANT_WORK_PHONE_NUM",            $focus->claimant_work_phone_num);
$xtpl->assign("CLAIMANT_MOBILE_PHONE_NUM",          $focus->claimant_mobile_phone_num);
$xtpl->assign("CLAIMANT_FAX_NUM",                   $focus->claimant_fax_num);
$xtpl->assign("CLAIMANT_EMAIL",                     $focus->claimant_email);

$xtpl->assign("OWNER_FIRSTNAME",                    $focus->owner_firstname);
$xtpl->assign("OWNER_LASTNAME",                     $focus->owner_lastname);
$xtpl->assign("OWNER_ADDRESS_1",                    $focus->owner_address_1);
$xtpl->assign("OWNER_ADDRESS_2",                    $focus->owner_address_2);
$xtpl->assign("OWNER_CITY",                         $focus->owner_city);
$xtpl->assign("OWNER_STATE_DOM",                    getStateById($focus->owner_state));
$xtpl->assign("OWNER_ZIP_CODE",                     $focus->owner_zip_code);
$xtpl->assign("OWNER_HOME_PHONE_NUM",               $focus->owner_home_phone_num);
$xtpl->assign("OWNER_WORK_PHONE_NUM",               $focus->owner_work_phone_num);
$xtpl->assign("OWNER_MOBILE_PHONE_NUM",             $focus->owner_mobile_phone_num);
$xtpl->assign("OWNER_FAX_NUM",                      $focus->owner_fax_num);
$xtpl->assign("OWNER_EMAIL",                        $focus->owner_email);

$xtpl->assign("VEHICLE_LOCATION_NAME",              $focus->vehicle_location_name);
$xtpl->assign("VEHICLE_ADDRESS_1",                  $focus->vehicle_address_1);
$xtpl->assign("VEHICLE_ADDRESS_2",                  $focus->vehicle_address_2);
$xtpl->assign("VEHICLE_CITY",                       $focus->vehicle_city);
$xtpl->assign("VEHICLE_STATE_DOM",                  getStateById($focus->vehicle_state));
$xtpl->assign("VEHICLE_ZIP_CODE",                   $focus->vehicle_zip_code);
$xtpl->assign("VEHICLE_PHONE_NUM",                  $focus->vehicle_phone_num);
$xtpl->assign("VEHICLE_EMAIL_ADDRESS",              $focus->vehicle_email_address);
$xtpl->assign("VEHICLE_YEAR",                       $focus->vehicle_year);

$xtpl->assign("VEHICLE_MAKE_DOM",                   getMakeNameById($focus->vehicle_make));
$xtpl->assign("VEHICLE_MODEL_DOM",                  getModelNameById($focus->vehicle_model));

$xtpl->assign("OTHER_VEHICLE_MAKE",                 $focus->other_vehicle_make);
$xtpl->assign("OTHER_VEHICLE_MAKE_STY",             ($focus->other_vehicle_make !='') ? '' : 'none');

$xtpl->assign("OTHER_VEHICLE_MODEL",                $focus->other_vehicle_model);
$xtpl->assign("OTHER_VEHICLE_MODEL_STY",            ($focus->other_vehicle_model !='') ? '' : 'none');

$xtpl->assign("VEHICLE_VIN_NUM",                    $focus->vehicle_vin_num);
$xtpl->assign("VEHICLE_LIENHOLDER",                 $focus->vehicle_lienholder);
$xtpl->assign("VEHICLE_COLOR",                      $focus->vehicle_color);
$xtpl->assign("VEHICLE_PLATE_NUM",                  $focus->vehicle_plate_num);

$xtpl->assign("VEHICLE_PLATE_COUNTRY_DOM",          getCountryById($focus->vehicle_plate_country));
$xtpl->assign("VEHICLE_PLATE_STATE_DOM",            getStateById($focus->vehicle_plate_state) );

$xtpl->assign("VEHICLE_MILEAGE",                    $focus->vehicle_mileage);
$xtpl->assign("VEHICLE_STYLE",                      $focus->vehicle_style);

if($focus->vehicle_driveable == 1) $xtpl->assign("VEHICLE_DRIVEABLE",   'Yes');
else if($focus->vehicle_driveable == 2) $xtpl->assign("VEHICLE_DRIVEABLE",   'No');
else if($focus->vehicle_driveable == 3) $xtpl->assign("VEHICLE_DRIVEABLE",   'Unknown');

$xtpl->assign("CONDITION_DOM",                      $condition_dom[$focus->vehicle_condition]);
$xtpl->assign("SPECIAL_INSTRUCTIONS",               $focus->special_instructions);
$xtpl->assign("PRIMARY_POINT_OF_IMPACT",            $focus->primary_point_of_impact);
$xtpl->assign("SECONDARY_POINT_OF_IMPACT",          $focus->secondary_point_of_impact);
$xtpl->assign("DAMAGE_DESCRIPTION",                 $focus->damage_description);
$xtpl->assign("ACCIDENT_DESCRIPTION",               $focus->accident_description);

if($focus->permission_to_move == 1) $xtpl->assign("PERMISSION_TO_MOVE",   'Yes');
else if($focus->permission_to_move == 2) $xtpl->assign("PERMISSION_TO_MOVE",   'NO');
else if($focus->permission_to_move == 3) $xtpl->assign("PERMISSION_TO_MOVE",   'Unknown');

$xtpl->assign("PAY_CODE",                           $focus->pay_code);

if($focus->rental_vehicle == 1) {
  $xtpl->assign("RENTAL_VEHICLE_STY",   '');
  $xtpl->assign("RENTAL_VEHICLE",   'Yes');
} else if($focus->rental_vehicle == 2) {
  $xtpl->assign("RENTAL_VEHICLE",   'No');
  $xtpl->assign("RENTAL_VEHICLE_STY",   'none');
} else if($focus->rental_vehicle == 3) {
  $xtpl->assign("RENTAL_VEHICLE",   'Unknown');
  $xtpl->assign("RENTAL_VEHICLE_STY",   'none');
}

$xtpl->assign("RENTAL_MAX_DAYS",                    $focus->rental_max_days);
$xtpl->assign("RENTAL_MAX_AMOUNT",                  $focus->rental_max_amount);

if($focus->storage == 1) $xtpl->assign("STORAGE",   'Yes');
else if($focus->storage == 2) $xtpl->assign("STORAGE",   'No');
else if($focus->storage == 3) $xtpl->assign("STORAGE",   'Unknown');

if($focus->prior_damage == 1) $xtpl->assign("PRIOR_DAMAGE",   'Yes');
else if($focus->prior_damage == 2) $xtpl->assign("PRIOR_DAMAGE",   'No');
else if($focus->prior_damage == 3) $xtpl->assign("PRIOR_DAMAGE",   'Unknown');

if($focus->prior_damage == 1) $xtpl->assign("DAMAGE_LOCATION_STY",       '');
else $xtpl->assign("DAMAGE_LOCATION_STY",       'none');
$xtpl->assign("DAMAGE_LOCATION",                    $focus->damage_location);

if($focus->vehicle_appointment_setup == 1) $xtpl->assign("VEHICLE_APPOINTMENT_SETUP",   'Yes');
else if($focus->vehicle_appointment_setup == 2) $xtpl->assign("VEHICLE_APPOINTMENT_SETUP",   'No');

if($focus->vehicle_appointment_setup == 1) $xtpl->assign("APPOINTMENT_SETUP_STY",   '');
else $xtpl->assign("APPOINTMENT_SETUP_STY",   'none');

$xtpl->assign("APPT_DATE",                      ($focus->appt_date != '0000-00-00 00:00:00') ? date("Y-m-d", strtotime($focus->appt_date)) : '' );
$xtpl->assign("TIME_START",                     $focus->time_start);
$xtpl->assign("TIME_END",                       $focus->time_end);

if($focus->total_loss == 1) $xtpl->assign("F_TOTAL_LOSS",   'Yes');
else if($focus->total_loss == 2) $xtpl->assign("F_TOTAL_LOSS",   'No');
else if($focus->total_loss == 3) $xtpl->assign("F_TOTAL_LOSS",   'Unknown');

if($focus->total_loss == 1) $xtpl->assign("LOSS_VISIBILITY_STY",   '');
else $xtpl->assign("LOSS_VISIBILITY_STY",   'none');

$xtpl->assign("CLAIM_EVALUATION_TYPE_DOM",       $claim_evaluation_type_dom[$focus->eval_type]);

if($focus->eval_type == 'Generic ACV with bids') $xtpl->assign("EVAL_TYPE_STY",   '');
else $xtpl->assign("EVAL_TYPE_STY",   'none');

$xtpl->assign("EVAL_TYPE_BIDS_NAME1",            $focus->eval_type_bids_name1);
$xtpl->assign("EVAL_TYPE_BIDS_REF_NU1",          $focus->eval_type_bids_ref_nu1);
$xtpl->assign("EVAL_TYPE_BIDS_LOCATION1",        $focus->eval_type_bids_location1);
$xtpl->assign("EVAL_TYPE_BIDS_NUMBER1",          $focus->eval_type_bids_number1);
$xtpl->assign("EVAL_TYPE_BIDS_AMOUNT1",          $focus->eval_type_bids_amount1);

$xtpl->assign("EVAL_TYPE_BIDS_NAME2",            $focus->eval_type_bids_name2);
$xtpl->assign("EVAL_TYPE_BIDS_REF_NU2",          $focus->eval_type_bids_ref_nu2);
$xtpl->assign("EVAL_TYPE_BIDS_LOCATION2",        $focus->eval_type_bids_location2);
$xtpl->assign("EVAL_TYPE_BIDS_NUMBER2",          $focus->eval_type_bids_number2);
$xtpl->assign("EVAL_TYPE_BIDS_AMOUNT2",          $focus->eval_type_bids_amount2);

$xtpl->assign("EVAL_TYPE_BIDS_NAME3",            $focus->eval_type_bids_name3);
$xtpl->assign("EVAL_TYPE_BIDS_REF_NU3",          $focus->eval_type_bids_ref_nu3);
$xtpl->assign("EVAL_TYPE_BIDS_LOCATION3",        $focus->eval_type_bids_location3);
$xtpl->assign("EVAL_TYPE_BIDS_NUMBER3",          $focus->eval_type_bids_number3);
$xtpl->assign("EVAL_TYPE_BIDS_AMOUNT3",          $focus->eval_type_bids_amount3);

$xtpl->assign("EVAL_TYPE_BIDS_NAME4",            $focus->eval_type_bids_name4);
$xtpl->assign("EVAL_TYPE_BIDS_REF_NU4",          $focus->eval_type_bids_ref_nu4);
$xtpl->assign("EVAL_TYPE_BIDS_LOCATION4",        $focus->eval_type_bids_location4);
$xtpl->assign("EVAL_TYPE_BIDS_NUMBER4",          $focus->eval_type_bids_number4);
$xtpl->assign("EVAL_TYPE_BIDS_AMOUNT4",          $focus->eval_type_bids_amount4);

$xtpl->assign("EVAL_TYPE_BIDS_NAME5",            $focus->eval_type_bids_name5);
$xtpl->assign("EVAL_TYPE_BIDS_REF_NU5",          $focus->eval_type_bids_ref_nu5);
$xtpl->assign("EVAL_TYPE_BIDS_LOCATION5",        $focus->eval_type_bids_location5);
$xtpl->assign("EVAL_TYPE_BIDS_NUMBER5",          $focus->eval_type_bids_number5);
$xtpl->assign("EVAL_TYPE_BIDS_AMOUNT5",          $focus->eval_type_bids_amount5);

$xtpl->assign("ORDERED_BY_ADDRESS_1",               $focus->ordered_by_address_1);
$xtpl->assign("ORDERED_BY_ADDRESS_2",               $focus->ordered_by_address_2);
$xtpl->assign("ORDERED_BY_CITY",                    $focus->ordered_by_city);
$xtpl->assign("ORDERED_BY_STATE_DOM",               select_list(getStatesByCountryId('1'), $focus->ordered_by_state_id, 1, '-- Select --'));
$xtpl->assign("ORDERED_BY_ZIP",                     $focus->ordered_by_zip);
$xtpl->assign("ORDERED_BY_PHONE",                   $focus->ordered_by_phone);
$xtpl->assign("ORDERED_BY_FAX",                     $focus->ordered_by_fax);
$xtpl->assign("ORDERED_BY_EMAIL",                   $focus->ordered_by_email);

$xtpl->assign("INTERIOR_CONDITION",                 $focus->interior_condition);
$xtpl->assign("PAINT_CONDITION",                    $focus->paint_condition);
$xtpl->assign("ENGINE",                             $focus->engine);

$xtpl->assign("REPAIR_SHOP_NAME",                   $focus->repair_shop_name);
$xtpl->assign("REPAIR_ADDRESS_1",                   $focus->repair_address_1);
$xtpl->assign("REPAIR_ADDRESS_2",                   $focus->repair_address_2);
$xtpl->assign("REPAIR_CITY",                        $focus->repair_city);
$xtpl->assign("REPAIR_STATE_DOM",                   getStateById($focus->repair_state_id) );
$xtpl->assign("REPAIR_ZIP",                         $focus->repair_zip);
$xtpl->assign("REPAIR_PHONE",                       $focus->repair_phone);
$xtpl->assign("REPAIR_FAX",                         $focus->repair_fax);
$xtpl->assign("REPAIR_AGREED_PRICE_DOM",            $yes_no_dom[$focus->repair_agreed_price] );
$xtpl->assign("REPAIR_FEDERAL_TAX_ID",              $focus->repair_federal_tax_id);
$xtpl->assign("REPAIR_ERT_DAYS",                    $focus->repair_ert_days);
$xtpl->assign("REPAIR_POSSIBLE_SUPPLEMENT",         $focus->repair_possible_supplement);
$xtpl->assign("REPAIR_ORIGINAL_NET_LOSS",           $focus->repair_original_net_loss);
$xtpl->assign("REPAIR_SUPPLEMENT_NET_LOSS",         $focus->repair_supplement_net_loss);
$xtpl->assign("RECOMENDATION",                      $focus->recomendation);

$xtpl->assign("COVERAGE_VERIFIED",                  ($focus->coverage_verified == 1) ? 'checked="checked"' : '' );
$xtpl->assign("DIFFERENT_LOCATION",                 ($focus->different_location == 1) ? 'checked="checked"' : '' );
$xtpl->assign("DIFFERENT_LOCATION_STY",             ($focus->different_location == 1) ? 'inline' : 'none' );
$xtpl->assign("VEHICLE_SUB_MODEL",                  $focus->vehicle_sub_model);

// Claim Summary
$claimSummary = getClaimSummaryInfobyId($_REQUEST['id']);
$xtpl->assign("SUMMARY_ID",                      $claimSummary->id);
$xtpl->assign("INSPECTION_LOCATION",             $claimSummary->inspection_location);
$xtpl->assign("INSPECTION_DATE",                 ($claimSummary->inspection_date != '0000-00-00') ? $claimSummary->inspection_date : '');
$xtpl->assign("ASSIGNED_DATE_TIME",              ($claimSummary->assigned_date_time != '0000-00-00 00:00:00') ? $claimSummary->assigned_date_time : '');

$xtpl->assign("RECOMMENDATION_DOM",              $recomendation_dom[$claimSummary->recommendation] );
$xtpl->assign("ESTIMATE1_TOTAL",                 $claimSummary->estimate1_total );
$xtpl->assign("ESTIMATE2_TOTAL",                 $claimSummary->estimate2_total );
$xtpl->assign("ESTIMATE1_BETTERMENT",            $claimSummary->estimate1_betterment );
$xtpl->assign("ESTIMATE2_BETTERMENT",            $claimSummary->estimate2_betterment );
$xtpl->assign("SUPPLEMENT1_TOTAL",               $claimSummary->supplement1_total );
$xtpl->assign("SUPPLEMENT1_BETTERMENT",          $claimSummary->supplement1_betterment );
$xtpl->assign("SUPPLEMENT2_TOTAL",               $claimSummary->supplement2_total );
$xtpl->assign("SUPPLEMENT2_BETTERMENT",          $claimSummary->supplement2_betterment );
$xtpl->assign("SUPPLEMENT3_TOTAL",               $claimSummary->supplement3_total );
$xtpl->assign("SUPPLEMENT3_BETTERMENT",          $claimSummary->supplement3_betterment );
$xtpl->assign("SUPPLEMENT4_TOTAL",               $claimSummary->supplement4_total );
$xtpl->assign("SUPPLEMENT4_BETTERMENT",          $claimSummary->supplement4_betterment );
$xtpl->assign("SUBTOTAL",                        $claimSummary->subtotal );
$xtpl->assign("TOTAL",                           $claimSummary->total );
$xtpl->assign("ORIGINAL_NET_LOSS",               $claimSummary->original_net_loss );
$xtpl->assign("SUPPLEMENT_NET_LOSS",             $claimSummary->supplement_net_loss );

//var_dump($claimSummary->tire_l_r);

$xtpl->assign("REPAIR_TIME",                     $claimSummary->repair_time);
$xtpl->assign("REPAIR_TIME",                     $claimSummary->repair_time);
$xtpl->assign("TIRE_MAKE",                       $claimSummary->tire_make);
$xtpl->assign("TIRE_SIZE",                       $claimSummary->tire_size);
$xtpl->assign("TIRE_L_F",                        $claimSummary->tire_l_f);
$xtpl->assign("TIRE_R_F",                        $claimSummary->tire_r_f);
$xtpl->assign("TIRE_L_R",                        $claimSummary->tire_l_r);
$xtpl->assign("TIRE_R_R",                        $claimSummary->tire_r_r);
$xtpl->assign("TIRE_SPARE",                      $claimSummary->tire_spare);
$xtpl->assign("TOWING_CHARGES",                  $claimSummary->towing_charges);
$xtpl->assign("STORAGE_PER_DAY",                 $claimSummary->storage_per_day);
$xtpl->assign("DAYS",                            $claimSummary->days);
$xtpl->assign("APPROXIMATE_TOTAL",               $claimSummary->approximate_total);
$xtpl->assign("TOTAL_RENTAL_POTENTIAL_COST",     $claimSummary->total_rental_potential_cost);
$xtpl->assign("ACTUAL_RENTAL_DAYS",              $claimSummary->actual_rental_days);
$xtpl->assign("ACTUAL_RENTAL_AMOUNT",            $claimSummary->actual_rental_amount);

$xtpl->assign("PRIOR_DAMAGE_MESSAGE",            stripslashes($claimSummary->prior_damage));
$xtpl->assign("AGREED_PRICE",                    $claimSummary->agreed_price);
$xtpl->assign("APPRAISAL_AMOUNT",                $claimSummary->appraisal_amount);
$xtpl->assign("BETTERMENT_AMOUNT",               $claimSummary->betterment_amount);
$xtpl->assign("CLAIM_REMARKS",                   $claimSummary->claim_remarks);

$net_loss = ($claimSummary->appraisal_amount - $focus->deductible - $claimSummary->betterment_amount);
// Deepak Comment for Claim Summary Field not transfering issue

//$original_net_loss = ($claimSummary->appraisal_amount - $focus->deductible - $claimSummary->betterment_amount);

$original_net_loss = ($claimSummary->estimate1_total  + $claimSummary->estimate2_total) - ($claimSummary->estimate1_betterment + $claimSummary->estimate2_betterment);

$total_net_loss = (($claimSummary->appraisal_amount + $original_net_loss) - ($focus->deductible - $claimSummary->betterment_amount));

$xtpl->assign("NET_LOSS",                        $net_loss);
$xtpl->assign("ORIGINAL_NET_LOSS",               $original_net_loss);
$xtpl->assign("TOTAL_NET_LOSS",                  $total_net_loss);


// Branch Info...
//var_dump($focus->id);
$company_info = getCompanyInfoById($focus->company_id);
$branch_info  = getBranchInfoById($focus->claim_created_by_branch);
$company_info1 = getCompanyInfoById($current_company_id);

/* Deepak Modified Code for Logo Issue, picked up the Company id (same which was used in View Company Navigation Link, i.e. $_current_company_id)  */
/*  
if(file_exists(UPLOADED_FILES.$company_info->id.'/'.make_image_name($company_info->id, $company_info->file_extn, 'thumb'))) {
  $xtpl->assign("COMPANY_LOGO", UPLOADED_FILES.$company_info->id.'/'.make_image_name($company_info->id, $company_info->file_extn, 'thumb'));  
} else {
  $xtpl->assign("COMPANY_LOGO",           'images/no_company_logo.jpg');
}
*/

//As per the issue:incorrect logo on view summary. Adding static header(logo & address) of PDS(Property Damage Specilist)
$company_info1 = getUserInfo($_SESSION['current_user_id']);
if(file_exists(UPLOADED_FILES.$company_info1->id.'/'.make_image_name($company_info1->id, $company_info1->file_extn, 'thumb'))) {
  $xtpl->assign("COMPANY_LOGO", UPLOADED_FILES.$company_info1->id.'/'.make_image_name($company_info1->id, $company_info1->file_extn, 'thumb'));  
} else {
  $xtpl->assign("COMPANY_LOGO", 'images/no_company_logo.jpg');
}



$xtpl->assign("APPRAISER_NAME",              $company_info1->name);
$xtpl->assign("APPRAISER_ADDRESS_1",         $company_info1->address_1);
$xtpl->assign("APPRAISER_ADDRESS_2",         $company_info1->address_2);
$xtpl->assign("APPRAISER_CITY",              $company_info1->city);
$xtpl->assign("APPRAISER_STATE_NAME",        getStateById($company_info1->state_id));
$xtpl->assign("APPRAISER_COUNTRY_NAME",      getCountryById($company_info1->country_id));
$xtpl->assign("APPRAISER_ZIP_CODE",          $company_info1->zip_code);

$xtpl->assign("PAGE_HEADING",           'View Appraiser Fee Invoice - File Number: '.$focus->claim_name);
$xtpl->assign("PAGE_IMAGE",             'claim.png');



$javascript = <<<EOQ
<script language="javascript">
<!-- // Start Hide
// window.print();
// End Hide -->
</script>
EOQ;


$xtpl->assign("JAVASCRIPT"  ,$javascript);

$xtpl->parse("main");
$xtpl->out("main");

?>