<?php

/**
 * This is the model class for table "summery".
 *
 * The followings are the available columns in table 'summery':
 * @property integer $id
 * @property double $estimate1
 * @property double $estimate2
 * @property double $estiment1betterment
 * @property double $estiment2betterment
 * @property double $supplement1
 * @property double $supplement2
 * @property double $supplement3
 * @property double $supplement4
 * @property double $supplementbetterment1
 * @property double $supplementbetterment2
 * @property double $supplementbetterment3
 * @property double $supplementbetterment4
 * @property double $subtotal
 * @property double $deductible
 * @property double $originalnetloss
 * @property double $grosstotal
 * @property double $supplementnetloss
 * @property double $towingcharges
 * @property double $storageperday
 * @property double $days
 * @property double $approximatetotal
 * @property string $rentalvehicle
 * @property double $totalrentalpotentialcost
 * @property double $actualrentaldays
 * @property double $actualrentalamount
 * @property string $style
 * @property string $remark
 * @property integer $claim_id
 * @property string $created
 * @property string $modified
 */
class Summery extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Summery the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'summery';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('claim_id', 'required'),
			array('claim_id,rental_max_days', 'numerical', 'integerOnly'=>true),
			array('estimate1, estimate2, estiment1betterment, estiment2betterment, supplement1, supplement2, supplement3, supplement4, supplementbetterment1, supplementbetterment2, supplementbetterment3, supplementbetterment4, subtotal, deductible, originalnetloss, grosstotal, supplementnetloss, towingcharges, storageperday, days, approximatetotal, totalrentalpotentialcost, actualrentaldays, actualrentalamount,ertdays,possiblesupplements,rental_max_amount', 'numerical'),
			array('rentalvehicle', 'length', 'max'=>7),
			array('style', 'length', 'max'=>500),
			array('remark', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, estimate1, estimate2,assigned_datetime,rental_max_amount,rental_max_days, estiment1betterment, estiment2betterment, supplement1, supplement2, supplement3, supplement4, supplementbetterment1, supplementbetterment2, supplementbetterment3, supplementbetterment4, subtotal, deductible, originalnetloss, grosstotal, supplementnetloss, towingcharges, storageperday, days, approximatetotal, rentalvehicle, totalrentalpotentialcost, actualrentaldays, actualrentalamount, style, remark, claim_id, created, modified,inspectionlocation,inspectiondate,ertdays,possiblesupplements,recommendations', 'safe', 'on'=>'search'),
		array(
                                        'modified','default',
                                        'value'=>new CDbExpression('NOW()'),
                                        'setOnEmpty'=>false,'on'=>'update'
                        ),
                        array(
                                'created,modified','default',
                                'value'=>new CDbExpression('NOW()'),
                                'setOnEmpty'=>false,'on'=>'insert'
                        ),
                    );
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'claim' => array(self::BELONGS_TO, 'Claim', 'claim_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'estimate1' => 'Estimate1',
			'estimate2' => 'Estimate2',
			'estiment1betterment' => 'Estiment1betterment',
			'estiment2betterment' => 'Estiment2betterment',
			'supplement1' => 'Supplement1',
			'supplement2' => 'Supplement2',
			'supplement3' => 'Supplement3',
			'supplement4' => 'Supplement4',
			'supplementbetterment1' => 'Supplementbetterment1',
			'supplementbetterment2' => 'Supplementbetterment2',
			'supplementbetterment3' => 'Supplementbetterment3',
			'supplementbetterment4' => 'Supplementbetterment4',
			'subtotal' => 'Subtotal',
			'deductible' => 'Deductible',
			'originalnetloss' => 'Original Net Loss',
			'grosstotal' => 'Grosstotal',
			'supplementnetloss' => 'Supplement Net Loss',
			'towingcharges' => 'Towing Charges',
			'storageperday' => 'Storage Per Day',
			'days' => 'Days',
			'approximatetotal' => 'Approximate Total',
			'rentalvehicle' => 'Rental Vehicle',
			'totalrentalpotentialcost' => 'Total Rental Potential Cost',
			'actualrentaldays' => 'Actual Rental Days',
			'actualrentalamount' => 'Actual Rental Amount',
			'style' => 'Style',
                        'inspectionlocation'=>'Inspection Location',
                        'inspectiondate'=>'Inspection Date',
                        'ertdays'=>'ERT Days',
                        'possiblesupplements'=>'Possible Supplements',
			'remark' => 'Remark',
                        'assigned_datetime'=>'Assigned Date/Time',
                        'recommendations'=>'Recommendation',
			'claim_id' => 'Claim',
			'created' => 'Created',
			'modified' => 'Modified',
			
			'rental_max_days'=>'Rental Max Days',
			'rental_max_amount'=>'Rental Max Amount',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('estimate1',$this->estimate1);
		$criteria->compare('estimate2',$this->estimate2);
		$criteria->compare('estiment1betterment',$this->estiment1betterment);
		$criteria->compare('estiment2betterment',$this->estiment2betterment);
		$criteria->compare('supplement1',$this->supplement1);
		$criteria->compare('supplement2',$this->supplement2);
		$criteria->compare('supplement3',$this->supplement3);
		$criteria->compare('supplement4',$this->supplement4);
		$criteria->compare('supplementbetterment1',$this->supplementbetterment1);
		$criteria->compare('supplementbetterment2',$this->supplementbetterment2);
		$criteria->compare('supplementbetterment3',$this->supplementbetterment3);
		$criteria->compare('supplementbetterment4',$this->supplementbetterment4);
		$criteria->compare('subtotal',$this->subtotal);
		$criteria->compare('deductible',$this->deductible);
		$criteria->compare('originalnetloss',$this->originalnetloss);
		$criteria->compare('grosstotal',$this->grosstotal);
		$criteria->compare('supplementnetloss',$this->supplementnetloss);
		$criteria->compare('towingcharges',$this->towingcharges);
		$criteria->compare('storageperday',$this->storageperday);
		$criteria->compare('days',$this->days);
		$criteria->compare('approximatetotal',$this->approximatetotal);
		$criteria->compare('rentalvehicle',$this->rentalvehicle,true);
		$criteria->compare('totalrentalpotentialcost',$this->totalrentalpotentialcost);
		$criteria->compare('actualrentaldays',$this->actualrentaldays);
		$criteria->compare('actualrentalamount',$this->actualrentalamount);
		$criteria->compare('style',$this->style,true);
		$criteria->compare('remark',$this->remark,true);
		$criteria->compare('claim_id',$this->claim_id);
                $criteria->compare('recommendations',$this->recommendations);
                
		$criteria->compare('created',$this->created,true);
		$criteria->compare('modified',$this->modified,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}