<?php

/**
 * This is the model class for table "payout".
 *
 * The followings are the available columns in table 'payout':
 * @property integer $id
 * @property integer $claim_id
 * @property integer $type_id
 * @property string $estimate_amount
 * @property string $deductable_amount
 * @property string $betterment_amount
 * @property string $registration_amount
 * @property string $additional_amount
 * @property string $subtotal
 * @property string $tax_rate
 * @property string $total_tax
 * @property string $settlement_total
 * @property string $check_amount1
 * @property string $check_amount2
 * @property string $check_amount3
 * @property string $check_amount4
 * @property string $check_no1
 * @property string $check_no2
 * @property string $check_no3
 * @property string $check_no4
 * @property string $paid_date1
 * @property string $paid_date2
 * @property string $paid_date3
 * @property string $paid_date4
 * @property string $check_amount_total
 * @property string $is_claim_settled
 * @property string $created
 * @property string $modified
 * @property integer $deleted
 *
 * The followings are the available model relations:
 * @property Payouttype $type
 * @property Claim $claim
 */
class Payout extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Payout the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'payout';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('claim_id, type_id, settlement_total, is_claim_settled', 'required'),
			array('claim_id, type_id, deleted', 'numerical', 'integerOnly'=>true),
			array('estimate_amount, deductable_amount, betterment_amount, registration_amount, additional_amount, subtotal, tax_rate, total_tax, settlement_total, check_amount1, check_amount2, check_amount3, check_amount4, check_amount_total', 'length', 'max'=>10),
			array('check_no1, check_no2, check_no3, check_no4', 'length', 'max'=>255),
			array('is_claim_settled', 'length', 'max'=>3),
			array('paid_date1, paid_date2, paid_date3, paid_date4', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, claim_id, type_id, estimate_amount, deductable_amount, betterment_amount, registration_amount, additional_amount, subtotal, tax_rate, total_tax, settlement_total, check_amount1, check_amount2, check_amount3, check_amount4, check_no1, check_no2, check_no3, check_no4, paid_date1, paid_date2, paid_date3, paid_date4, check_amount_total, is_claim_settled, created, modified, deleted', 'safe', 'on'=>'search'),
                            array(
                                        'modified','default',
                                        'value'=>new CDbExpression('NOW()'),
                                        'setOnEmpty'=>false,'on'=>'update'
                                    ),
                            array(
                                'created,modified','default',
                                'value'=>new CDbExpression('NOW()'),
                                'setOnEmpty'=>false,'on'=>'insert'
                                ),  
                    
                    );
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'type' => array(self::BELONGS_TO, 'Payouttype', 'type_id'),
			'claim' => array(self::BELONGS_TO, 'Claim', 'claim_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'claim_id' => 'Claim',
			'type_id' => 'Type',
			'estimate_amount' => 'Estimate Amount',
			'deductable_amount' => 'Deductable Amount',
			'betterment_amount' => 'Betterment Amount',
			'registration_amount' => 'Registration Amount',
			'additional_amount' => 'Additional Amount',
			'subtotal' => 'Subtotal',
			'tax_rate' => 'Tax Rate',
			'total_tax' => 'Total Tax',
			'settlement_total' => 'Settlement Total',
			'check_amount1' => 'Check Amount 1',
			'check_amount2' => 'Check Amount 2',
			'check_amount3' => 'Check Amount 3',
			'check_amount4' => 'Check Amount 4',
			'check_no1' => 'Check No 1',
			'check_no2' => 'Check No 2',
			'check_no3' => 'Check No 3',
			'check_no4' => 'Check No 4',
			'paid_date1' => 'Paid Date 1',
			'paid_date2' => 'Paid Date 2',
			'paid_date3' => 'Paid Date 3',
			'paid_date4' => 'Paid Date 4',
			'check_amount_total' => 'Check Amount Total',
			'is_claim_settled' => 'Is Claim Settled',
			'created' => 'Created',
			'modified' => 'Modified',
			'deleted' => 'Deleted',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('claim_id',$this->claim_id);
		$criteria->compare('type_id',$this->type_id);
		$criteria->compare('estimate_amount',$this->estimate_amount,true);
		$criteria->compare('deductable_amount',$this->deductable_amount,true);
		$criteria->compare('betterment_amount',$this->betterment_amount,true);
		$criteria->compare('registration_amount',$this->registration_amount,true);
		$criteria->compare('additional_amount',$this->additional_amount,true);
		$criteria->compare('subtotal',$this->subtotal,true);
		$criteria->compare('tax_rate',$this->tax_rate,true);
		$criteria->compare('total_tax',$this->total_tax,true);
		$criteria->compare('settlement_total',$this->settlement_total,true);
		$criteria->compare('check_amount1',$this->check_amount1,true);
		$criteria->compare('check_amount2',$this->check_amount2,true);
		$criteria->compare('check_amount3',$this->check_amount3,true);
		$criteria->compare('check_amount4',$this->check_amount4,true);
		$criteria->compare('check_no1',$this->check_no1,true);
		$criteria->compare('check_no2',$this->check_no2,true);
		$criteria->compare('check_no3',$this->check_no3,true);
		$criteria->compare('check_no4',$this->check_no4,true);
		$criteria->compare('paid_date1',$this->paid_date1,true);
		$criteria->compare('paid_date2',$this->paid_date2,true);
		$criteria->compare('paid_date3',$this->paid_date3,true);
		$criteria->compare('paid_date4',$this->paid_date4,true);
		$criteria->compare('check_amount_total',$this->check_amount_total,true);
		$criteria->compare('is_claim_settled',$this->is_claim_settled,true);
		$criteria->compare('created',$this->created,true);
		$criteria->compare('modified',$this->modified,true);
		$criteria->compare('deleted',$this->deleted);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}