<?php

/**
 * This is the model class for table "assignee".
 *
 * The followings are the available columns in table 'assignee':
 * @property integer $id
 * @property integer $claim_id
 * @property integer $assign_by
 * @property integer $assign_to
 * @property integer $active
 * @property string $created
 * @property string $modified
 */
class Assignee extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'assignee';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('claim_id, assign_by, active', 'required'),
			array('claim_id, assign_by, assign_to, active,branch_id,parent_id', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id,branch_id,parent_id, claim_id, assign_by, assign_to, active, created, modified', 'safe', 'on'=>'search'),
                         array(
                                        'modified','default',
                                        'value'=>new CDbExpression('NOW()'),
                                        'setOnEmpty'=>false,'on'=>'update'
                              ),
                        array(
                                'created,modified','default',
                                'value'=>new CDbExpression('NOW()'),
                                'setOnEmpty'=>false,'on'=>'insert'
                              ),
                    
                    
                    
                    );
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    
                     'claims'=>array(self::BELONGS_TO,'Claim','claim_id'),
                     'assignby'=>array(self::BELONGS_TO,'User','assign_by'),
                     'assignto'=>array(self::BELONGS_TO,'User','assign_to'),
                    'ass_branch'=>array(self::BELONGS_TO,'Branch','branch_id'),
                    'parrent'=>array(self::HAS_MANY,'Assignee','parent_id'),
                    //,
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'claim_id' => 'Claim',
			'assign_by' => 'Assign By',
			'assign_to' => 'Assign To',
			'active' => 'Active',
			'created' => 'Created',
			'modified' => 'Modified',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('claim_id',$this->claim_id);
		$criteria->compare('assign_by',$this->assign_by);
		$criteria->compare('assign_to',$this->assign_to);
		$criteria->compare('active',$this->active);
		$criteria->compare('created',$this->created,true);
		$criteria->compare('modified',$this->modified,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Assignee the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
