<?php

/**
 * This is the model class for table "administrationpermission".
 *
 * The followings are the available columns in table 'administrationpermission':
 * @property integer $id
 * @property integer $usertype_id
 * @property integer $admin_linkid
 */
class Administrationpermission extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Administrationpermission the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'administrationpermission';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('usertype_id, admin_linkid', 'required'),
			array('usertype_id, admin_linkid', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, usertype_id, admin_linkid', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'adminlink' => array(self::BELONGS_TO, 'Administration', 'admin_linkid'),
                     'useradmin' => array(self::BELONGS_TO, 'Usertype', 'usertype_id'),
		);
	}
       
	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'usertype_id' => 'Usertype',
			'admin_linkid' => 'Admin Linkid',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('usertype_id',$this->usertype_id);
		$criteria->compare('admin_linkid',$this->admin_linkid);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}