<?php

/**
 * This is the model class for table "action_apply".
 *
 * The followings are the available columns in table 'action_apply':
 * @property integer $id
 * @property integer $by_utype
 * @property integer $action
 * @property integer $active
 * @property string $created
 * @property string $modified
 * @property integer $claim_id
 */
class ActionApply extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'action_apply';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('by_utype, action, active, claim_id,by_userid', 'required'),
			array('by_utype, action, active, claim_id,by_userid', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, by_utype, action, active, created, modified, claim_id,by_userid', 'safe', 'on'=>'search'),
		
                       array(
                                        'modified','default',
                                        'value'=>new CDbExpression('NOW()'),
                                        'setOnEmpty'=>false,'on'=>'update'
                        ),
                        array(
                                'created,modified','default',
                                'value'=>new CDbExpression('NOW()'),
                                'setOnEmpty'=>false,'on'=>'insert'
                        ),
                    );
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                   'acionclaim' => array(self::BELONGS_TO, 'Claim', 'claim_id'),
		);
	}
        public function getActionDetail($claim_id)
        {
            $q=new CDbCriteria;
            $q->condition='t.claim_id='.$claim_id." and active=1";
            $detail=$this->findAll($q);
            if($detail!=null)
                return $detail;
        }
        /**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'by_utype' => 'By Utype',
			'action' => 'Action',
			'active' => 'Active',
			'created' => 'Created',
			'modified' => 'Modified',
			'claim_id' => 'Claim',
                        'by_userid'=>'By User Id',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('by_utype',$this->by_utype);
		$criteria->compare('action',$this->action);
		$criteria->compare('active',$this->active);
		$criteria->compare('created',$this->created,true);
		$criteria->compare('modified',$this->modified,true);
		$criteria->compare('claim_id',$this->claim_id);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return ActionApply the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
