<?php

class SiteController extends Controller
{
	/**
	 * Declares class-based actions.
	 */
	public function actions()
	{
		return array(
			// captcha action renders the CAPTCHA image displayed on the contact page
			'captcha'=>array(
				'class'=>'CCaptchaAction',
				'backColor'=>0xFFFFFF,
                            
			),
                   
			// page action renders "static" pages stored under 'protected/views/site/pages'
			// They can be accessed via: index.php?r=site/page&view=FileName
			'page'=>array(
				'class'=>'CViewAction',
			),
		);
	}

	/**
	 * This is the default 'index' action that is invoked
	 * when an action is not explicitly requested by users.
	 */
	public function actionIndex()
	{
             $this->layout="logn";
             $model=new LoginForm;
		// renders the view file 'protected/views/site/index.php'
		// using the default layout 'protected/views/layouts/main.php'
		$this->render('index',array('model'=>$model));
	}

	/**
	 * This is the action to handle external exceptions.
	 */
	public function actionError()
	{
            if(Yii::app()->user->isGuest)
                 $this->layout="logn";
		if($error=Yii::app()->errorHandler->error)
		{
			if(Yii::app()->request->isAjaxRequest)
				echo $error['message'];
			else
				$this->render('error', $error);
		}
	}

	/**
	 * Displays the contact page
	 */
	public function actionContact()
	{$this->layout="logn";
		$model=new ContactForm;
		if(isset($_POST['ContactForm']))
		{
			$model->attributes=$_POST['ContactForm'];
			if($model->validate())
			{
				$name='=?UTF-8?B?'.base64_encode($model->name).'?=';
				$subject='=?UTF-8?B?'.base64_encode($model->subject).'?=';
				$headers="From: $name <{$model->email}>\r\n".
					"Reply-To: {$model->email}\r\n".
					"MIME-Version: 1.0\r\n".
					"Content-type: text/plain; charset=UTF-8";

				mail(Yii::app()->params['adminEmail'],$subject,$model->body,$headers);
				Yii::app()->user->setFlash('contact','Thank you for contacting us. We will respond to you as soon as possible.');
				$this->refresh();
			}
		}
		$this->render('contact',array('model'=>$model));
	}

	/**
	 * Displays the login page
	 */
	public function actionLogin()
	{
            $this->layout="logn";
		$model=new LoginForm;

		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}

		// collect user input data
		if(isset($_POST['LoginForm']))
		{
			$model->attributes=$_POST['LoginForm'];
			// validate user input and redirect to the previous page if valid			
			if($model->validate() && $model->login()){
                            //echo Yii::app()->createUrl('/user/dashboard');
                            //$this->functionalArea = "General";
                            //var_dump(Yii::app()->user);
                           // die();
                            //$this->logMessage = "User :".$_POST['LoginForm']['username']."(".Yii::app()->user->id.") Logged In.";
                         // echo CJSON::encode(array('status'=>'200', 'redirect'=>Yii::app()->createUrl('/customer')));
                         //'url'=>'Yii::app()->createUrl("user/'.$erd.'", array("id"=>$data->id))'
                         $m=new Homepage;
                         $q=new CDbCriteria;
                         $q->compare('t.user_id',Yii::app()->user->id);
                         $h=$m->find($q);
                         if($h)
                            $home=$h->homepage;
                        else {
                            $home='user/dashboard';
                            }
                            $_SESSION['homepage']=$home;
                            $z=new Timezone;
                             $q=new CDbCriteria;
                            $q->compare('t.user_id',Yii::app()->user->id);
                            $h=$z->find($q);
                         if($h)
                            $zone=$h->zone;
                        else {
                            $zone='America/Los_Angeles';
                            }
                            //date_default_timezone_set($zone);
                            $_SESSION['time_zone']=$zone;
                            
                         //   Yii::app()->localtime->TimeZone=$zone ;
                         $this->redirect(Yii::app()->createUrl('/'.$home));
                        }else{
                            //echo CJSON::encode(array('status'=>'500', 'redirect'=>Yii::app()->createUrl('/user/dashboard')));
                        }
		}
		// display the login form
		$this->render('login',array('model'=>$model));
	}

	/**
	 * Logs out the current user and redirect to homepage.
	 */
	public function actionLogout()
	{
		Yii::app()->user->logout();
		$this->redirect(Yii::app()->homeUrl);
	}
        
public function actionUpload()
{
    var_dump($_FILES['myfile']['name']);
    $i=0;
    foreach($_FILES['myfile']['name'] as $fl)
    {
        
   echo $uploaddir =realpath( Yii::app()->basePath . '/../upload').'/'.$fl;   
   move_uploaded_file($_FILES['myfile']['tmp_name'][$i], $uploaddir);
   $i++;
    }
//$file = $uploaddir . basename($_FILES['myfile']['name']);   
   
/*if (move_uploaded_file($_FILES['myfile']['tmp_name'], $uploaddir)) 
{   
  echo "success";   
} 
else 
{  
    echo "error";  
} */ 
      
}
       
}