<?php

class CompanyformsController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column2';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			//'accessControl', // perform access control for CRUD operations
			//'postOnly + delete', // we only allow deletion via POST request
                    'rights',
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}
        public function allowedActions() {
            return 'getcompany,getutype';
        }

        /**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
            $usertype=  UserController::getTypeid(Yii::app()->user->id);
		$model=new Companyforms;
                $q=new CDbCriteria;
                $q->condition='t.id<5';
                $comptype=  Companytype::model()->findAll($q);
                $q=new CDbCriteria;
                $q->condition='t.type_id<5';
                if($usertype==1 || $usertype==2)
                 $companies=Company::model()->findAll($q);
             else {
                 $cmp=new Company;
                 $c=new CDbCriteria;
                 $c->select='t.id,t.name,t.type_id';
                 $c->join=' left join branch on branch.company_id=t.id left join user on user.branch_id=branch.id';
                 $c->compare('user.id',Yii::app()->user->id);
                 //var_dump($c);
                 $companies=$cmp->findAll($c);
                 //var_dump($companies);
                  $q=new CDbCriteria;
                  $q->condition='t.id='.$companies[0]['type_id'];
                  $comptype=  Companytype::model()->findAll($q);
             }
             $Companyformscompany=new Companyformscompany;
             $cmpformcmptype=new Companyformscompanytype;
             $cmpusertype=new Companyformsusertype;
		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Companyforms']))
		{
			$model->attributes=$_POST['Companyforms'];
                         $photos = CUploadedFile::getInstancesByName('form');
 
            // proceed if the images have been set
            if (isset($photos) && count($photos) > 0) {
 
                // go through each uploaded image
                foreach ($photos as $image => $pic) {
                    echo $pic->name.'<br />';
                    if ($pic->saveAs(Yii::getPathOfAlias('webroot').'/company_form/'.$pic->name)) {
                        // add it to the main model now
                       // $img_add = new Photo();
                        $model->form = $pic->name; //it might be $img_add->name for you, filename is just what I chose to call it in my model
                        $model->uploaded_by = Yii::app()->user->id; // this links your picture model to the main model (like your user, or profile model)
                       
 
                        $model->save(); // DONE
                    }
                    else{
                        echo 'Cannot upload!';
                    }
                }
            }
			
				//$this->redirect(array('view','id'=>$model->id));
		}

		$this->render('create',array(
			'model'=>$model,
                        'comptype'=>$comptype,
                        'companies'=>$companies,
                        'companyformscompany'=>$Companyformscompany,
                        'cmpformcmptype'=>$cmpformcmptype,
                        'cmpusertype'=>$cmpusertype,
		));
	}
        public function actionGetcompany()
        {
            $types=substr($_POST['types'],0,-1);
            $arr=explode(",",$types);
            $ty=array();
            foreach($arr as $t)
            {
             $typ = new Company;
                $c = new CDbCriteria;
				$c->select='t.id,t.name';
                $c->join = 'left join companytype on companytype.id=t.type_id';
                $c->compare('t.type_id',$t); 
                $data = $typ->findAll($c);
				
               // $data=CHtml::listData($data,'id','name'); 
               // var_dump($data);
                $ty=  array_merge($ty,$data);
            }
               echo CJSON::encode($ty);
                    Yii::app()->end();
        }
        public function actionGetutype()
        {
            //echo $_POST['cid'];
           $cid=substr($_REQUEST['cid'],0,-1);
            $arr=explode(",",$cid);
            $ty=array();
            foreach($arr as $t)
            {
             $typ = new Company;
                $c = new CDbCriteria;
                $c->select='t.type_id';
               // $c->join = 'left join companytype on companytype.id=t.type_id left join company on company.type_id=companytype.id';
                $c->condition="t.id =:cid"; 
                $c->params = array ( 
':cid' => $t,
);
               // var_dump($c);
             $data = $typ->find($c);
             $typeid.=$data->type_id.",";
        }
        //var_dump($data);
              // echo $typeid;
               if($typeid!="")
                {
                    $typeid=substr($typeid,0,-1);
                    $a=explode(",",$typeid);
                    foreach($a as $y)
                    {
                    $uty=new Usertype;
                    $c=new CDbCriteria;
                    $c->select='t.id,t.type';
                    $c->condition=' t.companytype ='.$y;
                    $daa=$uty->findAll($c);

                    $ty=  array_merge($ty,$daa);
                    }
                }
               echo CJSON::encode($ty);
                    Yii::app()->end();
        }

        /**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Companyforms']))
		{
			$model->attributes=$_POST['Companyforms'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id));
		}

		$this->render('update',array(
			'model'=>$model,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		$this->loadModel($id)->delete();

		// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
		if(!isset($_GET['ajax']))
			$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		$dataProvider=new CActiveDataProvider('Companyforms');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new Companyforms('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['Companyforms']))
			$model->attributes=$_GET['Companyforms'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer $id the ID of the model to be loaded
	 * @return Companyforms the loaded model
	 * @throws CHttpException
	 */
	public function loadModel($id)
	{
		$model=Companyforms::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param Companyforms $model the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='companyforms-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
}
