<?php

class CompanyController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column2';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			//'accessControl', // perform access control for CRUD operations
			//'postOnly + delete', // we only allow deletion via POST request
			'rights',
		);
	}
 public function allowedActions()
        { 
            return 'getBranch,getusertype,getcmp,gettpaBranch,GetBranch,Getusertype,Getcmp,GettpaBranch,getBranchList';
        }
	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update','admin','getcmp'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete','getcmp'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
        public function getState($id)
        {
              $model=new State;
               $rs=$model->findByPk($id);
               if($id==0)
                   return "Other";
               else {
                   return $rs->name;
               }
        }
	public function actionView($id)
	{
            
		$this->render('view',array(
			'model'=>$this->loadModel($id),
                        
		));
	}
         
 public function actionGetcmp(){
            
                $typ = new Company;
                $c = new CDbCriteria;
				$c->select='t.id,t.name';
                $c->join = 'left join companytype on companytype.id=t.type_id';
                $c->compare('t.type_id',$_REQUEST['Company']['type_id']); 
                $data = $typ->findAll($c);
				
                $data=CHtml::listData($data,'id','name');                
                echo CHtml::tag('option',
                               array('value'=>''),'Select',true);
				if($_POST['Company']['type_id']!="")
				{   
					foreach($data as $value=>$name)
					{
						echo CHtml::tag('option',
						array('value'=>$value),CHtml::encode($name),true);
					}
				}
        }
        public function actionGetusertype()
        {
            
             $utyp = new Usertype;
                $c = new CDbCriteria;
				$c->select='t.id,t.type';
                $c->join = 'left join companytype on companytype.id=t.companytype';
                $c->compare('t.companytype',$_POST['cmptype']); 
                $data = $utyp->findAll($c);
				
                $data=CHtml::listData($data,'id','type');                
                echo CHtml::tag('option',
                               array('value'=>''),'Select',true);
				if($_POST['cmptype']!="")
				{   
					foreach($data as $value=>$name)
					{
						echo CHtml::tag('option',
						array('value'=>$value),CHtml::encode($name),true);
					}
				}
        }
         public function actionGetBranchList()
        {
            
            $typ = new Company;
            $brc=new Branch;
                $c = new CDbCriteria;
				$c->select='t.id,t.branch_name';
                $c->join = 'left join company on company.id=t.company_id';
                $c->compare('t.company_id',$_POST['Company']['id']); 
              //  $data = $brc->findAll($c);
                 $sql= 'SELECT t.id,t.branch_name FROM branch t left join company on company.id=t.company_id '
                     . 'WHERE t.company_id = :cid ';
                $cid = $_POST['Company']['id'];
        $data= Yii::app()->db->createCommand($sql)->queryAll(true,array(':cid'=>$cid));
 
                $data=CHtml::listData($data,'id','branch_name');                
                echo CHtml::tag('option',
                               array('value'=>''),'Select',true);
				if($_POST['Company']['type_id']!="")
				{   
					foreach($data as $value=>$name)
					{
						echo CHtml::tag('option',
						array('value'=>$value),CHtml::encode($name),true);
					}
				}
        }
        
        public function actionGetBranch()
        {
            
            $typ = new Company;
            $brc=new Branch;
                $c = new CDbCriteria;
				$c->select='t.id,t.branch_name';
                $c->join = 'left join company on company.id=t.company_id';
                $c->compare('t.company_id',$_POST['Claim']['insurance_company']); 
              //  $data = $brc->findAll($c);
                 $sql= 'SELECT t.id,t.branch_name FROM branch t left join company on company.id=t.company_id '
                     . 'WHERE t.company_id = :cid ';
                $cid = $_POST['Claim']['insurance_company'];
        $data= Yii::app()->db->createCommand($sql)->queryAll(true,array(':cid'=>$cid));
 
                $data=CHtml::listData($data,'id','branch_name');                
                echo CHtml::tag('option',
                               array('value'=>''),'Select',true);
				if($_POST['Company']['type_id']!="")
				{   
					foreach($data as $value=>$name)
					{
						echo CHtml::tag('option',
						array('value'=>$value),CHtml::encode($name),true);
					}
				}
        }
        
          public function actionGettpaBranch()
        {
            
            $typ = new Company;
            $brc=new Branch;
                $c = new CDbCriteria;
				$c->select='t.id,t.branch_name';
                $c->join = 'left join company on company.id=t.company_id';
                $c->compare('t.company_id',$_POST['Claim']['tpa_company']); 
              //  $data = $brc->findAll($c);
                 $sql= 'SELECT t.id,t.branch_name FROM branch t left join company on company.id=t.company_id '
                     . 'WHERE t.company_id = :cid ';
                $cid = $_POST['Claim']['tpa_company'];
        $data= Yii::app()->db->createCommand($sql)->queryAll(true,array(':cid'=>$cid));
 
                $data=CHtml::listData($data,'id','branch_name');   
                //$arr=array("0"=>array('id'=>74,'branch_name'=>"Other"));
               // $data=  array_push($arr, $data);
                echo CHtml::tag('option',
                               array('value'=>''),'Select',true);
				if($_POST['Company']['type_id']!="")
				{   
					foreach($data as $value=>$name)
					{
						echo CHtml::tag('option',
						array('value'=>$value),CHtml::encode($name),true);
					}
                                        
				}
        }
	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model=new Company;

		// Uncomment the following line if AJAX validation is needed
		//$this->performAjaxValidation($model);

		if(isset($_POST['Company']))
		{
			$model->attributes=$_POST['Company'];
                        $model->address_1=$_POST['Company']['address_1'];
                        $model->address_2=$_POST['Company']['address_2'];
                        $model->city=$_POST['Company']['city'];
                         $companyid = Yii::app()->db->createCommand()
                                ->select('max(id) as max')
                                ->from('salesinvoice')
                                ->queryScalar();
                         $companyid=$companyid+1;
                         // file handling
                        $imageUploadFile = CUploadedFile::getInstance($model, 'file_name');
                        if($imageUploadFile !== null){ // only do if file is really uploaded
                            $imageFileName = $companyid.$imageUploadFile->name;
                            $model->file_name = $imageFileName;
                        }           
                       
			if($model->save())
                        {
                            if($imageUploadFile !== null) // validate to save file
                            { $images_path = realpath(Yii::app()->basePath . '/../company_logo');
                                   
                            $imageUploadFile->saveAs($images_path . '/' . $model->file_name);
                               // $imageUploadFile->saveAs(Article::FOLDER_IMAGE.$imageFileName);
                            }
 
                            $this->redirect(array('view','id'=>$model->id));
                        }
                        
		}
		$type=new Companytype;
                
		$types=$type->findAll('id<5',array('id','type'));
		$state=new State;
		$states=$state->findAll('',array('id','name'));
		$this->render('create',array(
			'model'=>$model,
			'types'=>$types,
			'states'=>$states,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);
                
		if(isset($_POST['Company']))
		{
			$model->attributes=$_POST['Company'];
                         // file handling
                        $imageUploadFile = CUploadedFile::getInstance($model, 'file_name');
                        if($imageUploadFile !== null){ // only do if file is really uploaded
                            $imageFileName = $id.$imageUploadFile->name;
                            $model->file_name = $imageFileName;
                        }  
			if($model->save())
                        {
                             if($imageUploadFile !== null) // validate to save file
                            { 
                                 
                                 $images_path = realpath(Yii::app()->basePath . '/../company_logo');
                                   $file=$images_path.'/'. $imageFileName;
                                 if(file_exists($file))
                                 {
                                     unlink($file);
                                 }
                            $imageUploadFile->saveAs($images_path . '/' . $model->file_name);
                               // $imageUploadFile->saveAs(Article::FOLDER_IMAGE.$imageFileName);
                            }
 
				$this->redirect(array('view','id'=>$model->id));
                        }
		}
                $type=new Companytype;
		$types=$type->findAll('id<5',array('id','type'));
		$state=new State;
		$states=$state->findAll('',array('id','name'));
		$this->render('update',array(
			'model'=>$model,
                        'types'=>$types,
			'states'=>$states,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		$this->loadModel($id)->delete();

		// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
		if(!isset($_GET['ajax']))
			$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		$dataProvider=new CActiveDataProvider('Company');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new Company('search');
		$model->unsetAttributes();  // clear any default values
                //$cond="where 1";
                	$c = new CDbCriteria;
	       $c->select="t.id,t.name,t.type_id,t.state_id";
		if(isset($_GET['Company']))
		{	$model->attributes=$_GET['Company'];
                    
                
 
              
	       $c->compare('t.type_id','='.$_GET['Company']['type_id'],true);
	       $c->compare('t.state_id','='.$_GET['Company']['state_id'],true);
		if(ltrim(rtrim($_GET['Company']['name']))!="")
                 {
                         $cond=$_GET['Company']['name'];
                         $c->compare('t.name','like'.$cond,true);
                        	//$c->condition=$cond;
                  }
                }	
				
					
				 

				$row=$model->findAll($c);
				//var_dump($c);
                $type=new Companytype;
		$types=$type->findAll('',array('id','type'));
		$state=new State;
		$states=$state->findAll('',array('id','name')); 
		$this->render('admin',array(
			'row'=>$row,
                        'model'=>$model,
                        'types'=>$types,
                        'states'=>$states,
		));
	}
  
	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer $id the ID of the model to be loaded
	 * @return Company the loaded model
	 * @throws CHttpException
	 */
	public function loadModel($id)
	{
		$model=Company::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param Company $model the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='company-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
}
