<?php

class ClaimuploadsController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column2';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
			'postOnly + delete', // we only allow deletion via POST request
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}
 
 
	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	  
	public function actionCreate()
	{
		$model=new Claimuploads;
                    $model=new Claimuploads;
                $mode=new Claimuploads;
                    $c = new CDbCriteria;
                $c->compare('claim_id',$_REQUEST['Claim_id']);
                $df = $mode->find($c);
				$size=5*1024*1024;
		// Uncomment the following line if AJAX validation is needed
		/* $this->performAjaxValidation($model);
			Yii::log("actionCreate actionCreate "  .isset($_POST['Claimuploads']));  */
				 
		if(isset($_POST['Claimuploads']))
				{   
					 /*Yii::log("actionCreate actionCreate inside if"  .isset($_POST['Claimuploads']));   
        $images = CUploadedFile::getInstancesByName('images');
        Yii::log("actionCreate actionCreate inside if"  .count($images));   
        if(isset($images) && count($images)> 0)
        {
            foreach ($images as $image=>$pic)
            {
                if ($pic->saveAs(Yii::getPathOfAlias('webroot').'/uploadtoclaim/'.$pic->name,0777))    
                {   
                     $model=new Claimuploads;
                    //$file = CUploadedFile::getInstance($model,'binaryfile');
                    $model->images = $pic->name;
                   // $model->fileType = $pic->type;
                    $url = Yii::getPathOfAlias('webroot').'/uploadtoclaim/';
                    Yii::log("actionCreate actionCreate inside if if"  .$pic->name);
                    $fp = fopen($url.$pic->name, 'r');
                    $content = fread($fp, filesize($url.$pic->name));
                    fclose($fp);
                    

					$model->claim_id=$_REQUEST['Claim_id'];
                    //$model->setIsNewRecord(true);
                    //$model->id = null;
                   // $model->image = $pic->name;
                    $model->insert();
                }               
            }
			}*/
					$model->attributes=$_POST['Claimuploads'];
                                        var_dump($_POST['Claimuploads']['images']);
					 $imageUploadFile = CUploadedFile::getInstance($model, 'images');
					var_dump($imageUploadFile); die();
					 $estimateUploadFile = CUploadedFile::getInstance($model, 'estimate');
					 $emsUploadFile = CUploadedFile::getInstance($model, 'ems');
					 $additional_filesUploadFile = CUploadedFile::getInstance($model, 'additional_files');
					 if($imageUploadFile !== null){ // only do if file is really uploaded
                            $imageFileName = $imageUploadFile->name;
                            $model->images = $imageFileName;
							if($size< $imageUploadFile->size)
								Yii::app()->user->setFlash('Imageerror','Image File size is more than 5 mb file size');
                        } 
						 if($estimateUploadFile !== null){ // only do if file is really uploaded
                            $imageFileName = $estimateUploadFile->name;
                            $model->estimate = $imageFileName;
							if($size< $estimateUploadFile->size)
								Yii::app()->user->setFlash('Estimateerror','Estimate File size is more than 5 mb file size');
                        } 
                                if($emsUploadFile !== null){ // only do if file is really uploaded
                                   $imageFileName = $emsUploadFile->name;
                                   $model->ems = $imageFileName;
				if($size< $emsUploadFile->size)
				   Yii::app()->user->setFlash('Emserror','Ems File size is more than 5 mb file size');
                        } 
						 if($additional_filesUploadFile !== null){ // only do if file is really uploaded
                            $imageFileName = $additional_filesUploadFile->name;
                            $model->additional_files = $imageFileName;
							if($size< $additional_filesUploadFile->size ) // only do if file is really uploaded
								Yii::app()->user->setFlash('Additionalerror','Additional Files File size is more than 5 mb file size');
					 
                        } 
			  
						// var_dump($imageUploadFile);
						
						
						
						
						
							
			if($model->save())
			{
							if($imageUploadFile !== null) // validate to save file
                            { 
								$images_path = realpath(Yii::app()->basePath . '/../uploadtoclaim/images');
                                   
								$imageUploadFile->saveAs($images_path . '/' . $model->images);
                               // $imageUploadFile->saveAs(Article::FOLDER_IMAGE.$imageFileName);
                            }
							if($estimateUploadFile !== null) // validate to save file
                            { 
								$images_path = realpath(Yii::app()->basePath . '/../uploadtoclaim/estimate');
                                   
								$estimateUploadFile->saveAs($images_path . '/' . $model->estimate);
                               // $imageUploadFile->saveAs(Article::FOLDER_IMAGE.$imageFileName);
                            }
 
							if($emsUploadFile !== null) // validate to save file
                            { 
								$images_path = realpath(Yii::app()->basePath . '/../uploadtoclaim/ems');
                                   
								$emsUploadFile->saveAs($images_path . '/' . $model->ems);
                               // $imageUploadFile->saveAs(Article::FOLDER_IMAGE.$imageFileName);
                            }
							if($additional_filesUploadFile !== null) // validate to save file
                            { 
								$images_path = realpath(Yii::app()->basePath . '/../uploadtoclaim/additional');
                                   
								$additional_filesUploadFile->saveAs($images_path . '/' . $model->additional_files);
                               // $imageUploadFile->saveAs(Article::FOLDER_IMAGE.$imageFileName);
                            }
                               Yii::app()->user->setFlash('success','File Uploaded Successfully');
                         
			//$this->redirect(array('view','id'=>$model->id));
		}
		}
                         $claimid=$_REQUEST['Claim_id'];
                         $claim=new Claim;        
                         $q=new CDbCriteria;
                         $q->compare("t.id",$claimid);
                       
                            $claims=$claim->find($q);
                            $this->render('create',array(
                            'model'=>$model,
                            'claim'=>$claims,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Claimuploads']))
		{
			$model->attributes=$_POST['Claimuploads'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id));
		}

		$this->render('update',array(
			'model'=>$model,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		$this->loadModel($id)->delete();

		// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
		if(!isset($_GET['ajax']))
			$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		$dataProvider=new CActiveDataProvider('Claimuploads');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new Claimuploads('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['Claimuploads']))
			$model->attributes=$_GET['Claimuploads'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer $id the ID of the model to be loaded
	 * @return Claimuploads the loaded model
	 * @throws CHttpException
	 */
	public function loadModel($id)
	{
		$model=Claimuploads::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param Claimuploads $model the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='claimuploads-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
}
