<?
include_once(DIR_MODELS."/Installer.php");
include_once(DIR_MODELS."/SetContact.php");
include_once(DIR_LIBRARY."/common/ctrform.class.php");
class InstallerCon
{
	public function __construct()
    {
        $this->tpl = Registry::get('tpl');
        $this->error = Registry::get('err');
        $this->fc = new CtrForm();
        $this->LN = Registry::get('LN');
        $this->info = Registry::get('info');
        $this->installer = new Installer();
        $this->contact = new SetContact("INSTALLER");
    }
    //funzione che salva i dati provenienti dal form di registrazione dell'installatore
    //field è l array dei campi da recuperare
    //required è l elenco dei campi obbligatori
    public function save()
    {
    	$fields = array("name","surname","phone","email","company","vat","address","city","zip","type","privacy"); //campi da importare
    	$required = array("name","surname","phone","address","city","zip","type");
    	foreach ($fields as $item)
    	{
    		$data[$item] = P::GetInput($item);
    	}
    	foreach ($required as $item)
    	{
    		$this->fc->required($data[$item], $this->LN[strtoupper($item)]);
    	}
    	$data['lang'] = LANG;
        $this->fc->email($data['email'],$this->LN['EMAIL']);
        $this->fc->privacy(P::GetInput('privacy'));
    	if ($this->fc->getErrors())
		{
			$res = array("success" => false, "errors" => $this->fc->getErrors());
		}
		else
		{
			$this->installer->save($data);
			$this->contact->fields = $data;
			$res = $this->contact->SendMailToAdmin($data);
			$res = $this->contact->SendMailToCustomer($data);
			$res =  array("success" => true);
		}
		echo json_encode($res);
	}
	//funzione che stampa il messaggio di ringraziamento al seguito del completamento del form di regitrazione
	public function thanks()
	{
		$this->tpl->assign(array(
           	"MESSAGE" => $this->contact->section['thanks_message'],
        ));
        $this->tpl->display('conferma-registrazione-installatore.html');
	}

    public function getInfo($value)
    {
		$vId = P::GetInput('id');
		$vObject = $this->installer->getObject($vId);
		$this->tpl->assign(array(
           	"OBJECT" => $vObject
        ));
		$this->tpl->display('scheda-installatore.html');
    }


    public function setVote($user,$product,$vote)
    {

    }


    public function setComment($user,$product,$comment)
    {

    }

    public function login()
    {

    }


    public function logout()
    {

    }
	//elenco degli installatori
	public function getList()
	{
		$vObjects = $this->installer->getList();
		$this->tpl->assign(array(
           	"OBJECTS" => $vObjects
        ));
        $this->tpl->display('elenco-installatori.html');
	}
	
	public function filter()
	{
		$vId = P::GetInput('id');
		if ($vId == '1')
		{
			$vObjects = $this->installer->getList("surname","asc");
		} else {
			$vObjects = $this->installer->getList("surname","desc");
		}
		$this->tpl->assign(array(
           	"OBJECTS" => $vObjects
        ));
		$this->tpl->display('inc/elenco-installatori.html');
		
	}
	
	public function profile()
	{
		$this->tpl->display('profilo-installatore.html');
	}
}


?>