<?php
/* @var $this ChildcompanyController */
/* @var $model Childcompany */

$this->breadcrumbs=array(
	'Childcompanies'=>array('index'),
	'Manage',
);

$this->menu=array(
	array('label'=>'List Childcompany', 'url'=>array('index')),
	array('label'=>'Create Childcompany', 'url'=>array('create')),
);

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$('#childcompany-grid').yiiGridView('update', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>Manage Childcompanies</h1>

<p>
You may optionally enter a comparison operator (<b>&lt;</b>, <b>&lt;=</b>, <b>&gt;</b>, <b>&gt;=</b>, <b>&lt;&gt;</b>
or <b>=</b>) at the beginning of each of your search values to specify how the comparison should be done.
</p>

<?php echo CHtml::link('Advanced Search','#',array('class'=>'search-button')); ?>
<div class="search-form" style="display:none">
<?php $this->renderPartial('_search',array(
	'model'=>$model,
)); ?>
</div><!-- search-form -->

<?php $this->widget('zii.widgets.grid.CGridView', array(
	'id'=>'childcompany-grid',
	'dataProvider'=>$model->search(),
	'filter'=>$model,
	'columns'=>array(
		'id',
		'name',
		'type_id',
		'address_1',
		'address_2',
		'city',
		/*
		'state_id',
		'zip_code',
		'phone_num',
		'fax_num',
		'work_week',
		'status',
		'file_name',
		'file_extn',
		'company_guidelines',
		'is_active',
		'is_body_shop_selection',
		'created',
		'modified',
		*/
		array(
			'class'=>'CButtonColumn',
		),
	),
)); ?>
