<?php
/* @var $this ChildbranchController */
/* @var $model Childbranch */

$this->breadcrumbs=array(
	'Childbranches'=>array('index'),
	'Manage',
);

$this->menu=array(
	array('label'=>'List Childbranch', 'url'=>array('index')),
	array('label'=>'Create Childbranch', 'url'=>array('create')),
);

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$('#childbranch-grid').yiiGridView('update', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>Manage Childbranches</h1>

<p>
You may optionally enter a comparison operator (<b>&lt;</b>, <b>&lt;=</b>, <b>&gt;</b>, <b>&gt;=</b>, <b>&lt;&gt;</b>
or <b>=</b>) at the beginning of each of your search values to specify how the comparison should be done.
</p>

<?php echo CHtml::link('Advanced Search','#',array('class'=>'search-button')); ?>
<div class="search-form" style="display:none">
<?php $this->renderPartial('_search',array(
	'model'=>$model,
)); ?>
</div><!-- search-form -->

<?php $this->widget('zii.widgets.grid.CGridView', array(
	'id'=>'childbranch-grid',
	'dataProvider'=>$model->search(),
	'filter'=>$model,
	'columns'=>array(
		'id',
		'branch_name',
		'company_id',
		'address1',
		'address2',
		'city',
		/*
		'state_id',
		'zip',
		'phone',
		'fax',
		'inspectionfee',
		'milagefee',
		'aftermiles',
		'photosonlyfee',
		'totallossfee',
		'fuelsurcharge',
		'reinspectionfee',
		'supplementfee',
		'salestax',
		'zipcodecoverage',
		'requirements',
		'created',
		'modified',
		*/
		array(
			'class'=>'CButtonColumn',
		),
	),
)); ?>
