<?php

/**
 * This is the model class for table "zip_coverage".
 *
 * The followings are the available columns in table 'zip_coverage':
 * @property integer $id
 * @property integer $user_id
 * @property integer $branch_id
 * @property integer $zipcode
 */
class ZipCoverage extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'zip_coverage';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			//array('zipcode', 'required'),
			array('user_id, branch_id, zipcode', 'numerical', 'integerOnly'=>true),
                     array('zipcode','either','other'=>'fromzip'),
                array('zipcode, branch_id', 'ECompositeUniqueValidator', 
                        'attributesToAddError'=>'zipcode',
                        'message'=>'The Zip  already exists for this Branch.'),
                
                  array('zipcode, user_id', 'ECompositeUniqueValidator', 
                        'attributesToAddError'=>'zipcode',
                        'message'=>'The Zip  already exists for this User.'),
                   
                     array('fromzip,tozip, branch_id', 'ECompositeUniqueValidator', 
                        'attributesToAddError'=>'tozip',
                        'message'=>'The Zip range already exists for this Branch.'),
             
                    array('fromzip,tozip, user_id', 'ECompositeUniqueValidator', 
                        'attributesToAddError'=>'tozip',
                        'message'=>'The Zip range already exists for this User.'),
                    
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, user_id, branch_id, zipcode', 'safe', 'on'=>'search'),
		);
	}
 public function either($attribute_name, $params)
        {
    $field1 = $this->getAttributeLabel($attribute_name);
    $field2 = $this->getAttributeLabel($params['other']);
    if (empty($this->$attribute_name) && empty($this->$params['other'])) {
        $this->addError($attribute_name, Yii::t('user', "either {$field1} or {$field2} is required."));
        return false;
    }
    return true;
        }
	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'user_id' => 'User',
			'branch_id' => 'Branch',
			'zipcode' => 'Zipcode',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('branch_id',$this->branch_id);
		$criteria->compare('zipcode',$this->zipcode);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return ZipCoverage the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
