<?php

/**
 * This is the model class for table "user".
 *
 * The followings are the available columns in table 'user':
 * @property integer $id
 * @property string $pwdslug
 * @property string $email
 * @property string $username
 * @property string $password
 * @property string $first_name
 * @property string $last_name
 * @property string $salt
 * @property integer $status
 * @property integer $user_type_id
 * @property string $homephone
 * @property string $workphone
 * @property string $cellphone
 * @property string $search_type
 * @property integer $num_claims
 * @property string $contacts
 * @property double $repareblefee
 * @property double $totallossfee
 * @property integer $created_by
 * @property integer $branch_id
 * @property string $created
 * @property string $modified
 *
 * The followings are the available model relations:
 * @property Claim[] $claims
 * @property Reopenclaim[] $reopenclaims
 * @property Reopenclaim[] $reopenclaims1
 * @property Supplement[] $supplements
 * @property Supplement[] $supplements1
 * @property Usertype $userType
 * @property Branch $branch
 * @property Useraddress[] $useraddresses
 */
class User extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return User the static model class
	 */
	 public $password2,$oldpassword,$fullname;
         public $currentPassword;
            public $newPassword;
            public $newPassword_repeat;
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'user';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('email, username, password, first_name, last_name', 'required'),
                        array('branch_id','either','other'=>'company_id'),
			array('status, user_type_id, num_claims, created_by, branch_id,is_superadmin,company_id', 'numerical', 'integerOnly'=>true),
			array('repareblefee, totallossfee,desk_totallossfee,desk_repairablefee', 'numerical'),
                    array('repareblefee, totallossfee,desk_totallossfee,desk_repairablefee', 'length','max'=>12),
			array('pwdslug', 'length', 'max'=>99),
			
                        array('oldpassword,accept', 'safe'),                        
                       
			array('first_name, last_name', 'length', 'max'=>30),
                        //array('password', 'match', 'pattern'=>'/^(?=.*[0-9])(?=.*[a-zA-Z])([a-zA-Z0-9]+)$/','message'=>'Password must be atleast 8 character long containing atleast 1 number.'),
                        array('username','match','pattern'=>'/^[a-zA-Z0-9]{4,40}$/','message'=>'username must be 4 to 40 character long and no space and special caracters'),
			array('password, salt', 'length','min'=>8, 'max'=>15),
			array('homephone, workphone, search_type', 'length', 'max'=>20),
			array('cellphone', 'length', 'max'=>20),
			  
			//array('homephone, cellphone,workphone', 'match', 'pattern'=>'/^([0-9 ]+)$/','message'=>"The phone isn't correct"),

			array('email', 'length', 'max'=>60),
                        array('email', 'email','message'=>"The email isn't correct"),
                        array('password2,accept', 'safe'),                        
                                               
                        array('username', 'unique'),   
                        array('email', 'unique','message'=>"Email is already registered with us."),
                      //  array('password2','required'),
                        array('password', 'compare', 'compareAttribute'=>'password2', 'skipOnError'=>true),
                   // array('password', 'compare', 'compareAttribute'=>'password2', 'skipOnError'=>true),
                        //array('oldpassword', 'equalPasswords','message'=>'kgk'), 
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, pwdslug,company_id, email, username, password, first_name, last_name, salt, status, user_type_id, homephone, workphone, cellphone, search_type, num_claims, contacts, repareblefee, totallossfee, created_by, branch_id,is_superadmin, created, modified', 'safe', 'on'=>'search'),
			 array(
                                        'modified','default',
                                        'value'=>date('Y-m-d H:i:s'),
                                        'setOnEmpty'=>false,'on'=>'update'
                        ),
                        array(
                                'created,modified','default',
                                'value'=>date('Y-m-d H:i:s'),
                                'setOnEmpty'=>false,'on'=>'insert'
                        ),
		);
	}
        
        public function either($attribute_name, $params)
        {
    $field1 = $this->getAttributeLabel($attribute_name);
    $field2 = $this->getAttributeLabel($params['other']);
    if (empty($this->$attribute_name) && empty($this->$params['other'])) {
        $this->addError($attribute_name, Yii::t('user', "either {$field1} or {$field2} is required."));
        return false;
    }
    return true;
        }
        public function getFullName()
   {
      return $this->first_name . " " . $this->last_name;
   }
   public static  function checkCom($id){
          $by_user=User::model()->findByPk($id);
                 $cu_user=User::model()->findByPk(Yii::app()->user->id);
                $by_utype=UserController::getTypeid($id);
                $utype=UserController::getTypeid(Yii::app()->user->id);
                 $bool=true;
             if($utype!=12 && $utype!=21 && $utype!=29 && $utype!=37 )
                                 {
                                     if($by_utype!=12 && $by_utype!=21 && $by_utype!=29 && $by_utype!=37 )
                                     {
                                        
                                            if($by_user->branch->company_id==$cu_user->branch->company_id)
                                                  $bool=true;
                                            else 
                                                $bool=false;
                                     }
                                     else
                                         if($by_user->company_id==$cu_user->branch->company_id )
                                              $bool=true;
                                         else 
                                                $bool=false;
                                 }
                                 else {
                                     if($by_utype!=12 && $by_utype!=21 && $by_utype!=29 && $by_utype!=37 )
                                     {
                                          //echo $cu_user->company_id."-".$by_user->branch->company_id;
                                         if($by_user->branch->company_id==$cu_user->company_id  )
                                              $bool=true;
                                         else 
                                                $bool=false;
                                     }
                                     else
                                     {
                                         if($by_user->branch->company_id==$cu_user->branch->company_id  )
                                              $bool=true;
                                         else 
                                                $bool=false;
                                     }
                                 }
                                 //echo $bool;
                                 return $bool;
                    
        }
        public static function getzipbasedlist($group_name,$claim_id)
        {
            
            $group_id=$group_name;
            $currentusertype=  UserController::getTypeid(Yii::app()->user->id);
            
            //$claim_id=$claim_id;
            $q=new CDbCriteria();
            $cla=new Claim();
            $q->select='t.v_zip';
            $q->compare('t.id',$claim_id);
            $cmm=$cla->find($q);
            //var_dump($cmm);
            $branch_arr=array();
            if($cmm!=null)
            {
                        $br=new Branch();
                       $q=new CDbCriteria();
                       $q->select='t.id,t.branch_name,t.zip';
                       $q->join='left join company on company.id=t.company_id';
                       $ctype=0;
                       if($group_id=='Independent Appraisal Company Branch')
                           $ctype=7;
                       if($group_id=='Body Shop Branch')
                           $ctype=3;
                       if($currentusertype>=1 && $currentusertype<=5)
                            $q->compare('company.type_id',$ctype);
                       else
                       {
                           $usr=new User();
                           $c=new CDbCriteria();
                           $c->select='t.company_id';
                           $c->join='left join user on user.branch_id=t.id';
                           $bch=$br->find($c);
                           //$q->compare('company.type_id',$ctype);
                           $q->compare('t.company_id',$bch->company_id);
                       }
                       $brch=$br->findAll($q);
                    //  var_dump($brch);
                $vehicle_zip= $cmm->v_zip;
                 $zip = new ZipLocator();
                //
                 $red=new Setredius;
                 $q=new CDbCriteria;
                 $q->compare('t.user_id',Yii::app()->user->id);
                 $rediusset=$red->find($q);
                 if($rediusset!=Null)
                     $redius=$rediusset->redius;
                 else {
                 $redius=1;    
                 }
                if($brch!=null)
                {
                    $i=0;
                    foreach($brch as $zipcode)
                    {
                       $zips = $zip->inradius($vehicle_zip, $redius,$zipcode->zip);
                      // var_dump($zips);
                       if($zips!=null)
                       {
                           
                           $temp=array($i=>array('id'=>$zipcode->id,'name'=>$zipcode->branch_name));
                           $branch_arr=  array_merge($temp,$branch_arr);
                           $i++;
                             
                       }
                    }
                }
                //var_dump($branch_arr);
                ///echo $zip->distance('92711', '92710');
                //var_export($zips);
            }
            return $branch_arr;
        }
        public static function random_string ( $type = 'numeric', $len = 8 )
	{					
		switch ( $type )
		{
			case 'alnum'	:
			case 'numeric'	:
			case 'nozero'	:
			case 'capalnum' :
			case 'alphabetical' :
					switch ($type)
					{
						case 'alnum'	:	$pool = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
							break;
						case 'capalnum'	:	$pool = '123456789ABCDEFGHIJKLMNPQRSTUVWXYZ';
							break;
						case 'numeric'	:	$pool = '0123456789';
							break;
						case 'nozero'	:	$pool = '123456789';
							break;
                                                case 'alphabetical'	:$pool = 'abcdefghijklmnopqrstuvwxyz';
                                                    break;
					}
	
					$str = '';
					for ( $i=0; $i < $len; $i++ )
					{
						$str .= substr ( $pool, mt_rand ( 0, strlen ( $pool ) -1 ), 1 );
					}
					return $str;//uniqid ($str)
			break;
			case 'unique' : return md5 ( uniqid ( mt_rand () ) );
			break;
		}
	}
 public function Getusers($typeid,$claim_id)
        {
            $typeid=$typeid;
            $currentusertype=  UserController::getTypeid(Yii::app()->user->id);
            $rs=User::model()->findByPk(Yii::app()->user->id);
           $branch_id=$rs['branch_id'];
           //$claim_id=$claim_id;
            $q=new CDbCriteria();
            $cla=new Claim();
            $q->select='t.v_zip';
            $q->compare('t.id',$claim_id);
            $cmm=$cla->find($q);
            $mode=new User();
            $q=new CDbCriteria();
            $q->select='t.id,t.first_name,t.last_name,t.branch_id';
            $q->join=" left join authassignment on authassignment.userid=t.id";
            if($currentusertype>=1 && $currentusertype<=5)//Cfs Users
            {
                $q->compare('authassignment.itemname',$typeid);
            }
            else
            {
                $q->compare('authassignment.itemname',$typeid);
                $q->compare('t.branch_id',$branch_id);
            }
            
           // var_dump($q);
            $result=$mode->findAll($q);
            if($typeid==50 || ($currentusertype>=1 && $currentusertype<=5) )//CFS APPRAISER and for global user according to zip code
            {
                $vehicle_zip= $cmm->v_zip;
                 $zip = new ZipLocator();
                //
                 $red=new Setredius;
                 $q=new CDbCriteria;
                 $q->compare('t.user_id',Yii::app()->user->id);
                 $rediusset=$red->find($q);
                 if($rediusset!=Null)
                     $redius=$rediusset->redius;
                 else {
                 $redius=1;    
                 }
                if($result!=null)
                { $arr=array();
                    $i=0;
                    foreach($result as $rs)
                    {
                     /*   if($rs->branch_id!='')
                        {  
                            $zipcode=  Branch::model()->findByPk($rs->branch_id);
                           // var_dump($zipcode);
                            //echo "<br/>";
                           // echo $zipcode->zip;
                                $zips = $zip->inradius($vehicle_zip, $redius,$zipcode->zip);
                             //   var_dump($zips);
                               // if($zips!=null)
                                //{

                                    $temp=array($i=>array('id'=>$rs->id,'first_name'=>$rs->first_name,'last_name'=>$rs->last_name));
                                    $arr= array_merge($temp,$arr);
                                    $i++;

                               // }
                        }*/
                         if($rs->branch_id!='')
                        {  
                            $zipcode=  Branch::model()->findByPk($rs->branch_id);
                           // var_dump($zipcode);
                            //echo "<br/>";
                           // echo $zipcode->zip;
                                $zips = $zip->getzipcodes($rs->branch_id);//($vehicle_zip, 1,$zipcode->zip);
                             //   var_dump($zips);
                                
                                if($zips!=null)
                                {
                                    foreach($zips as $z)
                                    {
                                        if($z->fromzip<$z->tozip)
                                            {
                                                $frm=$z->fromzip;
                                                $to=$z->tozip;
                                            }
                                             else {
                                                 $frm=$z->tozip;
                                                 $to=$z->fromzip;
                                             }
                                                if($z->zipcode==$vehicle_zip || ($frm<=$vehicle_zip && $to>=$vehicle_zip))

                                                {
                                                        $temp=array($i=>array('id'=>$rs->id,'first_name'=>$rs->first_name,'last_name'=>$rs->last_name));
                                                        $arr= array_merge($temp,$arr);
                                                        $i++;
                                                }
                                    }
                                }
                        }
                    }
                }
                
            }
 else {
            $arr=array();
            $j=0;
            foreach($result as $r)
            {$temp=array();
                $temp=array($j=>array('id'=>$r->id,'first_name'=>$r->first_name,'last_name'=>$r->last_name));
               
                $arr= array_merge($arr,$temp);
                // var_dump($arr);
        $j++;
            }
 }
 return $arr;
        }
        /**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			//'claims' => array(self::HAS_MANY, 'Claim', 'created_by'),
			//'reopenclaims' => array(self::HAS_MANY, 'Reopenclaim', 'open_by'),
			//'reopenclaims1' => array(self::HAS_MANY, 'Reopenclaim', 'closed_by'),
			//'supplements' => array(self::HAS_MANY, 'Supplement', 'created_by'),
			//'supplements1' => array(self::HAS_MANY, 'Supplement', 'closed_by'),
			//'userType' => array(self::BELONGS_TO, 'Usertype', 'user_type_id'),
			//'userCategory' => array(self::BELONGS_TO, 'Usercategory', 'category_id'),
			'branch' => array(self::BELONGS_TO, 'Branch', 'branch_id'),
                        'company' => array(self::BELONGS_TO, 'Company', 'company_id'),//For Company Admins and global users(CFS) branch_id will store company id
			'useraddresses' => array(self::HAS_ONE, 'Useraddress', 'user_id'),
			'authassignment' => array(self::HAS_ONE,  'Authassignment', 'userid'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'pwdslug' => 'Pwdslug',
			'email' => 'Email',
			'username' => 'Username',
			'password' => 'Password',
			'first_name' => 'First Name',
			'last_name' => 'Last Name',
			'salt' => 'Salt',
			'status' => 'Status',
			'user_type_id' => 'User Type',
			'category_id'=>'Category',
			'homephone' => 'Home Phone',
			'workphone' => 'Work Phone',
			'cellphone' => 'Cell Phone',
			'search_type' => 'Search Type',
			'num_claims' => 'Number Of Claims',
			'contacts' => 'Contacts',
			'repareblefee' => 'Repairable Fee',
			'totallossfee' => 'Total Loss Fee',
                        'desk_repairablefee'=>'Desk Reviewer Repairable Fee',
                        'desk_totallossfee'=>'Desk Reviewer Total Loss Fee',
			'created_by' => 'Created By',
			'branch_id' => 'Branch',
			'created' => 'Created',
			'modified' => 'Modified',
                        'is_superadmin'=>'Is Super Admin',
                        'company_id'=>'Company',
                        
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('pwdslug',$this->pwdslug,true);
		$criteria->compare('email',$this->email,true);
		$criteria->compare('username',$this->username,true);
		$criteria->compare('password',$this->password,true);
		$criteria->compare('first_name',$this->first_name,true);
		$criteria->compare('last_name',$this->last_name,true);
		$criteria->compare('salt',$this->salt,true);
		$criteria->compare('status',$this->status);
		//$criteria->compare('user_type_id',$this->user_type_id);
		$criteria->compare('homephone',$this->homephone,true);
		$criteria->compare('workphone',$this->workphone,true);
		$criteria->compare('cellphone',$this->cellphone,true);
		$criteria->compare('search_type',$this->search_type,true);
		$criteria->compare('num_claims',$this->num_claims);
		$criteria->compare('contacts',$this->contacts,true);
		$criteria->compare('repareblefee',$this->repareblefee);
		$criteria->compare('totallossfee',$this->totallossfee);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('branch_id',$this->branch_id);
		$criteria->compare('created',$this->created,true);
		$criteria->compare('modified',$this->modified,true);
                $criteria->compare('is_superadmin',$this->is_superadmin,true);
                    if(isset($this->user_type_id))
                    {
                         $criteria->join="inner join authassignment on authassignment.userid=t.id";
                         $criteria->compare('authassignment.itemname',  $this->user_type_id);
                         
                    }
                    $criteria->join="inner join authassignment on authassignment.userid=t.id ";
                    
                    if(isset($_REQUEST['User']))
                        $criteria->condition.=' and t.id<>9';
                    else
                        $criteria->condition='t.id<>9';
                                                
                  //  $criteria->order=" t.first_name,t.last_name ASC";
                   // $criteria->condition=' authassignment.itemname<44 || authassignment.itemname>49 ';
                  // var_dump($criteria);
		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
                    'sort'=>array(
                        'defaultOrder'=>'t.first_name,t.last_name ASC',
            'attributes'=>array(
                'first_name',
                'last_name',
                'username',
                      'authassignment'=>array('asc' =>'utype.type ASC',
                     'desc'=>'utype.type DESC',),                          
            ),
             
        ),
                                                
		));
	}
        
}