<?php

/**
 * This is the model class for table "temp".
 *
 * The followings are the available columns in table 'temp':
 * @property integer $id
 * @property integer $company_id
 * @property integer $c_invoice_id
 * @property double $c_invoice_amt
 * @property double $c_pay_amount
 * @property double $c_balance
 * @property integer $p_no_claims
 * @property double $p_claim_price
 * @property double $p_total
 * @property double $p_pre_discount
 * @property double $p_disc_amt
 * @property double $p_invoice_total
 * @property double $p_pay_amt
 * @property double $a_pay_amt
 * @property string $a_occurance
 * @property double $a_auto_disc
 * @property double $global_discount
 * @property double $global_pay
 * @property integer $by_user
 * @property string $created
 */
class Temp extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'temp';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('company_id, global_pay, by_user, created', 'required'),
			array('company_id, c_invoice_id, p_no_claims, by_user', 'numerical', 'integerOnly'=>true),
			array('c_invoice_amt, c_pay_amount, c_balance, p_claim_price, p_total, p_pre_discount, p_disc_amt, p_invoice_total, p_pay_amt, a_pay_amt, a_auto_disc, global_discount, global_pay', 'numerical'),
			array('a_occurance', 'length', 'max'=>50),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, company_id, c_invoice_id, c_invoice_amt, c_pay_amount, c_balance, p_no_claims, p_claim_price, p_total, p_pre_discount, p_disc_amt, p_invoice_total, p_pay_amt, a_pay_amt, a_occurance, a_auto_disc, global_discount, global_pay, by_user, created', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'company_id' => 'Company',
			'c_invoice_id' => 'C Invoice',
			'c_invoice_amt' => 'C Invoice Amt',
			'c_pay_amount' => 'C Pay Amount',
			'c_balance' => 'C Balance',
			'p_no_claims' => 'P No Claims',
			'p_claim_price' => 'P Claim Price',
			'p_total' => 'P Total',
			'p_pre_discount' => 'P Pre Discount',
			'p_disc_amt' => 'P Disc Amt',
			'p_invoice_total' => 'P Invoice Total',
			'p_pay_amt' => 'P Pay Amt',
			'a_pay_amt' => 'A Pay Amt',
			'a_occurance' => 'A Occurance',
			'a_auto_disc' => 'A Auto Disc',
			'global_discount' => 'Global Discount',
			'global_pay' => 'Global Pay',
			'by_user' => 'By User',
			'created' => 'Created',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('company_id',$this->company_id);
		$criteria->compare('c_invoice_id',$this->c_invoice_id);
		$criteria->compare('c_invoice_amt',$this->c_invoice_amt);
		$criteria->compare('c_pay_amount',$this->c_pay_amount);
		$criteria->compare('c_balance',$this->c_balance);
		$criteria->compare('p_no_claims',$this->p_no_claims);
		$criteria->compare('p_claim_price',$this->p_claim_price);
		$criteria->compare('p_total',$this->p_total);
		$criteria->compare('p_pre_discount',$this->p_pre_discount);
		$criteria->compare('p_disc_amt',$this->p_disc_amt);
		$criteria->compare('p_invoice_total',$this->p_invoice_total);
		$criteria->compare('p_pay_amt',$this->p_pay_amt);
		$criteria->compare('a_pay_amt',$this->a_pay_amt);
		$criteria->compare('a_occurance',$this->a_occurance,true);
		$criteria->compare('a_auto_disc',$this->a_auto_disc);
		$criteria->compare('global_discount',$this->global_discount);
		$criteria->compare('global_pay',$this->global_pay);
		$criteria->compare('by_user',$this->by_user);
		$criteria->compare('created',$this->created,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Temp the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
