<?php

class StatusofclaimController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column2';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			//'accessControl', // perform access control for CRUD operations
			//'postOnly + delete', // we only allow deletion via POST request
                    'rights',
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
                $claim_id=$_REQUEST['Claim_id'];
                $claim=  Claim::model()->findByPk($claim_id);
		$model=new Statusofclaim;
                $ass=new Assignee;
                
                $q=new CDbCriteria;
                $q->compare('t.claim_id',$claim_id);
                $q->compare('t.active',1);
		$assignee=$ass->find($q);
                if($assignee!=null)
                {   
                    $ass_type=$assignee->assignee_type;
                    $ass_user=$assignee->assign_to;
                }
               
                // Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);
                if(isset($_SESSION["FORM_SECRET"])) 
                {
	
	
                if($_SESSION["FORM_SECRET"]==$_POST['form_secret']) 
                {
                    if(isset($_POST['Statusofclaim']))
                    {
                        //var_dump($_POST['adjuster']);
			$model->attributes=$_POST['Statusofclaim'];
                        $model->created_by=Yii::app()->user->id;
			if($model->save())
                        {
                            $emailto="";
                            if(count($_POST['email'])>0)
                            {
                                foreach($_POST['email'] as $e)
                                {
                                    if($emailto!='')
                                       $emailto=$emailto.",".$e;
                                   else
                                       $emailto=$e;
                                }
                            }
                            if($_POST['adjuster']!=null)
                            {
                                if($claim->adjustor_id!=0)
                                {
                                    $us=new User;
                                    
                                    $q=new CDbCriteria;
                                    $q->select='t.email';
                                    $q->compare('t.id',$claim->adjustor_id);
                                   $uemail=$us->find($q);
                                   if($emailto!='')
                                       $emailto=$emailto.",".$uemail->email;
                                   else
                                   $emailto=$uemail->email;
                                }
                                if($claim->tpa_adjuster!=0)
                                {
                                    $us=new User;
                                    
                                    $q=new CDbCriteria;
                                    $q->select='t.email';
                                    $q->compare('t.id',$claim->tpa_adjuster);
                                   $uemail=$us->find($q);
                                   if($emailto!='')
                                       $emailto=$emailto.",".$uemail->email;
                                   else
                                     $emailto=$uemail->email;
                                }
                            }
                            
                            if($_POST['adjustersupervisor']!=null)
                            {
                                $sup=new Adjstersupervising;
                                $q=new CDbCriteria;
                                $tpa=0;
                                if($claim->tpa_adjuster!=null or $claim->tpa_adjuster!='')
                                    $tpa=$claim->tpa_adjuster;
                                
                           
                                $q->condition='t.adjuster_id='.$claim->adjustor_id.' or t.adjuster_id='.$tpa;
                                $superwisers=$sup->findAll($q);
                                if($superwisers!=null)
                                {
                                    foreach($superwisers as $s)
                                    {
                                        $us=new User;
                                    
                                        $q=new CDbCriteria;
                                        $q->select='t.email';
                                        $q->compare('t.id',$s->superwiser_id);
                                       $uemail=$us->find($q);
                                       if($emailto!='')
                                           $emailto=$emailto.",".$uemail->email;
                                       else
                                         $emailto=$uemail->email;
                                    }
                                }
                            }
                            
                            if($_POST['office']!='')
                            {
                                if($claim->branch_id!=0)
                                {
                                        $us=new User;
                                    
                                        $q=new CDbCriteria;
                                        $q->select='t.email';
                                        $q->join=' left join authassignment on authassignment.userid=t.id';
                                       // $q->compare('t.branch_id',$claim->branch_id);
                                        $q->condition=' (t.branch_id='
                                                .$claim->branch_id. ') and (authassignment.itemname=22 or authassignment.itemname=23) ';
                                       $um=$us->findAll($q);
                                       foreach ($um as $uemail)
                                       {
                                       if($emailto!='')
                                           $emailto=$emailto.",".$uemail->email;
                                       else
                                         $emailto=$uemail->email;
                                       }
                                }
                            }
                            if($assignee->assignee_type==7 || $assignee->assignee_type==18 )
                            {
                                if($_POST['appraiser']!=null)
                                {
                                    $us=new User;
                                    
                                        $q=new CDbCriteria;
                                        $q->select='t.email';
                                        $q->compare('t.id',$assignee->assign_to);
                                       $uemail=$us->find($q);
                                       if($emailto!='')
                                           $emailto=$emailto.",".$uemail->email;
                                       else
                                         $emailto=$uemail->email;
                                }  
                            }
                             if($assignee->assignee_type==17 || $assignee->assignee_type==24 || $assignee->assignee_type==11  )
                            {
                                if($_POST['deskreviewer']!=null)
                                {
                                    $us=new User;
                                    
                                        $q=new CDbCriteria;
                                        $q->select='t.email';
                                        $q->compare('t.id',$assignee->assign_to);
                                       $uemail=$us->find($q);
                                       if($emailto!='')
                                           $emailto=$emailto.",".$uemail->email;
                                       else
                                         $emailto=$uemail->email;
                                }  
                            }
                            if($_POST['owner']!=null)
                            {
                                if($claim->o_email!=null)
                                {
                                    if($emailto!='')
                                           $emailto=$emailto.",".$claim->o_email;
                                       else
                                         $emailto=$claim->o_email;
                                }
                            }
                             if($_POST['claimant']!=null)
                            {
                                if($claim->c_email!=null)
                                {
                                    if($emailto!='')
                                           $emailto=$emailto.",".$claim->c_email;
                                       else
                                         $emailto=$claim->c_email;
                                }
                            }
                            if($_POST['insured']!=null)
                            {
                                if($claim->i_email!=null)
                                {
                                    if($emailto!='')
                                           $emailto=$emailto.",".$claim->i_email;
                                       else
                                         $emailto=$claim->i_email;
                                }
                            }
                             echo $emailto;
                             die();
                            $message=$_POST['Statusofclaim']['status'];
                            if($emailto!='')
                              $this->letsMail($emailto,'test@claimflowsolutions.com','noreply@claimflowsolutions.com','Claim Status',3,$message);
                        }
				//$this->redirect(array('view','id'=>$model->id));
		}
                }}
                 $secret=md5(uniqid(rand(), true));
	$_SESSION['FORM_SECRET'] = $secret;
	$form_secret = isset($_POST["form_secret"])?$_POST["form_secret"]:'';
                $sta=new Statusofclaim;
                $q=new CDbCriteria;
                $q->condition='t.claim_id='.$_REQUEST['Claim_id'];
                $q->order=' t.created DESC ';
               // var_dump($q);
                $status=$sta->findAll($q);
		$this->render('create',array(
			'model'=>$model,
                        'claim'=>$claim,
                        'assignee'=>$assignee,
                        'status'=>$status,
		));
	}

        public function allowedActions() {
            return 'changestatus,deletestatus';
        }
        public function actionChangestatus()
        {
            $id=$_POST['id'];
            $model= Statusofclaim::model()->findByPk($id);
            $claim_id=$model->claim_id;
            $claim=  Claim::model()->findByPk($claim_id);
		
                $ass=new Assignee;
                
                $q=new CDbCriteria;
                $q->compare('t.claim_id',$claim_id);
                $q->compare('t.active',1);
		$assignee=$ass->find($q);
                if($assignee!=null)
                {   
                    $ass_type=$assignee->assignee_type;
                    $ass_user=$assignee->assign_to;
                }
                $emailto="";
                if($_POST['other']!="")
                {
                     $em=explode(",",$_POST['other']);
                     foreach($em as $e)
                     {
                         if($e!="")
                         {
                              
                                    if($emailto!='')
                                       $emailto=$emailto.",".$e;
                                   else
                                       $emailto=$e;
                                
                         }
                     }
                    
                }
            if($_POST['allVals']!=null)
            {
               // $allVals=explode(",",$_POST['allVals']);
               // var_dump($_POST['allVals']);
                
                foreach($_POST['allVals'] as $e)
                {
                   
                        
                     
                           
                             if($e=="Adjuster")
                            {
                                if($claim->adjustor_id!=0)
                                {
                                    $us=new User;
                                    
                                    $q=new CDbCriteria;
                                    $q->select='t.email';
                                    $q->compare('t.id',$claim->adjustor_id);
                                   $uemail=$us->find($q);
                                   if($emailto!='')
                                       $emailto=$emailto.",".$uemail->email;
                                   else
                                   $emailto=$uemail->email;
                                }
                                if($claim->tpa_adjuster!=0)
                                {
                                    $us=new User;
                                    
                                    $q=new CDbCriteria;
                                    $q->select='t.email';
                                    $q->compare('t.id',$claim->tpa_adjuster);
                                   $uemail=$us->find($q);
                                   if($emailto!='')
                                       $emailto=$emailto.",".$uemail->email;
                                   else
                                     $emailto=$uemail->email;
                                }
                            }
                            
                            if($e=="Adjuster Supervisor")
                            {
                                $sup=new Adjstersupervising;
                                $q=new CDbCriteria;
                                $tpa=0;
                                if($claim->tpa_adjuster!=null or $claim->tpa_adjuster!='')
                                    $tpa=$claim->tpa_adjuster;
                                
                           
                                $q->condition='t.adjuster_id='.$claim->adjustor_id.' or t.adjuster_id='.$tpa;
                                $superwisers=$sup->findAll($q);
                                if($superwisers!=null)
                                {
                                    foreach($superwisers as $s)
                                    {
                                        $us=new User;
                                    
                                        $q=new CDbCriteria;
                                        $q->select='t.email';
                                        $q->compare('t.id',$s->superwiser_id);
                                       $uemail=$us->find($q);
                                       if($emailto!='')
                                           $emailto=$emailto.",".$uemail->email;
                                       else
                                         $emailto=$uemail->email;
                                    }
                                }
                            }
                            
                            if($e=="Office")
                            {
                                if($claim->branch_id!=0)
                                {
                                        $us=new User;
                                    
                                        $q=new CDbCriteria;
                                        $q->select='t.email';
                                        $q->join=' left join authassignment on authassignment.userid=t.id';
                                       // $q->compare('t.branch_id',$claim->branch_id);
                                        $q->condition=' (t.branch_id='
                                                .$claim->branch_id. ') and (authassignment.itemname=22 or authassignment.itemname=23) ';
                                       $um=$us->findAll($q);
                                       foreach ($um as $uemail)
                                       {
                                       if($emailto!='')
                                           $emailto=$emailto.",".$uemail->email;
                                       else
                                         $emailto=$uemail->email;
                                       }
                                }
                            }
                            if($assignee->assignee_type==7 || $assignee->assignee_type==18 )
                            {
                                if($e=="Appraiser")
                                {
                                    $us=new User;
                                    
                                        $q=new CDbCriteria;
                                        $q->select='t.email';
                                        $q->compare('t.id',$assignee->assign_to);
                                       $uemail=$us->find($q);
                                       if($emailto!='')
                                           $emailto=$emailto.",".$uemail->email;
                                       else
                                         $emailto=$uemail->email;
                                }  
                            }
                             if($assignee->assignee_type==17 || $assignee->assignee_type==24 || $assignee->assignee_type==11  )
                            {
                                if($e=="Desk Reviewer")
                                {
                                    $us=new User;
                                    
                                        $q=new CDbCriteria;
                                        $q->select='t.email';
                                        $q->compare('t.id',$assignee->assign_to);
                                       $uemail=$us->find($q);
                                       if($emailto!='')
                                           $emailto=$emailto.",".$uemail->email;
                                       else
                                         $emailto=$uemail->email;
                                }  
                            }
                            if($e=="Owner")
                            {
                                if($claim->o_email!=null)
                                {
                                    if($emailto!='')
                                           $emailto=$emailto.",".$claim->o_email;
                                       else
                                         $emailto=$claim->o_email;
                                }
                            }
                             if($e=="Claimant")
                            {
                                if($claim->c_email!=null)
                                {
                                    if($emailto!='')
                                           $emailto=$emailto.",".$claim->c_email;
                                       else
                                         $emailto=$claim->c_email;
                                }
                            }
                            if($e=="Insured")
                            {
                                if($claim->i_email!=null)
                                {
                                    if($emailto!='')
                                           $emailto=$emailto.",".$claim->i_email;
                                       else
                                         $emailto=$claim->i_email;
                                }
                            }
                }
            }
           //  echo $_POST['status'];
            Statusofclaim::model()->updateAll(array('status'=>$_POST['status']), 'id='.$id) ;
        }

        /**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Statusofclaim']))
		{
			$model->attributes=$_POST['Statusofclaim'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id));
		}

		$this->render('update',array(
			'model'=>$model,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
        public function actionDeletestatus()
        {
            $id=$_POST['id'];
            $this->loadModel($id)->delete();
        }
        public function actionDelete($id)
	{
		$this->loadModel($id)->delete();

		// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
		if(!isset($_GET['ajax']))
			$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		$dataProvider=new CActiveDataProvider('Statusofclaim');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new Statusofclaim('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['Statusofclaim']))
			$model->attributes=$_GET['Statusofclaim'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer $id the ID of the model to be loaded
	 * @return Statusofclaim the loaded model
	 * @throws CHttpException
	 */
	public function loadModel($id)
	{
		$model=Statusofclaim::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param Statusofclaim $model the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='statusofclaim-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
}
