<?php

/**
 * This is the model class for table "payments".
 *
 * The followings are the available columns in table 'payments':
 * @property integer $id
 * @property integer $company_id
 * @property integer $branch_id
 * @property string $net_transaction_id
 * @property integer $auto_id
 * @property integer $pre_purchase_id
 * @property integer $transaction_id
 * @property double $total_amt
 * @property string $discount_code
 * @property integer $created_by
 * @property string $created
 * @property string $modified
 */
class Payments extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'payments';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('company_id, net_transaction_id, total_amt,  created_by', 'required'),
			array('company_id, branch_id, auto_id, pre_purchase_id, transaction_id, created_by', 'numerical', 'integerOnly'=>true),
			array('total_amt', 'numerical'),
			array('net_transaction_id, discount_code', 'length', 'max'=>50),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, company_id, branch_id, net_transaction_id, auto_id, pre_purchase_id, transaction_id, total_amt, discount_code, created_by, created, modified', 'safe', 'on'=>'search'),
                          array(
                                        'modified','default',
                                        'value'=>date('Y-m-d H:i:s'),
                                        'setOnEmpty'=>false,'on'=>'update'
                        ),
                        array(
                                'created,modified','default',
                                'value'=>date('Y-m-d H:i:s'),
                                'setOnEmpty'=>false,'on'=>'insert'
                        ),
                    );
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'company_id' => 'Company',
			'branch_id' => 'Branch',
			'net_transaction_id' => 'Net Transaction',
			'auto_id' => 'Auto',
			'pre_purchase_id' => 'Pre Purchase',
			'transaction_id' => 'Transaction',
			'total_amt' => 'Total Amt',
			'discount_code' => 'Discount Code',
			'created_by' => 'Created By',
			'created' => 'Created',
			'modified' => 'Modified',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('company_id',$this->company_id);
		$criteria->compare('branch_id',$this->branch_id);
		$criteria->compare('net_transaction_id',$this->net_transaction_id,true);
		$criteria->compare('auto_id',$this->auto_id);
		$criteria->compare('pre_purchase_id',$this->pre_purchase_id);
		$criteria->compare('transaction_id',$this->transaction_id);
		$criteria->compare('total_amt',$this->total_amt);
		$criteria->compare('discount_code',$this->discount_code,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created',$this->created,true);
		$criteria->compare('modified',$this->modified,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Payments the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
