<?php

/**
 * This is the model class for table "pay_account".
 *
 * The followings are the available columns in table 'pay_account':
 * @property integer $id
 * @property string $username
 * @property string $password
 * @property string $card_type
 * @property string $card_number
 * @property integer $expiry_month
 * @property integer $expiry_year
 * @property integer $verification_number
 * @property integer $user_id
 * @property string $created
 * @property string $modified
 */
class Payaccount extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'pay_account';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('card_type, user_id, created, modified', 'required'),
			array('expiry_month, expiry_year, verification_number, user_id', 'numerical', 'integerOnly'=>true),
			array('username, password, card_type, card_number', 'length', 'max'=>50),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, username, password, card_type, card_number, expiry_month, expiry_year, verification_number, user_id, created, modified', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'username' => 'Username',
			'password' => 'Password',
			'card_type' => 'Card Type',
			'card_number' => 'Card Number',
			'expiry_month' => 'Expiry Month',
			'expiry_year' => 'Expiry Year',
			'verification_number' => 'Verification Number',
			'user_id' => 'User',
			'created' => 'Created',
			'modified' => 'Modified',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('username',$this->username,true);
		$criteria->compare('password',$this->password,true);
		$criteria->compare('card_type',$this->card_type,true);
		$criteria->compare('card_number',$this->card_number,true);
		$criteria->compare('expiry_month',$this->expiry_month);
		$criteria->compare('expiry_year',$this->expiry_year);
		$criteria->compare('verification_number',$this->verification_number);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('created',$this->created,true);
		$criteria->compare('modified',$this->modified,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Payaccount the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
