<?php

/**
 * This is the model class for table "lossinfo".
 *
 * The followings are the available columns in table 'lossinfo':
 * @property integer $id
 * @property string $loss_reference_num
 * @property string $loss_location
 * @property integer $loss_phone_number
 * @property double $loss_amount
 * @property integer $claim_id
 * @property string $created
 * @property string $modified
 *
 * The followings are the available model relations:
 * @property Claim $claim
 */
class Lossinfo extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Lossinfo the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'lossinfo';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('claim_id', 'required'),
			array('claim_id', 'numerical', 'integerOnly'=>true),
			array('loss_amount', 'numerical'),
			array('loss_reference_num', 'length', 'max'=>30),
			array('loss_location', 'length', 'max'=>40),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, loss_reference_num, loss_location, loss_phone_number, loss_amount, claim_id, created, modified', 'safe', 'on'=>'search'),
		
                    array(
                                        'modified','default',
                                        'value'=>date('Y-m-d H:i:s'),
                                        'setOnEmpty'=>false,'on'=>'update'
                        ),
                        array(
                                'created,modified','default',
                                'value'=>date('Y-m-d H:i:s'),
                                'setOnEmpty'=>false,'on'=>'insert'
                        ),
                    );
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'claim' => array(self::BELONGS_TO, 'Claim', 'claim_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'loss_reference_num' => 'Pw Reference Num',
			'loss_location' => 'Pw Location',
			'loss_phone_number' => 'Pw Phone Number',
			'loss_amount' => 'Pw Amount',
			'claim_id' => 'Claim',
			'created' => 'Created',
			'modified' => 'Modified',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('loss_reference_num',$this->loss_reference_num,true);
		$criteria->compare('loss_location',$this->loss_location,true);
		$criteria->compare('loss_phone_number',$this->loss_phone_number);
		$criteria->compare('loss_amount',$this->loss_amount);
		$criteria->compare('claim_id',$this->claim_id);
		$criteria->compare('created',$this->created,true);
		$criteria->compare('modified',$this->modified,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}