<?php

/**
 * This is the model class for table "flag_bodymanheper".
 *
 * The followings are the available columns in table 'flag_bodymanheper':
 * @property integer $id
 * @property integer $flag_id
 * @property string $log_hours
 * @property string $reason
 * @property string $created
 * @property string $modified
 */
class Flagbodymanheper extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'flag_bodymanheper';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('flag_id, log_hours, reason,userid', 'required'),
			array('flag_id', 'numerical', 'integerOnly'=>true),
			array('log_hours', 'length', 'max'=>500),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, flag_id, log_hours, reason, created, modified', 'safe', 'on'=>'search'),
			 array(
                                        'modified','default',
                                        'value'=>date('Y-m-d H:i:s'),
                                        'setOnEmpty'=>false,'on'=>'update'
                        ),
                        array(
                                'created,modified','default',
                                'value'=>date('Y-m-d H:i:s'),
                                'setOnEmpty'=>false,'on'=>'insert'
                        ),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		 'user' => array(self::BELONGS_TO, 'User', 'userid'),
		   'flags' => array(self::HAS_MANY, 'Flag', 'flag_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'flag_id' => 'Flag',
			'log_hours' => 'Log Hours',
			'reason' => 'Reason',
			'created' => 'Created',
			'modified' => 'Modified',
			'userid'=>'Body Man Helper',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('flag_id',$this->flag_id);
		$criteria->compare('userid',$this->userid);
		$criteria->compare('log_hours',$this->log_hours,true);
		$criteria->compare('reason',$this->reason,true);
		$criteria->compare('created',$this->created,true);
		$criteria->compare('modified',$this->modified,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Flagbodymanheper the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
