<?php

/**
 * This is the model class for table "contactletter".
 *
 * The followings are the available columns in table 'contactletter':
 * @property integer $id
 * @property integer $claim_id
 * @property string $name
 * @property string $address_line_1
 * @property string $address_line_2
 * @property string $claim_number
 * @property string $file_number
 * @property string $insured
 * @property string $claimant
 * @property string $owner_name
 * @property string $message
 * @property string $contact_date
 * @property string $thank_you
 * @property string $created
 * @property string $modified
 */
class Contactletter extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'contactletter';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('claim_id, claim_number, file_number, message, contact_date, thank_you', 'required'),
			array('claim_id', 'numerical', 'integerOnly'=>true),
			array('name, address_line_1, claim_number, file_number, insured, claimant, owner_name, thank_you', 'length', 'max'=>500),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, claim_id, name, address_line_1, address_line_2, claim_number, file_number, insured, claimant, owner_name, message, contact_date, thank_you, created, modified', 'safe', 'on'=>'search'),
                         array(
                                        'modified','default',
                                        'value'=>date('Y-m-d H:i:s'),
                                        'setOnEmpty'=>false,'on'=>'update'
                        ),
                        array(
                                'created,modified','default',
                                'value'=>date('Y-m-d H:i:s'),
                                'setOnEmpty'=>false,'on'=>'insert'
                        ),
                    
                    
                    );
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'claim_id' => 'Claim',
			'name' => 'Name',
			'address_line_1' => 'Address Line 1',
			'address_line_2' => 'Address Line 2',
			'claim_number' => 'Claim Number',
			'file_number' => 'File Number',
			'insured' => 'Insured',
			'claimant' => 'Claimant',
			'owner_name' => 'Owner Name',
			'message' => 'Message',
			'contact_date' => 'Contact Date',
			'thank_you' => 'Thank You',
			'created' => 'Created',
			'modified' => 'Modified',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('claim_id',$this->claim_id);
		$criteria->compare('name',$this->name,true);
		$criteria->compare('address_line_1',$this->address_line_1,true);
		$criteria->compare('address_line_2',$this->address_line_2,true);
		$criteria->compare('claim_number',$this->claim_number,true);
		$criteria->compare('file_number',$this->file_number,true);
		$criteria->compare('insured',$this->insured,true);
		$criteria->compare('claimant',$this->claimant,true);
		$criteria->compare('owner_name',$this->owner_name,true);
		$criteria->compare('message',$this->message,true);
		$criteria->compare('contact_date',$this->contact_date,true);
		$criteria->compare('thank_you',$this->thank_you,true);
		$criteria->compare('created',$this->created,true);
		$criteria->compare('modified',$this->modified,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Contactletter the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
