<?php

/**
 * This is the model class for table "company_forms_company".
 *
 * The followings are the available columns in table 'company_forms_company':
 * @property integer $id
 * @property integer $company_form_id
 * @property integer $company_id
 */
class Companyformscompany extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'company_forms_company';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('company_form_id, company_id', 'required'),
			array('company_form_id, company_id', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, company_form_id, company_id', 'safe', 'on'=>'search'),
		);
	}
        
	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    
		);
	}
        public static  function getFormcompanies($fid)
        {
            $c=new Company;
            $q=new CDbCriteria;
            $q->select='t.id';
            $q->join=' left join company_forms_company on company_forms_company.company_id=t.id';
            $q->compare('company_forms_company.company_form_id',$fid);
            $cmp=$c->findAll($q);
            // var_dump($cmp);
            $selected=array();
            foreach ($cmp as $m)
            {
                $temp= array($m->id => array('selected' => 'selected'));
                $selected[$m->id]= array('selected' => 'selected'); //array_merge($temp,$selected);
            }
            
             return($selected);
        }
        public static function listFormCompanies($fid)
        {
            $c=new Company;
            $q=new CDbCriteria;
           // $q->select='t.id';
            $q->join=' left join company_forms_company on company_forms_company.company_id=t.id';
            $q->compare('company_forms_company.company_form_id',$fid);
            $cmp=$c->findAll($q);
            // var_dump($cmp);
            
            
             return($cmp);
        }

        /**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'company_form_id' => 'Company Form',
			'company_id' => 'Company',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('company_form_id',$this->company_form_id);
		$criteria->compare('company_id',$this->company_id);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Companyformscompany the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
