<?php

/**
 * This is the model class for table "company_forms".
 *
 * The followings are the available columns in table 'company_forms':
 * @property integer $id
 * @property integer $company_type
 * @property integer $company
 * @property integer $user_type
 * @property string $form
 * @property integer $uploaded_by
 * @property string $created
 * @property string $modofied
 */
class Companyforms extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
    public $company_type_id,$company_id,$company_usertype;
	public function tableName()
	{
		return 'company_forms';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('form, uploaded_by', 'required'),
			array('uploaded_by', 'numerical', 'integerOnly'=>true),
			array('form', 'length', 'max'=>500),
                        array('company_usertype,company_type_id,company_id,accept', 'safe'),
                    array('form', 'file', 
        'allowEmpty'=>false,
        'enableClientValidation' => true,
       // 'types'=>'jpg,jpeg,gif,png',
        'maxSize' => 1024 * 1024 * 5, // 1MB
         "tooLarge"=>"Please choose a file with size up to 5MB",
         "wrongType"=>"Your photo must be a jpg,gif or png .",                
),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, form, uploaded_by, 	doc_type, created, modified', 'safe', 'on'=>'search'),
                     array(
                                'modified','default',
                                'value'=>date('Y-m-d H:i:s'),
                                'setOnEmpty'=>false,'on'=>'update'
                        ),
                        array(
                                'created,modified','default',
                                'value'=>date('Y-m-d H:i:s'),
                                'setOnEmpty'=>false,'on'=>'insert'
                        ),
                    );
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			 
			'form' => 'Form',
			'uploaded_by' => 'Uploaded By',
                        'doc_type'=>'Doc Type',
			'created' => 'Created',
			'modified' => 'Modified',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		 $criteria->compare('form',$this->form,true);
		$criteria->compare('uploaded_by',$this->uploaded_by);
                $criteria->compare('doc_type',$this->doc_type);
		$criteria->compare('created',$this->created,true);
		$criteria->compare('modified',$this->modified,true);
                 $usertype=  UserController::getTypeid(Yii::app()->user->id);
                if($usertype>2)
                {
                    $cmp=new Company;
                    $c=new CDbCriteria;
                    $c->select='t.id,t.name,t.type_id';
                    $c->join=' left join branch on branch.company_id=t.id left join user on user.branch_id=branch.id';
                    $c->compare('user.id',Yii::app()->user->id);
                 //var_dump($c);
                 $companies=$cmp->findAll($c);
                 $criteria->join=' left join company_forms_company on company_forms_company.company_form_id=t.id';
                 $criteria->compare('company_forms_company.company_id',$companies[0]['id']);
                 
                }
                $menu=$menu=Yii::app()->controller->action->id;
                if($menu=='viewhowto')
                {
                    $criteria->compare('t.doc_type','HowTo');
                }
                else {$criteria->condition='t.doc_type Is Null';}
               // var_dump($criteria);
		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Companyforms the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
