<?php

/**
 * This is the model class for table "claim_status".
 *
 * The followings are the available columns in table 'claim_status':
 * @property integer $id
 * @property integer $claim_id
 * @property integer $status_id
 * @property integer $active
 * @property integer $changed_by
 * @property string $created
 * @property string $modified
 *
 * The followings are the available model relations:
 * @property Cstatus $status
 * @property User $changedBy
 * @property Claim $claim
 */
class ClaimStatus extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'claim_status';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('claim_id, status_id, active', 'required'),
			array('claim_id, status_id, active, changed_by', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, claim_id, status_id, active, changed_by, created, modified', 'safe', 'on'=>'search'),
                         array(
                                        'modified','default',
                                        'value'=>date('Y-m-d H:i:s'),
                                        'setOnEmpty'=>false,'on'=>'update'
                        ),
                        array(
                                'created,modified','default',
                                'value'=>date('Y-m-d H:i:s'),
                                'setOnEmpty'=>false,'on'=>'insert'
                        ),
                    
                    
                    
                    );
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			//'status' => array(self::BELONGS_TO, 'Cstatus', 'status_id'),
			'changedBy' => array(self::BELONGS_TO, 'User', 'changed_by'),
			'claim' => array(self::BELONGS_TO, 'Claim', 'claim_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'claim_id' => 'Claim',
			'status_id' => 'Status',
			'active' => 'Active',
			'changed_by' => 'Changed By',
			'created' => 'Created',
			'modified' => 'Modified',
		);
	}
        public function getStatus($claim_id)
        {
            //$m=new Menuitem;
               //  $menuid=$m->getMenuid();
                /* if($menuid==58)
                     return "Open";
                 if($menuid==59)
                     return "Closed";
                 if($menuid==60)
                     return "Canceled";
                 if($menuid==61)
                     return "Deleted";*/
            $q=new CDbCriteria;
            $q->condition=" t.claim_id=".$claim_id." and"
                    . " (t.status_id=7 or t.status_id=8 or t.status_id=9 "
                    . " or t.status_id=37 or t.status_id=40)";
            $q->order=" t.created DESC";
            $q->limit=" 1";
            $mod=$this->find($q);
            if($mod!=null)
            {
               // echo $mod->status_id;
                if($mod->status_id==7)
                    return "Canceled";
                 if($mod->status_id==8)
                    return "Closed";
                  if($mod->status_id==9)
                    return "Deleted";
                   if($mod->status_id==37)
                    return "Re-Opened";
                    if($mod->status_id==40)
                    return "Completed";
            } 
            return "Open";
            
        }

        /**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('claim_id',$this->claim_id);
		$criteria->compare('status_id',$this->status_id);
		$criteria->compare('active',$this->active);
		$criteria->compare('changed_by',$this->changed_by);
		$criteria->compare('created',$this->created,true);
		$criteria->compare('modified',$this->modified,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
        public function checkStatus($claim_id)
        {
            $st=$this->getStatus($claim_id);
            return $st;
            $c=new Cstatus();
            $q=new CDbCriteria;
            $q->select='t.name';
            $q->join=' left join claim_status On t.id=claim_status.status_id';
            $q->condition="claim_status.claim_id=".$claim_id." and claim_status.active=1";
            $st=$c->find($q);
            if($st!=null)
                return $st->name;
            else 
               return "Open"; 
            
        }

        /**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return ClaimStatus the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
