<?php

/**
 * This is the model class for table "claim_created_by".
 *
 * The followings are the available columns in table 'claim_created_by':
 * @property integer $id
 * @property integer $claim_id
 * @property string $owner_type
 */
class ClaimCreatedBy extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'claim_created_by';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('claim_id, owner_type', 'required'),
			array('claim_id', 'numerical', 'integerOnly'=>true),
			array('owner_type', 'length', 'max'=>5),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, claim_id,tpa_adj,tpa_branch,tpa_cmp,ins_adj,ins_branch,ins_cmp, owner_type', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'claim_id' => 'Claim',
			'owner_type' => 'Owner Type',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
        
        public function getChild($claim_id)
        {
            $q=new CDbCriteria;
            $q->compare('t.claim_id',$claim_id);
            $model=  ClaimCreatedBy::model()->find($q);
            return $model;
        }
        public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('claim_id',$this->claim_id);
		$criteria->compare('owner_type',$this->owner_type,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return ClaimCreatedBy the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
