<?php

/**
 * This is the model class for table "child_branch".
 *
 * The followings are the available columns in table 'child_branch':
 * @property integer $id
 * @property string $branch_name
 * @property integer $company_id
 * @property string $address1
 * @property string $address2
 * @property string $city
 * @property integer $state_id
 * @property string $zip
 * @property string $phone
 * @property string $fax
 * @property double $inspectionfee
 * @property double $milagefee
 * @property string $aftermiles
 * @property double $photosonlyfee
 * @property double $totallossfee
 * @property double $fuelsurcharge
 * @property double $reinspectionfee
 * @property double $supplementfee
 * @property double $salestax
 * @property string $zipcodecoverage
 * @property string $requirements
 * @property string $created
 * @property string $modified
 */
class Childbranch extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'child_branch';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('branch_name, company_id,created_by_comp,created_by', 'required'),
			array('company_id, state_id', 'numerical', 'integerOnly'=>true),
			array('inspectionfee, milagefee, photosonlyfee, totallossfee, fuelsurcharge, reinspectionfee, supplementfee, salestax', 'numerical'),
			array('branch_name, zipcodecoverage', 'length', 'max'=>500),
			array('city, zip, phone, fax', 'length', 'max'=>255),
			array('aftermiles', 'length', 'max'=>8),
			array('address1, address2, requirements', 'safe'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, branch_name, company_id, address1,created_by_comp,created_by, address2, city, state_id, zip, phone, fax, inspectionfee, milagefee, aftermiles, photosonlyfee, totallossfee, fuelsurcharge, reinspectionfee, supplementfee, salestax, zipcodecoverage, requirements, created, modified', 'safe', 'on'=>'search'),
		array(
                                        'modified','default',
                                        'value'=>date('Y-m-d H:i:s'),
                                        'setOnEmpty'=>false,'on'=>'update'
                        ),
                        array(
                                'created,modified','default',
                                'value'=>date('Y-m-d H:i:s'),
                                'setOnEmpty'=>false,'on'=>'insert'
                        ),
                    
                    );
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'child_company' => array(self::BELONGS_TO, 'Company', 'company_id'),
			'state' => array(self::BELONGS_TO, 'State', 'state_id'),
			'claims' => array(self::HAS_MANY, 'Claim', 'branch_id'),
			'users' => array(self::HAS_MANY, 'User', 'branch_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'branch_name' => 'Branch Name',
			'company_id' => 'Company',
			'address1' => 'Address1',
			'address2' => 'Address2',
			'city' => 'City',
			'state_id' => 'State',
			'zip' => 'Zip',
			'phone' => 'Phone',
			'fax' => 'Fax',
			'inspectionfee' => 'Inspectionfee',
			'milagefee' => 'Milagefee',
			'aftermiles' => 'Aftermiles',
			'photosonlyfee' => 'Photosonlyfee',
			'totallossfee' => 'Totallossfee',
			'fuelsurcharge' => 'Fuelsurcharge',
			'reinspectionfee' => 'Reinspectionfee',
			'supplementfee' => 'Supplementfee',
			'salestax' => 'Salestax',
			'zipcodecoverage' => 'Zipcodecoverage',
			'requirements' => 'Requirements',
			'created' => 'Created',
			'modified' => 'Modified',
                        'created_by_comp'=>'Created By Company',
                       'created_by'=>'Created By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('branch_name',$this->branch_name,true);
		$criteria->compare('company_id',$this->company_id);
		$criteria->compare('address1',$this->address1,true);
		$criteria->compare('address2',$this->address2,true);
		$criteria->compare('city',$this->city,true);
		$criteria->compare('state_id',$this->state_id);
		$criteria->compare('zip',$this->zip,true);
		$criteria->compare('phone',$this->phone,true);
		$criteria->compare('fax',$this->fax,true);
		$criteria->compare('inspectionfee',$this->inspectionfee);
		$criteria->compare('milagefee',$this->milagefee);
		$criteria->compare('aftermiles',$this->aftermiles,true);
		$criteria->compare('photosonlyfee',$this->photosonlyfee);
		$criteria->compare('totallossfee',$this->totallossfee);
		$criteria->compare('fuelsurcharge',$this->fuelsurcharge);
		$criteria->compare('reinspectionfee',$this->reinspectionfee);
		$criteria->compare('supplementfee',$this->supplementfee);
		$criteria->compare('salestax',$this->salestax);
		$criteria->compare('zipcodecoverage',$this->zipcodecoverage,true);
		$criteria->compare('requirements',$this->requirements,true);
		$criteria->compare('created',$this->created,true);
		$criteria->compare('modified',$this->modified,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Childbranch the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
