<?php

/**
 * This is the model class for table "child_address".
 *
 * The followings are the available columns in table 'child_address':
 * @property integer $id
 * @property integer $user_id
 * @property string $address1
 * @property string $address2
 * @property string $city
 * @property integer $state_id
 * @property string $county
 * @property integer $country_id
 * @property string $zip
 * @property string $office_fax
 * @property string $home_fax
 * @property string $created
 * @property string $modified
 */
class Childaddress extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'child_address';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_id', 'required'),
			array('user_id, state_id, country_id', 'numerical', 'integerOnly'=>true),
			array('city, county, zip', 'length', 'max'=>255),
			array('office_fax, home_fax', 'length', 'max'=>20),
			array('address1, address2', 'safe'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, user_id, address1, address2, city, state_id, county, country_id, zip, office_fax, home_fax, created, modified', 'safe', 'on'=>'search'),
                         array(
                                        'modified','default',
                                        'value'=>date('Y-m-d H:i:s'),
                                        'setOnEmpty'=>false,'on'=>'update'
                        ),
                        array(
                                'created,modified','default',
                                'value'=>date('Y-m-d H:i:s'),
                                'setOnEmpty'=>false,'on'=>'insert'
                        ),
                    
                    );
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'user_id' => 'User',
			'address1' => 'Address1',
			'address2' => 'Address2',
			'city' => 'City',
			'state_id' => 'State',
			'county' => 'County',
			'country_id' => 'Country',
			'zip' => 'Zip',
			'office_fax' => 'Office Fax',
			'home_fax' => 'Home Fax',
			'created' => 'Created',
			'modified' => 'Modified',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('address1',$this->address1,true);
		$criteria->compare('address2',$this->address2,true);
		$criteria->compare('city',$this->city,true);
		$criteria->compare('state_id',$this->state_id);
		$criteria->compare('county',$this->county,true);
		$criteria->compare('country_id',$this->country_id);
		$criteria->compare('zip',$this->zip,true);
		$criteria->compare('office_fax',$this->office_fax,true);
		$criteria->compare('home_fax',$this->home_fax,true);
		$criteria->compare('created',$this->created,true);
		$criteria->compare('modified',$this->modified,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Childaddress the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
