<?php

/**
 * This is the model class for table "ability".
 *
 * The followings are the available columns in table 'ability':
 * @property integer $id
 * @property string $ability_name
 * @property string $url
 */
class CheckboxAssignee extends MyActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Ability the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
	 public function getDbConnection()
    {
        return self::getAdvertDbConnection();
    }
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'checkbox_assignee';
	}
        
        
            


            /**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			//array('usertype', 'required'),
			 
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, usertype, for_utype', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'usertype' => 'Group Name',
			'for_utype' => 'Page Name',
                        
		);
	}
public function getCheckBoxList($for_utype)
        {
             $db=$this->getDbConnection();
		//$uid=Yii::app()->user->id;
               // $tyoeid=  UserController::getTypeid($uid);
                $mode=new CheckboxAssignee();
                 $c = new CDbCriteria;
                $c->compare('t.for_utype',$for_utype);
                //$c->order="t.assigned_to";
                $results = $mode->findAll($c);
             //  var_dump($c);
                $gp='';
                 
                    return $results;
        }
	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('for_utype',$this->for_utype,true);
		$criteria->compare('usertype',$this->usertype,true);
               
		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}