<?php

/**
 * This is the model class for table "bodyshopinvoice".
 *
 * The followings are the available columns in table 'bodyshopinvoice':
 * @property integer $id
 * @property integer $claim_id
 * @property double $estimate1
 * @property double $betterment1
 * @property double $supplement1
 * @property double $betterments1
 * @property double $supplement2
 * @property double $betterments2
 * @property double $supplement3
 * @property double $betterments3
 * @property double $betterments4
 * @property double $supplement4
 * @property double $estimatepreparationfee
 * @property double $photospreparationfFee
 * @property double $miscfee
 * @property double $storagedays
 * @property double $storageamount
 * @property double $storagetotal
 * @property double $towingcharge
 * @property double $subtotal
 * @property double $salestaxrate
 * @property double $totalsalestax
 * @property double $total
 * @property integer $is_paid
 * @property string $paid_date
 * @property string $check_number
 * @property string $check_amount
 * @property string $meo
 * @property string $created
 * @property string $modified
 * @property integer $deleted
 *
 * The followings are the available model relations:
 * @property Claim $claim
 */
class Bodyshopinvoice extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Bodyshopinvoice the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'bodyshopinvoice';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('claim_id, total, is_paid', 'required'),
			array('claim_id, is_paid, deleted', 'numerical', 'integerOnly'=>true),
			array('estimate1,estimate2, betterment1, supplement1, betterments1, supplement2, betterments2, supplement3, betterments3, betterments4, supplement4, estimatepreparationfee, photospreparationfFee, miscfee, storagedays, storageamount, storagetotal, towingcharge, subtotal, salestaxrate, totalsalestax, total', 'numerical'),
			array('check_number', 'length', 'max'=>255),
			array('check_amount', 'length', 'max'=>10),
			array('meo', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, claim_id, estimate1,estimate2, betterment1, supplement1, betterments1, supplement2, betterments2, supplement3, betterments3, betterments4, supplement4, estimatepreparationfee, photospreparationfFee, miscfee, storagedays, storageamount, storagetotal, towingcharge, subtotal, salestaxrate, totalsalestax, total, is_paid, paid_date, check_number, check_amount, meo, created, modified, deleted', 'safe', 'on'=>'search'),
                        array(
                                        'modified','default',
                                        'value'=>date('Y-m-d H:i:s'),
                                        'setOnEmpty'=>false,'on'=>'update'
                        ),
                        array(
                                'created,modified','default',
                                'value'=>date('Y-m-d H:i:s'),
                                'setOnEmpty'=>false,'on'=>'insert'
                        ),
                    );
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'claim' => array(self::BELONGS_TO, 'Claim', 'claim_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'claim_id' => 'Claim',
			'estimate1' => 'Estimate 1 Amount',
                        'estimate2'=>'Estimate 2 Amount',
                        'betterment2'=>'Betterment 2 Amount',
			'betterment1' => 'Betterment 1 Amount',
			'supplement1' => 'Supplement 1 Amount',
			'betterments1' => 'Betterment S1 Amount',
			'supplement2' => 'Supplement 2 Amount',
			'betterments2' => 'Betterment S2 Amount',
			'supplement3' => 'Supplement 3 Amount',
			'betterments3' => 'Betterment S3 Amount:',
			'betterments4' => 'Betterment S4 Amount',
			'supplement4' => 'Supplement 4 Amount',
			'estimatepreparationfee' => 'Estimate Prearation Fee',
			'photospreparationfFee' => 'Photos Preparation Fee',
			'miscfee' => 'Misc fee',
			'storagedays' => 'Storage Days',
			'storageamount' => 'Storage Amount',
			'storagetotal' => 'Storage Total',
			'towingcharge' => 'Towing Charge',
			'subtotal' => 'Subtotal',
			'salestaxrate' => 'Sales Tax Rate',
			'totalsalestax' => 'Total Sales Tax',
			'total' => 'Total',
			'is_paid' => 'Is Paid',
			'paid_date' => 'Paid Date',
			'check_number' => 'Check Number',
			'check_amount' => 'Check Amount',
			'meo' => 'Memo',
			'created' => 'Created',
			'modified' => 'Modified',
			'deleted' => 'Deleted',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('claim_id',$this->claim_id);
		$criteria->compare('estimate1',$this->estimate1);
		$criteria->compare('betterment1',$this->betterment1);
		$criteria->compare('supplement1',$this->supplement1);
		$criteria->compare('betterments1',$this->betterments1);
		$criteria->compare('supplement2',$this->supplement2);
		$criteria->compare('betterments2',$this->betterments2);
		$criteria->compare('supplement3',$this->supplement3);
		$criteria->compare('betterments3',$this->betterments3);
		$criteria->compare('betterments4',$this->betterments4);
		$criteria->compare('supplement4',$this->supplement4);
		$criteria->compare('estimatepreparationfee',$this->estimatepreparationfee);
		$criteria->compare('photospreparationfFee',$this->photospreparationfFee);
		$criteria->compare('miscfee',$this->miscfee);
		$criteria->compare('storagedays',$this->storagedays);
		$criteria->compare('storageamount',$this->storageamount);
		$criteria->compare('storagetotal',$this->storagetotal);
		$criteria->compare('towingcharge',$this->towingcharge);
		$criteria->compare('subtotal',$this->subtotal);
		$criteria->compare('salestaxrate',$this->salestaxrate);
		$criteria->compare('totalsalestax',$this->totalsalestax);
		$criteria->compare('total',$this->total);
		$criteria->compare('is_paid',$this->is_paid);
		$criteria->compare('paid_date',$this->paid_date,true);
		$criteria->compare('check_number',$this->check_number,true);
		$criteria->compare('check_amount',$this->check_amount,true);
		$criteria->compare('meo',$this->meo,true);
		$criteria->compare('created',$this->created,true);
		$criteria->compare('modified',$this->modified,true);
		$criteria->compare('deleted',$this->deleted);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}