<?php

/**
 * This is the model class for table "authorization_text".
 *
 * The followings are the available columns in table 'authorization_text':
 * @property integer $id
 * @property string $repair_auth
 * @property string $reminder
 * @property integer $auth_form_id
 * @property string $understanding_fees
 * @property string $teardown_statement
 * @property string $personal_policy
 * @property string $warranty
 * @property string $glass_policy
 * @property string $terms
 * @property string $welcome_text
 * @property string $method_payment
 * @property string $no_promisses
 * @property string $faster_service
 * @property string $general_rule
 * @property string $repair
 * @property string $storage
 * @property string $lien_sale
 */
class Authorizationtext extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'authorization_text';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('repair_auth, reminder, auth_form_id, understanding_fees, teardown_statement, personal_policy, warranty, glass_policy, terms, welcome_text,  no_promisses, faster_service, general_rule, repair, storage, lien_sale', 'required'),
			array('auth_form_id', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, repair_auth, reminder, auth_form_id, understanding_fees, teardown_statement, personal_policy, warranty, glass_policy, terms, welcome_text, method_payment, no_promisses, faster_service, general_rule, repair, storage, lien_sale', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'repair_auth' => 'Repair Auth',
			'reminder' => 'Reminder',
			'auth_form_id' => 'Auth Form',
			'understanding_fees' => 'Understanding Fees',
			'teardown_statement' => 'Teardown Statement',
			'personal_policy' => 'Personal Policy',
			'warranty' => 'Warranty',
			'glass_policy' => 'Glass Policy',
			'terms' => 'Terms',
			'welcome_text' => 'Welcome Text',
			'method_payment' => 'Method Payment',
			'no_promisses' => 'No Promisses',
			'faster_service' => 'Faster Service',
			'general_rule' => 'General Rule',
			'repair' => 'Repair',
			'storage' => 'Storage',
			'lien_sale' => 'Lien Sale',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('repair_auth',$this->repair_auth,true);
		$criteria->compare('reminder',$this->reminder,true);
		$criteria->compare('auth_form_id',$this->auth_form_id);
		$criteria->compare('understanding_fees',$this->understanding_fees,true);
		$criteria->compare('teardown_statement',$this->teardown_statement,true);
		$criteria->compare('personal_policy',$this->personal_policy,true);
		$criteria->compare('warranty',$this->warranty,true);
		$criteria->compare('glass_policy',$this->glass_policy,true);
		$criteria->compare('terms',$this->terms,true);
		$criteria->compare('welcome_text',$this->welcome_text,true);
		$criteria->compare('method_payment',$this->method_payment,true);
		$criteria->compare('no_promisses',$this->no_promisses,true);
		$criteria->compare('faster_service',$this->faster_service,true);
		$criteria->compare('general_rule',$this->general_rule,true);
		$criteria->compare('repair',$this->repair,true);
		$criteria->compare('storage',$this->storage,true);
		$criteria->compare('lien_sale',$this->lien_sale,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Authorizationtext the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
