<?php

/**
 * This is the model class for table "authorization_form".
 *
 * The followings are the available columns in table 'authorization_form':
 * @property integer $id
 * @property integer $claim_id
 * @property string $print_date
 * @property integer $estimate_no
 * @property integer $repair_order_no
 * @property double $parts_initial_estimate
 * @property double $parts_supllement
 * @property double $total_parts_supplement_estimate
 * @property double $labour_initial_estimate
 * @property double $labour_sup_total
 * @property double $total_labour_sup_est
 * @property double $grand_total
 * @property string $initials
 * @property double $storage_fees
 * @property double $estimate_fee
 * @property string $save_parts
 * @property double $oral_auth_amt
 * @property string $oral_auth_by
 * @property string $oral_auth_date
 * @property string $oral_license_no
 * @property integer $oral_phone
 * @property string $oral_auth_time
 * @property string $oral_ss
 * @property double $sup_auth_amt
 * @property string $sup_auth_by
 * @property integer $sup_phone
 * @property string $sup_auth_date
 * @property string $sup_auth_time
 * @property string $sup_license_no
 * @property string $sup_ss
 * @property string $read_received
 * @property double $estimate_amount
 * @property string $signature
 * @property string $bar_registration_no
 * @property string $epa_no
 * @property string $payment_method
 * @property double $l_estimate_fee
 * @property double $l_storage_fee
 * @property string $acknowledgement
 */
class Authorizationform extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'authorization_form';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('claim_id, repair_order_no', 'required'),
			array('claim_id, estimate_no, repair_order_no', 'numerical', 'integerOnly'=>true),
			array('parts_initial_estimate, parts_supllement, total_parts_supplement_estimate, labour_initial_estimate, labour_sup_total, total_labour_sup_est, grand_total, storage_fees, estimate_fee, oral_auth_amt, sup_auth_amt, estimate_amount, l_estimate_fee, l_storage_fee', 'numerical'),
			array('initials, payment_method', 'length', 'max'=>500),
			array('save_parts, bar_registration_no, epa_no', 'length', 'max'=>20),
			array('oral_auth_by, sup_auth_by, signature', 'length', 'max'=>40),
			array('oral_license_no, sup_license_no', 'length', 'max'=>15),
			array('oral_ss, sup_ss', 'length', 'max'=>12),
			array('print_date, oral_auth_date,project_delivery_date,arrival_date, oral_auth_time, sup_auth_date, sup_auth_time, read_received, acknowledgement', 'safe'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, claim_id, print_date, estimate_no, repair_order_no, parts_initial_estimate, parts_supllement, total_parts_supplement_estimate, labour_initial_estimate, labour_sup_total, total_labour_sup_est, grand_total, initials, storage_fees, estimate_fee, save_parts, oral_auth_amt, oral_auth_by, oral_auth_date, oral_license_no, oral_phone, oral_auth_time, oral_ss, sup_auth_amt, sup_auth_by, sup_phone, sup_auth_date, sup_auth_time, sup_license_no, sup_ss, read_received, estimate_amount, signature, bar_registration_no, epa_no, payment_method, l_estimate_fee, l_storage_fee, acknowledgement', 'safe', 'on'=>'search'),
		
                         array(
                                        'modified','default',
                                        'value'=>date('Y-m-d H:i:s'),
                                        'setOnEmpty'=>false,'on'=>'update'
                        ),
                        array(
                                'created,modified','default',
                                'value'=>date('Y-m-d H:i:s'),
                                'setOnEmpty'=>false,'on'=>'insert'
                        ),
                    
                    );
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'claim_id' => 'Claim',
			'print_date' => 'Print Date',
			'estimate_no' => 'Estimate No',
			'repair_order_no' => 'Repair Order No',
			'parts_initial_estimate' => 'Initial Estimate',
			'parts_supllement' => 'Supplement',
			'total_parts_supplement_estimate' => 'Total',
			'labour_initial_estimate' => 'Initial Estimate',
			'labour_sup_total' => 'Supplement',
			'total_labour_sup_est' => 'Total',
			'grand_total' => 'Grand Total',
			'initials' => 'Initials',
			'storage_fees' => 'Storage Fees',
			'estimate_fee' => 'Estimate Fee',
			'save_parts' => 'Save Parts',
			'oral_auth_amt' => 'Oral Auth Amt',
			'oral_auth_by' => 'Oral Auth By',
			'oral_auth_date' => 'Oral Auth Date',
			'oral_license_no' => 'Oral License No',
			'oral_phone' => 'Oral Phone',
			'oral_auth_time' => 'Oral Auth Time',
			'oral_ss' => 'Oral Ss',
			'sup_auth_amt' => 'Sup Auth Amt',
			'sup_auth_by' => 'Sup Auth By',
			'sup_phone' => 'Sup Phone',
			'sup_auth_date' => 'Sup Auth Date',
			'sup_auth_time' => 'Sup Auth Time',
			'sup_license_no' => 'Sup License No',
			'sup_ss' => 'Sup Ss',
			'read_received' => 'Read Received',
			'estimate_amount' => 'Estimate Amount',
			'signature' => 'Signature',
			'bar_registration_no' => 'Bar Registration No',
			'epa_no' => 'Epa No',
			'payment_method' => 'Payment Method',
			'l_estimate_fee' => 'Estimate Fee',
			'l_storage_fee' => 'Storage Fee',
			'acknowledgement' => 'Acknowledgement',
                        'created'=>'Created',
                        'modified'=>'Modified',
                        'arrival_date'=>'Arrival Date',
                        'project_delivery_date'=>'Project Delivery Date',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('claim_id',$this->claim_id);
		$criteria->compare('print_date',$this->print_date,true);
		$criteria->compare('estimate_no',$this->estimate_no);
		$criteria->compare('repair_order_no',$this->repair_order_no);
		$criteria->compare('parts_initial_estimate',$this->parts_initial_estimate);
		$criteria->compare('parts_supllement',$this->parts_supllement);
		$criteria->compare('total_parts_supplement_estimate',$this->total_parts_supplement_estimate);
		$criteria->compare('labour_initial_estimate',$this->labour_initial_estimate);
		$criteria->compare('labour_sup_total',$this->labour_sup_total);
		$criteria->compare('total_labour_sup_est',$this->total_labour_sup_est);
		$criteria->compare('grand_total',$this->grand_total);
		$criteria->compare('initials',$this->initials,true);
		$criteria->compare('storage_fees',$this->storage_fees);
		$criteria->compare('estimate_fee',$this->estimate_fee);
		$criteria->compare('save_parts',$this->save_parts,true);
		$criteria->compare('oral_auth_amt',$this->oral_auth_amt);
		$criteria->compare('oral_auth_by',$this->oral_auth_by,true);
		$criteria->compare('oral_auth_date',$this->oral_auth_date,true);
		$criteria->compare('oral_license_no',$this->oral_license_no,true);
		$criteria->compare('oral_phone',$this->oral_phone);
		$criteria->compare('oral_auth_time',$this->oral_auth_time,true);
		$criteria->compare('oral_ss',$this->oral_ss,true);
		$criteria->compare('sup_auth_amt',$this->sup_auth_amt);
		$criteria->compare('sup_auth_by',$this->sup_auth_by,true);
		$criteria->compare('sup_phone',$this->sup_phone);
		$criteria->compare('sup_auth_date',$this->sup_auth_date,true);
		$criteria->compare('sup_auth_time',$this->sup_auth_time,true);
		$criteria->compare('sup_license_no',$this->sup_license_no,true);
		$criteria->compare('sup_ss',$this->sup_ss,true);
		$criteria->compare('read_received',$this->read_received,true);
		$criteria->compare('estimate_amount',$this->estimate_amount);
		$criteria->compare('signature',$this->signature,true);
		$criteria->compare('bar_registration_no',$this->bar_registration_no,true);
		$criteria->compare('epa_no',$this->epa_no,true);
		$criteria->compare('payment_method',$this->payment_method,true);
		$criteria->compare('l_estimate_fee',$this->l_estimate_fee);
		$criteria->compare('l_storage_fee',$this->l_storage_fee);
		$criteria->compare('acknowledgement',$this->acknowledgement,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Authorizationform the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
