<?php

/**
 * This is the model class for table "assignee".
 *
 * The followings are the available columns in table 'assignee':
 * @property integer $id
 * @property integer $claim_id
 * @property integer $assign_by
 * @property integer $assign_to
 * @property integer $active
 * @property string $created
 * @property string $modified
 */
class Assignee extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'assignee';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('claim_id, assign_by, active', 'required'),
                        array('assign_to','either','other'=>'branch_id'),
			array('claim_id, assign_by, assign_to, active,branch_id,parent_id', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id,branch_id,parent_id,other_assignee, claim_id, assign_by, assign_to, active, created, modified', 'safe', 'on'=>'search'),
                         array(
                                        'modified','default',
                                        'value'=>date('Y-m-d H:i:s'),
                                        'setOnEmpty'=>false,'on'=>'update'
                              ),
                        array(
                                'created,modified','default',
                                'value'=>date('Y-m-d H:i:s'),
                                'setOnEmpty'=>false,'on'=>'insert'
                              ),
                    
                    
                    
                    );
	}
    public function either($attribute_name, $params)
        {
    $field1 = $this->getAttributeLabel($attribute_name);
    $field2 = $this->getAttributeLabel($params['other']);
    if (empty($this->$attribute_name) && empty($this->$params['other'])) {
        $this->addError($attribute_name, Yii::t('assignee', "either {$field1} or {$field2} is required."));
        return false;
    }
    return true;
        }
	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    
                     'claims'=>array(self::BELONGS_TO,'Claim','claim_id'),
                     'assignby'=>array(self::BELONGS_TO,'User','assign_by'),
                     'assignto'=>array(self::BELONGS_TO,'User','assign_to'),
                    'ass_branch'=>array(self::BELONGS_TO,'Branch','branch_id'),
                    'parrent'=>array(self::HAS_MANY,'Assignee','parent_id'),
                    //,
		);
	}
        public  function getAss($claim_id,$type=null)
        {
            if($type=="App")
            {
                $q=new CDbCriteria;
                $q->condition="t.assignee_type>=7 and t.assignee_type<=17 and t.claim_id=".$claim_id;
                $q->limit=1;
                $q->order="t.created DESC";
                $ass=$this->find($q);
            }
           //var_dump($ass);
            return $ass;
        }

        public function Claim_Age($claim_id)
        {   $utype=  UserController::getTypeid(Yii::app()->user->id);
            $userid=Yii::app()->user->id;
            $bu=User::model()->findByPk(Yii::app()->user->id);
            $ap=new ActionApply;
             $q=new CDbCriteria;
            if($utype<=5 || $utype==50 || ($utype>=19 && $utype<=23) || ($utype>=26 && $utype<=32) )
            {    
                $q=new CDbCriteria;
                $q->condition='t.claim_id='.$claim_id.' and t.action=90 and menu_id=17' ;//Claim Created
                $q->limit=" 1";
                 $r=$ap->find($q);
                $createed=$r->created;
            }else {
                  $mv=new MoveintoNew;
                $q=new CDbCriteria;
                $q->condition="t.userid=".Yii::app()->user->id." and t.claim_id=".$claim_id;
                $ex=$mv->find($q);
                if($ex!=null)
                    $createed=$ex->created;
                else {
                 $q=new CDbCriteria;
                $q->condition='t.claim_id='.$claim_id.' and t.action=90 and menu_id=17 and t.by_userid='.$userid ;//Claim Created
                $q->limit=" 1";
                 $r=$ap->find($q);
                 if($r!=null)
                    $createed=$r->created;
                       else {
                            $q=new CDbCriteria;
                           $q->condition='t.claim_id='.$claim_id ;//Claim Created

                          $r=$ap->findAll($q);
                          if($r!=null)
                          {
                     foreach($r as $ct)
                     {
                       $act=new Action;
                        $rs= $act->checkmoverule($ct->action,$ct->by_utype,$utype,$ct->menu_id,$menuid,false,'All'); 
                           if($rs!=null)
                                    {
                                        foreach($rs as $r)
                                        {
                                            $bool=true;
                                            $flow=new Flow;
                                           if($rs->fun!="")
                                             $bool= $flow->assignment_check($r->fun,$claim_id,$utype,'',$ct->by_utype);
                                           if($bool)
                                           {
                                             // $branchid= $r->branch_id;
                                             // $assign_to=$r->assign_to;
                                            //   if($r->branch_id==Null )
                                              //     $branchid=$bu->branch_id;
                                               
                                                   
                                               $mv=new MoveintoNew;
                                               $mv->usertype=$utype;
                                               $mv->claim_id=$claim_id;
                                              // $mv->branch_id=$branchid;
                                               $mv->userid=Yii::app()->user->id;
                                               $mv->created=$ct->created;
                                                $q=new CDbCriteria;
                                                $q->condition="t.userid=".Yii::app()->user->id." and t.claim_id=".$claim_id;
                                                $ex=$mv->find($q);
                                                if($ex==null)
                                                {     $mv->save();
                                                  $createed=$ct->created;
                                                 break 2;
                                                }
                                           }
                                           
                                        }
                                    }
                     }
                 }
                }
            }
            }
           date_default_timezone_set('America/Los_Angeles');
           $today= date("H:i:s");
          $today= date('Y-m-d H:i:s', strtotime($today));
              $q=new CDbCriteria;
                $q->condition='t.claim_id='.$claim_id.' and (t.action=7 or t.action=8 or t.action=9 or t.action=40) and t.action!=37' ;//Claim Created
                $r=$ap->find($q);
                if($r!=null)
                $today=$r->created;
              // echo $_SESSION['time_zone'];
              // echo $createed."--".$today;
               if($createed=="" || $createed==null)
                   return null;
                $arr=$this->dateDiff($today, $createed);
             //   var_dump($arr);
                return $arr;
        }
         // Time format is UNIX timestamp or
  // PHP strtotime compatible strings
  function dateDiff($time1, $time2, $precision = 6) {
    // If not numeric then convert texts to unix timestamps
    if (!is_int($time1)) {
      $time1 = strtotime($time1);
    }
    if (!is_int($time2)) {
      $time2 = strtotime($time2);
    }
 
    // If time1 is bigger than time2
    // Then swap time1 and time2
    if ($time1 > $time2) {
      $ttime = $time1;
      $time1 = $time2;
      $time2 = $ttime;
    }
 
    // Set up intervals and diffs arrays
     //$intervals = array('year','month','day','hour','minute','second');
       $intervals = array('day','hour','minute');//we need only days, hours and minutes
     $diffs = array();
 
    // Loop thru all intervals
    foreach ($intervals as $interval) {
      // Create temp time from time1 and interval
      $ttime = strtotime('+1 ' . $interval, $time1);
      // Set initial values
      $add = 1;
      $looped = 0;
      // Loop until temp time is smaller than time2
      while ($time2 >= $ttime) {
        // Create new temp time from time1 and interval
        $add++;
        $ttime = strtotime("+" . $add . " " . $interval, $time1);
        $looped++;
      }
 
      $time1 = strtotime("+" . $looped . " " . $interval, $time1);
      $diffs[$interval] = $looped;
    }
 
    $count = 0;
    $times = array();
    // Loop thru all diffs
    foreach ($diffs as $interval => $value) {
      // Break if we have needed precission
      if ($count >= $precision) {
	break;
      }
      $intervals = $interval;
      // Add value and interval 
      // if value is bigger than 0
     // if ($value > 0) {
	// Add s if value is not 1
	if ($value != 1) {
	  $intervals = $interval."s";
	}
	// Add value and interval to times array
	$times[$interval] = $value . " " . $intervals;
	$count++;
      //}
    }
 //var_dump($times);
    // Return string with times
    //return implode(", ", $times);
	return $times;
  }
        
        /**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'claim_id' => 'Claim',
			'assign_by' => 'Assign By',
			'assign_to' => 'Assign To',
			'active' => 'Active',
			'created' => 'Created',
			'modified' => 'Modified',
                        'other_assignee' => 'other_assignee',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('claim_id',$this->claim_id);
		$criteria->compare('assign_by',$this->assign_by);
		$criteria->compare('assign_to',$this->assign_to);
		$criteria->compare('active',$this->active);
		$criteria->compare('created',$this->created,true);
		$criteria->compare('modified',$this->modified,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Assignee the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
