<?php

/**
 * This is the model class for table "action".
 *
 * The followings are the available columns in table 'action':
 * @property integer $id
 * @property integer $by_utype
 * @property integer $from_ability
 * @property integer $move_for_utype
 * @property integer $move_into_status
 * @property integer $current_assigne
 * @property integer $previous_assignee
 */
class Action extends MyActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'action';
	}
 public function getDbConnection()
            {
                return self::getAdvertDbConnection();
            }
	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('by_utype, from_ability, move_for_utype, move_into_status', 'required'),
			array('by_utype, from_ability, move_for_utype, move_into_status, current_assigne, previous_assignee', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, by_utype, from_ability, move_for_utype, move_into_status, current_assigne, previous_assignee', 'safe', 'on'=>'search'),
		);
	}
        public function checkMove($utype,$action)
        {
            $db=$this->getDbConnection();
             
             if($utype>=33 && $utype<=44)
             {  $mode=new Bodyshop;
             }
             else if($utype>=7 && $utype<=17)
             {
                 $mode=new Independent;
              }
               else if($utype>=18 && $utype<=26)
             {
                 $mode=new Insurance;
              }
              else if($utype>=27 && $utype<=32)
             {
                 $mode=new Thirdparty;
              }
             else if ($utype==50 or $utype<=5)
             {  $mode=new CFS;
              }
             //$mode=new Bodyshop;
             $q=new CDbCriteria;
             $q->condition='t.by_utype='.$utype.' and t.from_ability='.$action;
             $rules=$mode->findAll($q);
              
              return $rules;
        }
        public function checkmoverule($abid,$utype,$for_utype,$from_menuid,$menuid,$search=false,$allu='')
        {
             $db=$this->getDbConnection();
             
             if($utype>=33 && $utype<=44)
             {  $mode=new Bodyshop;
             }
             else if($utype>=7 && $utype<=17)
             {
                 $mode=new Independent;
              }
               else if($utype>=18 && $utype<=26)
             {
                 $mode=new Insurance;
              }
              else if($utype>=27 && $utype<=32)
             {
                 $mode=new Thirdparty;
              }
             else if ($utype==50 or $utype<=5)
             {  $mode=new CFS;
              }
             //$mode=new Bodyshop;
             $q=new CDbCriteria;
            /// $q->select='t.move_into_status';
              
               $q->condition='t.by_utype='.$utype.' and t.from_ability='.$abid." and  t.move_for_utype=".$for_utype;
               $q->condition.=' and t.menu_id='.$from_menuid." and move_into_status=".$menuid;
             //echo $q->condition;
           //echo "<br/>";
              //die();
              //
                if($allu!='')
               {
                    $q->condition='t.by_utype='.$utype.' and t.from_ability='.$abid." and  t.move_for_utype=".$for_utype;
                    $q->condition.=' and t.menu_id='.$from_menuid;//and (t.move_into_status=8 or t.move_into_status=30".")
                   //echo $q->condition;
               }
               if($search)
               {
                    $q->condition='t.by_utype='.$utype.' and t.from_ability='.$abid." and  t.move_for_utype=".$for_utype;
                    $q->condition.=' and t.menu_id='.$from_menuid;
                 //  echo $q->condition;
               }
                
          //echo $q->condition;
        // echo "<br/>";
          // die();
              $rules=$mode->findAll($q);
              //var_dump($rules);
              return $rules;
        }
        public function settb()
        {
             $db=$this->getDbConnection();
            $sql="delete from bodyshop";
           $data= Yii::app()->dbadvert->createCommand($sql)->queryAll(true);
           $sql="delete from ability";
           $data= Yii::app()->dbadvert->createCommand($sql)->queryAll(true);
            $sql="delete from assignpermission";
           $data= Yii::app()->dbadvert->createCommand($sql)->queryAll(true);
           $sql="delete from cfs";
           $data= Yii::app()->dbadvert->createCommand($sql)->queryAll(true);
           $sql="delete from ability_permission";
           $data= Yii::app()->dbadvert->createCommand($sql)->queryAll(true);
           $sql="delete from independent";
           $data= Yii::app()->dbadvert->createCommand($sql)->queryAll(true);
            $sql="delete from insurance";
           $data= Yii::app()->dbadvert->createCommand($sql)->queryAll(true);
 
        }
        /**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'by_utype' => 'By Utype',
			'from_ability' => 'From Ability',
			'move_for_utype' => 'Move For Utype',
			'move_into_status' => 'Move Into Status',
			'current_assigne' => 'Current Assignee',
			'previous_assignee' => 'Previous Assignee',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('by_utype',$this->by_utype);
		$criteria->compare('from_ability',$this->from_ability);
		$criteria->compare('move_for_utype',$this->move_for_utype);
		$criteria->compare('move_into_status',$this->move_into_status);
		$criteria->compare('current_assigne',$this->current_assigne);
		$criteria->compare('previous_assignee',$this->previous_assignee);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Action the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
