<?php

/**
 * This is the model class for table "ability".
 *
 * The followings are the available columns in table 'ability':
 * @property integer $id
 * @property string $ability_name
 * @property string $status
 */
class Ability extends MyActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Ability the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
 public function getDbConnection()
            {
                return self::getAdvertDbConnection();
            }
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'ability';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('ability_name', 'required'),
			array('ability_name, status', 'length', 'max'=>500),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, ability_name, status,auto_email', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}
        
        public function AutoEmailAbts(){
            $db=$this->getDbConnection();
            $q=new CDbCriteria;
            $q->compare("t.auto_email","Y");
            $abt=$this->findAll($q);
            return new CActiveDataProvider($this, array(
			'criteria'=>$q,
                'pagination' => array(
                            'pageSize' => 100,
                        ),
		));
           // return $abt;
        }
        public static function emailNum($id)
       {
    
           switch ($id) {
    case 7:
        $text= "E107";
        break;
    case 8:
        $text= "E108";
        break;
    case 9:
        $text= "E109";
        break;
    
    case 13:
        $text= "E113";
        break;
    case 37:
        $text= "E129";
        break;
    case 38:
        $text= "E130";
        break;
    case 39:
        $text= "E131";
        break;
    case 40:
        $text= "E132";
    case 44:
        $text= "E136";
        break;
    
     case 45:
        $text= "E137";
        break;
     
      case 46:
        $text= "E138";
        break;
    case 47:
        $text= "E139";
        break;
     case 53:
        $text= "E145";
        break;
    case 54:
        $text= "E146";
        break;
    case 55:
        $text= "E148";
        break;
    case 60:
        $text= "E153";
        break;
   case 65:
        $text= "E158";
        break;
   case 66:
        $text= "E159";
        break;
     case 67:
        $text= "E160";
        break;
    
   
        break;
    case 68:
        $text= "E161";
        break;
    case 69:
        $text= "E162";
        break;
    case 70:
        $text= "E163";
        break;
    case 71:
        $text= "E164";
        break;
    case 72:
        $text= "E165";
        break;
    case 74:
        $text= "E167";
        break;
    case 75:
        $text= "E168";
        break;
    case 76:
        $text= "E169";
        break;
    default:
        $text= "";
        
}
return $text;
       }
       public function emailText($id)
       {
   // echo $id;
           switch ($id) {
    case 7:
        $text= "Cancelled";
        break;
    case 8:
        $text= "Closed";
        break;
    case 9:
        $text= "Deleted";
        break;
    case 37:
        $text= "Re-Opened";
        break;
    case 38:
        $text= "accepted";
        break;
    case 39:
        $text= "not accepted";
        break;
    case 40:
        $text= "Marked Completed";
        break;
    case 44:
        $text= "dispatched to";
        break;
    case 45:
        $text= "Re-Assigned to";
        break;
    case 47:
        $text= "Marked Reviewed";
        break;
     case 48:
        $text= "Re-Assigned to";
        break;
    case 53:
        $text= "Assigned/reassigned to";
        break;
    case 54:
        $text= "moved back to Unassigned";
        break;
    case 55:
        $text= "Marked Reinspected";
        break;
    case 60:
        $text= "dispatched to";
        break;
    case 65:
        $text= "assigned to";
        break;
     case 66:
        $text= "assigned to";
        break;
    case 68:
        $text= "Marked Pending for Insurance Approval";
        break;
    case 67:
        $text="To view your vehicle claim information please login with the provided Claim Flow Solutions generated username:";
        break;
    case 69:
        $text= "Marked for Pending Teardown";
        break;
    case 70:
        $text= "Marked for Pending Supplement Approval";
        break;
    case 71:
        $text= "ordered for";
        break;
    case 72:
        $text= "marked for In Repair Process";
        break;
    case 74:
        $text= "marked for In Paint Process";
        break;
    case 75:
        $text= "marked for Scheduled Re-Assembly";
        break;
    case 76:
        $text= "marked Ready for Delivery";
        break;
    default:
        $text= "";
        
}
return $text;
       }

       public  function autoEmail($id,$userid)
        {
           // $userid=Yii::app()->user->id;
           $db=$this->getDbConnection();
            $rs=Ability::model()->findbyPk($id);
           // var_dump($rs);            return;
            if($rs->auto_email=="Y")
            {
                Yii::app()->db->setActive(true);
              // echo $rs->auto_email; die();
                $auto_setting=new AutoEmailSetting;
                $q=new CDbCriteria;
                $q->compare('t.user_id',$userid);
                $auto=$auto_setting->find($q);
                 //$ae="Y";
                if($auto!=null)
                {
                    if($auto->auto_email=="No")
                    {
                       $ae="N"; 
                        $auto_abt=new AutoEmailSettingPeruser;
                      $q=new CDbCriteria;
                        $q->compare('t.user_id',$userid);
                         $q->compare('t.ability_id',$id);
                        $auto=$auto_abt->find($q);
                        if($auto!=null)
                        {
                            return true;
                        }
                    }else
                        return true;
                }
                return true;
            }else {
                return false;
                }
        }
        /**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'ability_name' => 'Ability Name',
			'status' => 'Url',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('ability_name',$this->ability_name,true);
		$criteria->compare('status',$this->status,true);
                $criteria->compare('auto_email',$this->auto_email,true);
		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}