<?php

class VehicleownerController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column2';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			//'accessControl', // perform access control for CRUD operations
			//'postOnly + delete', // we only allow deletion via POST request
                    'rights',
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model=new Vehicleowner;
                $user=new User;
		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);
                $claimid=$_REQUEST['Claim_id'];
		if(isset($_POST['User']))
		{
                      $ownerid = Yii::app()->db->createCommand()
                                ->select('max(id) as max')
                                ->from('vehicle_owner')
                                ->queryScalar();
                      $ownerid=$ownerid+1;
			$user->attributes=$_POST['User'];
                        
                        $user->company_id=$ownerid;
                        $username=$user->random_string('alnum',8);
                        $password=$user->random_string('numeric',8);
                        $user->email=$username."@cfs.com";
                        $user->username=$username;
                        $user->password=$password;
                        $user->password2=$password;
                        $user->save();
                       // var_dump( $user->getErrors());
                        $assign=new Authassignment;
                        $assign->userid=$user->id;
                        $assign->itemname=45;
                        $assign->save();
                        $model->user_id=$user->id;
                        $model->created_by=Yii::app()->user->id;
                        $model->claim_id=$claimid;
                        $model->email=$_POST['Vehicleowner']['email'];
                        $q=new CDbCriteria;
            $q->select="t.claim_no,t.file_no,t.o_first_name,t.o_last_name,t.created_by";
            $q->compare('t.id',$claimid);
            $ck=new Claim;
            $ckf=$ck->find($q);
                        $sub="Login Information"."-[".$ckf->claim_no."]-[".$ckf->file_no."]".$of;
            	 $str="To view your vehicle claim information please login with the provided "
            . "Claim Flow Solutions generated username:".$username." and password:".$password;
                 $from="donotreply@claimflowsolutions.com";
                 $to=$_POST['Vehicleowner']['email'];
            	  $message=  $this->renderPartial('/layouts/mail_layout',
                       
             array("content"=>$str,'user'=>$user,'autonum'=>'E160','sub'=>$sub,'from'=>$from),true);
           
                        /*$message="Login ID is->".$username;
						$message.="<br/>"."Password is->".$password;*/
			if($model->save())
		{
                            $us=  UserController::getMe(Yii::app()->user->id);
            
                            $msg=$us." has Sent Vehicle Owner CF View Login Information to Vehicle Owner";
                            CallcenterinvoiceController::setautostatus(67,$claimid,$msg);
					$this->letsMail($to,'',$from,$sub,3,$message);
                                        Yii::app()->user->setFlash('success','Login Detail has been sent successfully');
                         
				}
		}

		$this->render('create',array(
			'model'=>$model,
                        'user'=>$user,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Vehicleowner']))
		{
			$model->attributes=$_POST['Vehicleowner'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id));
		}

		$this->render('update',array(
			'model'=>$model,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		$this->loadModel($id)->delete();

		// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
		if(!isset($_GET['ajax']))
			$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		$dataProvider=new CActiveDataProvider('Vehicleowner');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new Vehicleowner('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['Vehicleowner']))
			$model->attributes=$_GET['Vehicleowner'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer $id the ID of the model to be loaded
	 * @return Vehicleowner the loaded model
	 * @throws CHttpException
	 */
	public function loadModel($id)
	{
		$model=Vehicleowner::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param Vehicleowner $model the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='vehicleowner-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
}
