<?php

class RevisionneededController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column2';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			//'accessControl', // perform access control for CRUD operations
			//'postOnly + delete', // we only allow deletion via POST request
                    'rights',
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model=new Revisionneeded;
                $claimid=$_REQUEST['Claim_id'];
		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);
                $act=new Assignee;
                $q=new CDbCriteria;
                $q->compare('t.claim_id',$claimid);
                $q->compare('t.active',1);
                $ass=$act->find($q);
                 $assingto='';
                if($ass!=null)
                {    $assigne_to=$ass->assign_to;
                     $type=$ass->assignee_type;//  UserController::getTypeid($assigne_to);
                     if($type==7 || $type==16 || $type==18 || $type==50)//Appraiser
                         $assingto="Appraiser";
                     else {
                         $assingto='';
                     }
                }
		if(isset($_POST['Revisionneeded']) )
		{
                        if($assingto!='')
                        {
                            $model->attributes=$_POST['Revisionneeded'];
                            $model->claim_id=$claimid;
                            $model->email_to=$assigne_to;
                            $model->email_from=Yii::app()->user->id;
                            $model->save();
                           /* $st=new Statusofclaim;
                            $st->claim_id=$claimid;
                            $st->status=$_POST['Revisionneeded']['message'];
                            $st->created_by=Yii::app()->user->id;
                            $st->save();*/
                            $utype=  UserController::getTypeid(Yii::app()->user->id);
                              ActionApply::model()->updateAll(array('active'=>'0'), 'claim_id='.$claimid) ;
                              $move=new ActionApply();
                                $move->claim_id=$claimid;
                                $move->action=46;
                                $move->by_utype=$utype;
                                $move->active=1;
                                $move->menu_id=$_POST['menuid'];
                                $move->by_userid=Yii::app()->user->id;
                                $move->save();
                                $assigne_to_email=$ass->assignto->email;
                                $us=User::model()->findByPk(Yii::app()->user->id);
                                $from=$us->email;
                             $us=  UserController::getMe(Yii::app()->user->id);
            
                        //$sub="Revision Needed"."-[".$ckf->claim_no."]-[".$ckf->file_no."]".$of;
            	 $str="Revision is need for [".$_POST['Revisionneeded']['message']."], requested";
                     $this->automails(46,$claimid,$str) ;
                $msg="Revision Needed requested on Claim :".$ass->claims->claim_no." by ".$us;
                $msg.="<div>".$_POST['Revisionneeded']['message']."</div>";
                                CallcenterinvoiceController::setautostatus(46,$claimid,$msg);
                           // $this->letsMail($assigne_to_email,'TEST@CLAIMSFLOWSOLUTIONS.com','noreply@claimflowsolutions.com','Revission Needed',3,$_POST['Revisionneeded']['message']);
                             //Yii::app()->user->setFlash('success','Email is sent to Appraiser');
                                        $ac=new ActionApply;
                                 $smenuid=$ac->getMenu($claimid);
                               
                                 $m=Menuitem::model()->findByPk($smenuid);
                                 $url=  str_replace(".", "/", $m->url);
                             $this->redirect(array($url));
			//if($model->save())
			//	$this->redirect(array('view','id'=>$model->id));
                        }
                        else
                        {
                             Yii::app()->user->setFlash('success','Claim is not assigned to any Appraiser');
                         
                        }
		}

		$this->render('create',array(
			'model'=>$model,
                        'assingto'=>$assingto,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Revisionneeded']))
		{
			$model->attributes=$_POST['Revisionneeded'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id));
		}

		$this->render('update',array(
			'model'=>$model,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		$this->loadModel($id)->delete();

		// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
		if(!isset($_GET['ajax']))
			$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		$dataProvider=new CActiveDataProvider('Revisionneeded');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new Revisionneeded('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['Revisionneeded']))
			$model->attributes=$_GET['Revisionneeded'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer $id the ID of the model to be loaded
	 * @return Revisionneeded the loaded model
	 * @throws CHttpException
	 */
	public function loadModel($id)
	{
		$model=Revisionneeded::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param Revisionneeded $model the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='revisionneeded-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
}
