<?php

class ReportsController extends RController
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column2';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			//accessControl', // perform access control for CRUD operations
			//'postOnly + delete', // we only allow deletion via POST request
                    'rights',
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}
        public function allowedActions() {
            return 'create,repo19,repo20,repo21,repo31,get_ins_cmp,getBranch';
        }

            public function actionGetBranch()
        {
            $type_id=  UserController::getTypeid(Yii::app()->user->id);
              //if($type_id<=5 || $type_id==50 || ($type_id>=18 && $type_id<=26))
            if($_POST['ins_type']=="CFS")
              {   $ctable="company";
                  $btable="branch";
              }
              else
              {   $ctable="child_company";
                    $btable="child_branch";
              }
              
              if($_POST['Reports_ins_cmp']!="")
                  $cmpid=$_POST['Reports_ins_cmp'];
              
                  
                 $sql= 'SELECT t.id,t.branch_name FROM '.$btable.' t left join '.$ctable.' on '.$ctable.'.id=t.company_id '
                     . 'WHERE t.company_id = :cid ';
                $cid = $cmpid;
        $data= Yii::app()->db->createCommand($sql)->queryAll(true,array(':cid'=>$cid));
 
               // $data=CHtml::listData($data,'id','branch_name');
                echo CJSON::encode($data);
            Yii::app()->end();
        }
        /**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}
        public function actionGet_ins_cmp()
        {
            
            $type_id=  UserController::getTypeid(Yii::app()->user->id);
              $usr=  UserController::getUserDetail(Yii::app()->user->id);
              $cond='';
            /*if($type_id<=5 || $type_id==50 || ($type_id>=18 && $type_id<=26))
            {     $ctable="company";
                if($type_id>=18 && $type_id<=26)
                {
                    if($type_id==21)
                          $cond=" and id=".$usr->company->id;
                    else
                         $cond=" and id=".$usr->branch->company->id;
                }
            }
              else
              { $ctable="child_company";
                    if($type_id==12 || $type_id==21 || $type_id==29 || $type_id==37 || $type_id==46 )
                                 $cond=" and created_by_comp=".$usr->company->id;
                    else
                        $cond=" and created_by_comp=".$usr->branch->company->id;
              }*/
              
              if($_POST['ins_type']=="CFS")
              {
                  $ctable="company";
                  if($type_id<=5 || $type_id==50 || ($type_id>=18 && $type_id<=26))
                    {     $ctable="company";
                        if($type_id>=18 && $type_id<=26)
                        {
                            if($type_id==21)
                                  $cond=" and id=".$usr->company->id;
                            else
                                 $cond=" and id=".$usr->branch->company->id;
                        }
                    }
              }
              else
              { 
                  $ctable="child_company";
                    $cond="";
              }
                     //$q=new CDbCriteria;
                    $sql= 'SELECT id,name FROM '.$ctable.' WHERE type_id LIKE :type1 '.$cond.'  order by name';
       
                    $rs= Yii::app()->db->createCommand($sql)->queryAll(true,array(':type1'=>1));
            echo CJSON::encode($rs);
            Yii::app()->end();
        }

        public function actionRepo19()
        {
            if(isset($_POST['Reports'])){
                $cond="";
                if($_POST['Reports']['ins_cmp']!="")
                    $cond.=" and claim.insurance_company=".$_POST['Reports']['ins_cmp'];
                if($_POST['Reports']['ins_branch']!="")
                   $cond.= " and claim.branch_id=".$_POST['Reports']['ins_branch'];
                if($_POST['Reports']['start']!="")
                    $cond.=" and tab.created>='".$_POST['Reports']['start']."'";
                if($_POST['Reports']['end']!="")
                    $cond.=" and tab.created<='".$_POST['Reports']['end']."'";
                //$cond=" and"
                $type_id=  UserController::getTypeid(Yii::app()->user->id);
                if($_POST['ins_type']=="CFS")
                      $cond.=" and claim_created_by.ins_cmp='cfs'";
                else   
                         $cond.=" and claim_created_by.ins_cmp='other'";
                $cid=  ClaimController::getClaims(1,'',true);
                if($cid!="") {
               /* $sql=" SELECT claim.file_no,claim.claim_no,claim.insurance_company,claim.date_of_loss,
                    concat(o_first_name,' ',o_last_name) as fullname,tab.created,tab.invo_name,claim_created_by.ins_cmp FROM (
                    select ac.id as acid,ac.claim_id,ac.created,ac.invo_name from appraisalcompanyinvoice ac
                        UNION ALL
                            select ap.id as apid,ap.claim_id,ap.created,ap.invo_name from appraisalinvoice  ap
                        UNION ALL
                            select b.id as bid , b.claim_id,b.created,b.invo_name from bodyshopinvoice b
                        UNION ALL
                            select d.id as dsid,d.claim_id,d.created,d.invo_name from deskreviewerinvoice  d
                        UNION ALL
                            select t.id as tid,t.claim_id,t.created,t.invo_name from tpainvoice t 
                            ) tab left join claim on claim.id=tab.claim_id 
                            left join claim_created_by on claim_created_by.claim_id=claim.id
                            where tab.claim_id IN(".$cid.") ".$cond." order by tab.created";
                
                          */
                   $sql=" SELECT claim.file_no,claim.claim_no,claim.insurance_company,claim.date_of_loss,
                    concat(o_first_name,' ',o_last_name) as fullname,tab.created,tab.invo_name,claim_created_by.ins_cmp FROM 
                     appraisalcompanyinvoice tab left join claim on claim.id=tab.claim_id 
                            left join claim_created_by on claim_created_by.claim_id=claim.id
                            where tab.claim_id IN(".$cid.") ".$cond." order by tab.created ";
            //  $usr=  UserController::getUserDetail(Yii::app()->user->id);
              $cond='';
            if($_POST['ins_type']=="CFS")
            {  $ctable="Company";
                $btable="Branch";
                if($_POST['Reports']['ins_cmp']!="")
                        $cm=$ctable::model ()->findByPk($_POST['Reports']['ins_cmp']);
                if($_POST['Reports']['ins_branch']!="")
                          $bm=  $btable::model ()->findByPk($_POST['Reports']['ins_branch']);
                     
            }
              else
              { $ctable="Childcompany";
                $btable="Childbranch";
                              
                        if($_POST['Reports']['ins_cmp']!="")
                        $cm=$ctable::model ()->findByPk($_POST['Reports']['ins_cmp']);
                        if($_POST['Reports']['ins_branch']!="")
                          $bm=  $btable::model ()->findByPk($_POST['Reports']['ins_branch']);
                     
                    
                        
              }
                    $rs= Yii::app()->db->createCommand($sql)->queryAll(true);  
                    $repo=new Reports;
                    $this->render('repo19',array(
			//'model'=>$model,
                        'cm'=>$cm,
                        'bm'=>$bm,
                        'repo'=>$repo,
                        'data'=>$rs,
		));
                }
            }
        }
 public function actionRepo20()
        {
            if(isset($_POST['Reports'])){
                $cond="";
                if($_POST['Reports']['ins_cmp']!="")
                    $cond.=" and claim.insurance_company=".$_POST['Reports']['ins_cmp'];
                if($_POST['Reports']['ins_branch']!="")
                   $cond.= " and claim.branch_id=".$_POST['Reports']['ins_branch'];
                if($_POST['Reports']['start']!="")
                    $cond.=" and tab.created>='".$_POST['Reports']['start']."'";
                if($_POST['Reports']['end']!="")
                    $cond.=" and tab.created<='".$_POST['Reports']['end']."'";
                $cond.=" and tab.is_paid=1";
                 if($_POST['ins_type']=="CFS")
                      $cond.=" and claim_created_by.ins_cmp='cfs'";
                else   
                         $cond.=" and claim_created_by.ins_cmp='other'";
                $cid=  ClaimController::getClaims(1,'',true);
                if($cid!="") {
               /* $sql=" SELECT claim.file_no,claim.claim_no,claim.insurance_company,claim.date_of_loss,
                    concat(o_first_name,' ',o_last_name) as fullname,tab.created,tab.invo_name,claim_created_by.ins_cmp FROM (
                    select ac.id as acid,ac.claim_id,ac.created,ac.invo_name,ac.is_paid from appraisalcompanyinvoice ac
                        UNION ALL
                            select ap.id,ap.claim_id,ap.created,ap.invo_name,ap.is_paid from appraisalinvoice  ap
                        UNION ALL
                            select b.id , b.claim_id,b.created,b.invo_name,b.is_paid from bodyshopinvoice b
                        UNION ALL
                            select d.id ,d.claim_id,d.created,d.invo_name,d.is_paid from deskreviewerinvoice  d
                        UNION ALL
                            select t.id,t.claim_id,t.created,t.invo_name,t.is_paid from tpainvoice t 
                            ) tab left join claim on claim.id=tab.claim_id 
                            left join claim_created_by on claim_created_by.claim_id=claim.id
                            where tab.claim_id IN(".$cid.") ".$cond." order by tab.created"; */
                 $sql=" SELECT claim.file_no,claim.claim_no,claim.insurance_company,claim.date_of_loss,
                    concat(o_first_name,' ',o_last_name) as fullname,tab.created,tab.invo_name,claim_created_by.ins_cmp FROM 
                     appraisalcompanyinvoice tab left join claim on claim.id=tab.claim_id 
                            left join claim_created_by on claim_created_by.claim_id=claim.id
                            where tab.claim_id IN(".$cid.") ".$cond." order by tab.created ";
                          
                  // $type_id=  UserController::getTypeid(Yii::app()->user->id);
             // $usr=  UserController::getUserDetail(Yii::app()->user->id);
              $cond='';
            if($_POST['ins_type']=="CFS")
            {  $ctable="Company";
                $btable="Branch";
                if($_POST['Reports']['ins_cmp']!="")
                        $cm=$ctable::model ()->findByPk($_POST['Reports']['ins_cmp']);
                if($_POST['Reports']['ins_branch']!="")
                          $bm=  $btable::model ()->findByPk($_POST['Reports']['ins_branch']);
                     
            }
              else
              { $ctable="Childcompany";
                $btable="Childbranch";
                              
                        if($_POST['Reports']['ins_cmp']!="")
                        $cm=$ctable::model ()->findByPk($_POST['Reports']['ins_cmp']);
                        if($_POST['Reports']['ins_branch']!="")
                          $bm=  $btable::model ()->findByPk($_POST['Reports']['ins_branch']);
                     
                    
                        
              }
                    $rs= Yii::app()->db->createCommand($sql)->queryAll(true);  
                    $repo=new Reports;
                    $this->render('repo19',array(
			//'model'=>$model,
                        'cm'=>$cm,
                        'bm'=>$bm,
                        'repo'=>$repo,
                        'data'=>$rs,
		));
                }
            }
        }
        public function actionRepo21()
        {
            if(isset($_POST['Reports'])){
                if(isset($_POST['inv']) && count($_POST['inv'])>0)
                {
                    $today=date('Y-m-d');
                     foreach($_POST['inv'] as $inv)
                     {
                         $arr=explode("-", $inv);
                         if($arr[0]=="AppComp")
                              Appraisalcompanyinvoice::model()->updateAll(array('is_paid'=>1,'paid_date'=>$today), 'id='.$arr[1]); ;
                         if($arr[0]=="AppFee")
                             Appraisalinvoice::model()->updateAll(array('is_paid'=>1,'paid_date'=>$today), 'id='.$arr[1]); ;
                         if($arr[0]=="Body")
                             Bodyshopinvoice::model()->updateAll(array('is_paid'=>1,'paid_date'=>$today), 'id='.$arr[1]); ;
                         if($arr[0]=="CallCent")
                             Callcenterinvoice::model()->updateAll(array('is_paid'=>1,'paid_date'=>$today), 'id='.$arr[1]); ;
                        if($arr[0]=="Desk")
                            Deskreviewerinvoice::model()->updateAll(array('is_paid'=>1,'paid_date'=>$today), 'id='.$arr[1]); ;
                         if($arr[0]=="Tpa")
                             Tpainvoice::model()->updateAll(array('is_paid'=>1,'paid_date'=>$today), 'id='.$arr[1]); ;
      
                     }
                }
                $cond="";
                if($_POST['Reports']['ins_cmp']!="")
                    $cond.=" and claim.insurance_company=".$_POST['Reports']['ins_cmp'];
                if($_POST['Reports']['ins_branch']!="")
                   $cond.= " and claim.branch_id=".$_POST['Reports']['ins_branch'];
                if($_POST['Reports']['start']!="")
                    $cond.=" and tab.created>='".$_POST['Reports']['start']."'";
                if($_POST['Reports']['end']!="")
                    $cond.=" and tab.created<='".$_POST['Reports']['end']."'";
                $cond.=" and tab.is_paid=0";
                if($_POST['ins_type']=="CFS")
                      $cond.=" and claim_created_by.ins_cmp='cfs'";
                else   
                         $cond.=" and claim_created_by.ins_cmp='other'";
                $cid=  ClaimController::getClaims(1,'',true);
                if($cid!="") {
             /* $sql=" SELECT claim.file_no,claim.claim_no,claim.insurance_company,claim.date_of_loss,
                    concat(o_first_name,' ',o_last_name) as fullname,tab.created,tab.invo_name,claim_created_by.ins_cmp FROM (
                    select ac.id as acid,ac.claim_id,ac.created,ac.invo_name,ac.is_paid from appraisalcompanyinvoice ac
                        UNION ALL
                            select ap.id,ap.claim_id,ap.created,ap.invo_name,ap.is_paid from appraisalinvoice  ap
                        UNION ALL
                            select b.id  , b.claim_id,b.created,b.invo_name,b.is_paid from bodyshopinvoice b
                        UNION ALL
                            select d.id ,d.claim_id,d.created,d.invo_name,d.is_paid from deskreviewerinvoice  d
                        UNION ALL
                            select t.id ,t.claim_id,t.created,t.invo_name,t.is_paid from tpainvoice t 
                            ) tab left join claim on claim.id=tab.claim_id 
                            left join claim_created_by on claim_created_by.claim_id=claim.id
                            where claim.id IN(".$cid.") ".$cond." order by tab.created"; */
                 $sql=" SELECT tab.id,claim.file_no,claim.claim_no,claim.insurance_company,claim.date_of_loss,
                    concat(o_first_name,' ',o_last_name) as fullname,tab.created,tab.invo_name,claim_created_by.ins_cmp FROM 
                     appraisalcompanyinvoice tab left join claim on claim.id=tab.claim_id 
                            left join claim_created_by on claim_created_by.claim_id=claim.id
                            where tab.claim_id IN(".$cid.") ".$cond." order by tab.created ";
               
                          
                  // $type_id=  UserController::getTypeid(Yii::app()->user->id);
              //$usr=  UserController::getUserDetail(Yii::app()->user->id);
              $cond='';
            if($_POST['ins_type']=="CFS")
            {  $ctable="Company";
                $btable="Branch";
                if($_POST['Reports']['ins_cmp']!="")
                        $cm=$ctable::model ()->findByPk($_POST['Reports']['ins_cmp']);
                if($_POST['Reports']['ins_branch']!="")
                          $bm=  $btable::model ()->findByPk($_POST['Reports']['ins_branch']);
                     
            }
              else
              { $ctable="Childcompany";
                $btable="Childbranch";
                              
                        if($_POST['Reports']['ins_cmp']!="")
                        $cm=$ctable::model ()->findByPk($_POST['Reports']['ins_cmp']);
                        if($_POST['Reports']['ins_branch']!="")
                          $bm=  $btable::model ()->findByPk($_POST['Reports']['ins_branch']);
                     
                    
                        
              }
                    $rs= Yii::app()->db->createCommand($sql)->queryAll(true);  
                    $repo=new Reports;
                    $this->render('repo21',array(
			//'model'=>$model,
                        'cm'=>$cm,
                        'bm'=>$bm,
                        'repo'=>$repo,
                        'data'=>$rs,
		));
                }
            }
        }
            public function actionRepo31()
        {
            if(isset($_POST['Reports'])){
        
                $cond="";
                if($_POST['Reports']['company']!="")
                    $cond.=" and cmp.id=".$_POST['Reports']['company'];
                if($_POST['Reports']['branch']!="")
                   $cond.= " and b.id=".$_POST['Reports']['branch'];
                if($_POST['Reports']['start']!="")
                    $cond.=" and c.created>='".$_POST['Reports']['start']."'";
                if($_POST['Reports']['end']!="")
                    $cond.=" and c.created<='".$_POST['Reports']['end']."'";
                
                /*if($_POST['ins_type']=="CFS")
                      $cond.=" and claim_created_by.ins_cmp='cfs'";
                else   
                         $cond.=" and claim_created_by.ins_cmp='other'";*/
               $cid=  ClaimController::getClaims(1,'',true);
                if($cid!="") {
             /* $sql=" SELECT claim.file_no,claim.claim_no,claim.insurance_company,claim.date_of_loss,
                    concat(o_first_name,' ',o_last_name) as fullname,tab.created,tab.invo_name,claim_created_by.ins_cmp FROM (
                    select ac.id as acid,ac.claim_id,ac.created,ac.invo_name,ac.is_paid from appraisalcompanyinvoice ac
                        UNION ALL
                            select ap.id,ap.claim_id,ap.created,ap.invo_name,ap.is_paid from appraisalinvoice  ap
                        UNION ALL
                            select b.id  , b.claim_id,b.created,b.invo_name,b.is_paid from bodyshopinvoice b
                        UNION ALL
                            select d.id ,d.claim_id,d.created,d.invo_name,d.is_paid from deskreviewerinvoice  d
                        UNION ALL
                            select t.id ,t.claim_id,t.created,t.invo_name,t.is_paid from tpainvoice t 
                            ) tab left join claim on claim.id=tab.claim_id 
                            left join claim_created_by on claim_created_by.claim_id=claim.id
                            where claim.id IN(".$cid.") ".$cond." order by tab.created"; */
                 $sql=" SELECT c.id,c.claim_no,c.file_no,c.insurance_company,c.date_of_loss,
                     cm.name,concat(c.o_first_name,' ',c.o_last_name) as fullname,
                     concat(u.first_name,' ',u.last_name) as createby,c.created,
                     cmp.name as bname FROM `claim` c 
                     left join user u on u.id=c.created_by
                     left join branch b on b.id=u.branch_id left join company cm on cm.id=u.company_id
                     left join company cmp on cmp.id=b.company_id 
                     where c.id IN(".$cid.") ".$cond." order by c.created ";
               
                          
                  // $type_id=  UserController::getTypeid(Yii::app()->user->id);
              //$usr=  UserController::getUserDetail(Yii::app()->user->id);
              $cond='';
                   
                        if($_POST['Reports']['company']!="")
                        $cm=Company::model ()->findByPk($_POST['Reports']['company']);
                        if($_POST['Reports']['branch']!="")
                          $bm=  Branch::model ()->findByPk($_POST['Reports']['branch']);
                     
                    
                        
               
                    $rs= Yii::app()->db->createCommand($sql)->queryAll(true);  
                    $repo=new Reports;
                    $this->render('repo31',array(
			//'model'=>$model,
                        'cm'=>$cm,
                        'bm'=>$bm,
                        'repo'=>$repo,
                        'data'=>$rs,
		));
                }
            }
        }
        /**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model=Reports::model()->findAll();
                 $inv=new Callcenterinvoice;   
		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);
                 $repo=new Reports;
		if(isset($_POST['Reports']))
		{

                    if($_POST['Reports']['name']==19)
                        //$this->redirect(array('repo19'));
                    
			$model->attributes=$_POST['Reports'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id));
		}
$cmptype=new Companytype;
                $q=new CDbCriteria;
                $q->condition="t.id<=7 and t.id!=2 and t.id!=6 ";
                if($type_id<=5 || $type_id==50)
                      $q->condition="t.id<=7 and t.id!=2 ";
                $q->order="t.type";
                //var_dump($q);
		$cmptypes=$cmptype->findAll($q,array('id','type'));
		$this->render('create',array(
			'model'=>$model,
                        'inv'=>$inv,
                        'repo'=>$repo,
                        'cmptypes'=>$cmptypes,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Reports']))
		{
			$model->attributes=$_POST['Reports'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id));
		}

		$this->render('update',array(
			'model'=>$model,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		$this->loadModel($id)->delete();

		// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
		if(!isset($_GET['ajax']))
			$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		$dataProvider=new CActiveDataProvider('Reports');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new Reports('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['Reports']))
			$model->attributes=$_GET['Reports'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer $id the ID of the model to be loaded
	 * @return Reports the loaded model
	 * @throws CHttpException
	 */
	public function loadModel($id)
	{
		$model=Reports::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param Reports $model the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='reports-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
}
