<?php

class PrepurchasedclaimController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column2';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			//'accessControl', // perform access control for CRUD operations
			//'postOnly + delete', // we only allow deletion via POST request
                    'rights',
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}
        public function allowedActions() {
            return 'getdetail,savedetail,savediscount,net,thanks,getinvoice,paydetail,setnotify';
        }
        public function actionSavediscount()
        {
            if(isset($_POST['Discount']))
            {
                $mod=new Discount;
                $mod->attributes=$_POST['Discount'];
                $mod->created_by=Yii::app()->user->id;
               if($mod->save())
                   echo "Discount Saved Successfully";
               else {
                    $errors=$mod->getErrors();
                    foreach ($errors as $errs)
                    {
                        foreach ($errs as $err)
                            echo $err."<br/>";
                    }
                        
               }
            }else
                echo "Discount Not Saved";
        }
 public function actionGetinvoice()
        {  $inv=array();
            $cmp_id=$_REQUEST['company_id'];
            $tt=new Prepurchasedclaim;
                $q=new CDbCriteria;
               // $q->join=" left join pre_purchased_claim on pre_purchased_claim.id=t.invoice_id";
                $q->condition="t.company_id=".$cmp_id." and t.status='Open'";
                $data=$tt->findAll($q);
                  if($data!=null)
               { 
                     
                      foreach($data as $t) { 
                
                            $temp=array($t->invoice_no."-".$t->id);
                            $inv=  array_merge($temp,$inv);
                        
                    }
               }
             //  var_dump($inv);
                 echo CJSON::encode($inv);
                Yii::app()->end();
        }
        public function actionPaydetail()
        {
            $invoice_id=$_POST['invid'];
            $pay=  Prepurchasedclaim::model()->findByPk($invoice_id);
            $q=new CDbCriteria;
         $sql= 'SELECT sum(t.amount) as total  FROM transaction t'
                     . ' WHERE t.invoice_id = :cid ';
               // $cid = $cmp_id;
                
                $data= Yii::app()->db->createCommand($sql)->queryAll(true,array(':cid'=>$invoice_id));
                $totalpaid=$data[0]['total'];
                echo $totalpaid.",".$pay->total_amount;
                
        }

        public function actionGetdetail()
        {
            $cmp_id=$_REQUEST['company_id'];
            $ac=new Companyaccount;
            $q=new CDbCriteria;
                $q->compare('t.company_id',$cmp_id);
                $account=$ac->find($q);
                if($account==null)
                    $left_claim=0;
                else {
                    $left_claim=$account->left_claims;
                 }
                 $detail=new Companypaysetting;
                $detail=$detail->find($q);
                if($detail==null)
                {   $per_claim_price=0;
                    $free_claims=0;
                    $terms='';
                    $pre_paid_discount=0;
                    $automatic_discount=0;
                }
                else {
                    
                    $per_claim_price=$detail->per_claim_price;
                    $free_claims=$detail->free_claims;
                    $terms=$detail->terms;
                    $pre_paid_discount=$detail->pre_paid_discount;
                    $automatic_discount=$detail->automatic_discount;
                }
                
		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);
                $sql= 'SELECT sum(t.total_amount) as total  FROM pre_purchased_claim t '
                     . 'WHERE t.company_id = :cid ';
                $cid = $cmp_id;
                
                $data= Yii::app()->db->createCommand($sql)->queryAll(true,array(':cid'=>$cid));
                $totalowed=$data[0]['total'];
                $sql= 'SELECT sum(t.amount) as total  FROM transaction t left join pre_purchased_claim'
                . ' on pre_purchased_claim.id=t.invoice_id '
                     . ' WHERE pre_purchased_claim.company_id = :cid ';
                $cid = $cmp_id;
                
                $data= Yii::app()->db->createCommand($sql)->queryAll(true,array(':cid'=>$cid));
                $totalpaid=$data[0]['total'];
                $totalowed=$totalowed-$totalpaid;
                $tab='';
                $tt=new Transaction;
                $q=new CDbCriteria;
                $q->join=" left join pre_purchased_claim on pre_purchased_claim.id=t.invoice_id";
                $q->condition='pre_purchased_claim.company_id='.$cmp_id." and pre_purchased_claim.status='Open' order by t.invoice_id";
                $data=$tt->findAll($q);
                  if($data!=null)
               { $inv=array();
                      foreach($data as $t) { 
                $tab.="<tr >
                    <td>". $t->pay_date."  </td>
                    <td>".$t->amount  ."</td>
                     <td>". $t->pre->invoice_no."  </td>                   
                     <td> </td>
                     
                </tr> ";
                        
                           
                    }
                    }
                  //$inv=  CJSON::encode($inv);
                   // var_dump($inv);
                $temp=array('left_claim'=>$left_claim,'per_claim_price'=>$per_claim_price,
                  'free_claims'=>$free_claims,'terms'=>$terms,'pre_paid_discount'=>$pre_paid_discount,
                   'automatic_discount'=>$automatic_discount,'due'=>$totalowed,'tab'=>$tab);
              //  echo json_encode($temp);
              //var_dump($temp);
                //$temp=array_merge($inv,$temp);
                 echo CJSON::encode($temp);
                Yii::app()->end();
                        
        }
        public function actionSavedetail()
        {
            if (isset($_POST['Companypaysetting']) && $_POST['Company']['id']>1)
            {
                $model=new Companypaysetting;
                $q=new CDbCriteria;
                $q->compare('t.company_id',$_POST['Company']['id']);
                $c=$model->find($q);
                if($c!=null)
                    $model=  Companypaysetting::model()->findByPk($c->id);
                $model->company_id=$_POST['Company']['id'];
                $model->per_claim_price=$_POST['Companypaysetting']['per_claim_price'];
                $model->free_claims=$_POST['Companypaysetting']['free_claims'];
                $model->terms=$_POST['Companypaysetting']['terms'];
                $model->pre_paid_discount=$_POST['Companypaysetting']['pre_paid_discount'];
                $model->automatic_discount=$_POST['Companypaysetting']['automatic_discount'];
                $model->created_by=Yii::app()->user->id;
                if($model->save())
                    echo "Detail Save Successfully";
                  else {
                    $errors=$model->getErrors();
                    foreach ($errors as $errs)
                    {
                        foreach ($errs as $err)
                            echo $err."<br/>";
                    }
                        
               }
            }else
                echo "Detail Not Save";
        }
        public function actionSetnotify()
        {
            if(isset($_POST['Companyaccount']) && $_POST['Company']['id']!='' && $_POST['User']['password']!='')
            {
                $u=  User::model()->findByPk(Yii::app()->user->id);
                if($u->password==$_POST['User']['password'])
                {
                    $cmp_id=$_POST['Company']['id'];
                    $c=new Companyaccount;
                    $q=new CDbCriteria;
                    $q->compare('t.company_id',$cmp_id);
                    $mod=$c->find($q);
                    if($mod=='')
                    {   $mod=new Companyaccount;
                        $mod->left_claims=0;
                    }
                    $mod->company_id=$cmp_id;
                    $mod->notify=$_POST['Companyaccount']['notify'];
                    $mod->notify_claim=$_POST['Companyaccount']['notify_claim'];
                    $mod->responsible=$_POST['Companyaccount']['responsible'];
                    $mod->save();
                    echo "Payent Setting is Set Successfully";
                }
                else {
                    echo "Invalid Password";
                }
            }
            
        }
        public function actionPaypalAccount()
        {
            
        }

        /**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model=new Prepurchasedclaim;
                $dis=new Discount;
                $type=new Companytype;
                
		$types=$type->findAll('id<5',array('id','type'));
                $cmp=new Company;
                $brh=new Branch;
                $detail=new Companypaysetting;
                $ac=new Companyaccount;
                $user=  UserController::getUserDetail(Yii::app()->user->id);
                $cmp_id=$user->branch->company->id;
                $q=new CDbCriteria;
                $q->compare('t.company_id',$cmp_id);
                $account=$ac->find($q);
                if($account==null)
                    $account=new Companyaccount;
                //var_dump($account);
                $detail=$detail->find($q);
                if($detail==null)
                    $detail=new Companypaysetting;
		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);
                $sql= 'SELECT sum(t.total_amount) as total  FROM pre_purchased_claim t '
                     . 'WHERE t.company_id = :cid ';
                $cid = $cmp_id;
                
                $data= Yii::app()->db->createCommand($sql)->queryAll(true,array(':cid'=>$cid));
                $totalowed=$data[0]['total'];
                $sql= 'SELECT sum(t.amount) as total  FROM transaction t left join pre_purchased_claim'
                . ' on pre_purchased_claim.id=t.invoice_id '
                     . ' WHERE pre_purchased_claim.company_id = :cid ';
                $cid = $cmp_id;
                
                $data= Yii::app()->db->createCommand($sql)->queryAll(true,array(':cid'=>$cid));
                $totalpaid=$data[0]['total'];
                $totalowed=$totalowed-$totalpaid;
                $auto=new Automaticpayment;
		if(isset($_POST['Prepurchasedclaim']) && $_POST['Company']['id']!='')
		{
                    $fill=0;
                  //  $sql=" delete from temp where by_user=:cid";
                  //  $rs= Yii::app()->db->createCommand($sql)->queryAll(true,array(':cid'=>Yii::app()->user->id));
                    $temp=new Temp;
			 $temp->company_id=$_POST['Company']['id'];
                        if($_POST['pre_invoice']!="" && $_POST['inv_amt']!="" && $_POST['pay_amt']!="")
                        {
                            $temp->c_invoice_id=$_POST['pre_invoice'];
                            $temp->c_invoice_amt=$_POST['inv_amt'];
                            $temp->c_pay_amount=$_POST['pay_amt'];
                            $temp->c_balance=$_POST['inv_bal'];
                            $fill=1;
                        }
                        if($_POST['Prepurchasedclaim']['paid_claim']!="" && $_POST['Prepurchasedclaim']['claim_price']!="" 
                                && $_POST['Prepurchasedclaim']['total_amount']!="") ;
                        {
                            $temp->p_no_claims=$_POST['Prepurchasedclaim']['paid_claim'];
                            $temp->p_claim_price=$_POST['Prepurchasedclaim']['claim_price'];
                            $temp->p_total=$_POST['total_c_amt'];
                            $temp->p_pre_discount=$_POST['Prepurchasedclaim']['pre_discount'];
                            $temp->p_disc_amt=$_POST['dis_amt'];
                            $temp->p_invoice_total=$_POST['Prepurchasedclaim']['total_amount'];
                            $temp->p_pay_amt=$_POST['Prepurchasedclaim']['paid_amount'];
                            $fill=1;
                        }
                        if($_POST['Automaticpayment']['pay_amount']!="" && $_POST['Automaticpayment']['occurance']
                                && $_POST['Automaticpayment']['discount'])
                        {
                            $temp->a_pay_amt=$_POST['Automaticpayment']['pay_amount'];
                            $temp->a_occurance=$_POST['Automaticpayment']['occurance'];
                            $temp->a_auto_disc=$_POST['Automaticpayment']['discount'];
                            $fill=1;
                        }
                        if($fill==1)
                        {
                            $temp->global_discount=$_POST['gran_discount'];
                            $temp->global_pay=$_POST['grand_total'];
                            $temp->by_user=Yii::app()->user->id;
                            $temp->created=date('Y-m-d');
                            $temp->save();
                            $e=$temp->getErrors();
                          //  var_dump($e);
                            if($temp->save())
                                    $this->redirect(array('net','id'=>$temp->id));
                        }
                        else {
                            //echo "unfill";
                        }
		}

		$this->render('globalpayment',array(
			'model'=>$model,
                        'brh'=>$brh,
                        'cmp'=>$cmp,
                        'types'=>$types,
                        'detail'=>$detail,
                        'cmp_id'=>$cmp_id,
                        'account'=>$account,
                        'ac'=>$ac,
                        'totalowed'=>$totalowed,
                        'trans'=>$data,
                        'auto'=>$auto,
                        'dis'=>$dis,
		));
	}
        public function actionPayment()
        {
            $model=new Prepurchasedclaim;
                $dis=new Discount;
                $type=new Companytype;
                
		$types=$type->findAll('id<5',array('id','type'));
                $cmp=new Company;
                $brh=new Branch;
                $detail=new Companypaysetting;
                $ac=new Companyaccount;
                $user=  UserController::getUserDetail(Yii::app()->user->id);
                $cmp_id=$user->branch->company->id;
                $q=new CDbCriteria;
                $q->compare('t.company_id',$cmp_id);
                $account=$ac->find($q);
                if($account==null)
                    $account=new Companyaccount;
                //var_dump($account);
                $detail=$detail->find($q);
                if($detail==null)
                    $detail=new Companypaysetting;
		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);
                $sql= 'SELECT sum(t.total_amount) as total  FROM pre_purchased_claim t '
                     . 'WHERE t.company_id = :cid ';
                $cid = $cmp_id;
                
                $data= Yii::app()->db->createCommand($sql)->queryAll(true,array(':cid'=>$cid));
                $totalowed=$data[0]['total'];
                $sql= 'SELECT sum(t.amount) as total  FROM transaction t left join pre_purchased_claim'
                . ' on pre_purchased_claim.id=t.invoice_id '
                     . ' WHERE pre_purchased_claim.company_id = :cid ';
                $cid = $cmp_id;
                
                $data= Yii::app()->db->createCommand($sql)->queryAll(true,array(':cid'=>$cid));
                $totalpaid=$data[0]['total'];
                $totalowed=$totalowed-$totalpaid;
                $auto=new Automaticpayment;
		if(isset($_POST['Prepurchasedclaim']) && $_POST['Company']['id']!='')
		{
                    $fill=0;
                  //  $sql=" delete from temp where by_user=:cid";
                  //  $rs= Yii::app()->db->createCommand($sql)->queryAll(true,array(':cid'=>Yii::app()->user->id));
                    $temp=new Temp;
			 $temp->company_id=$_POST['Company']['id'];
                        if($_POST['pre_invoice']!="" && $_POST['inv_amt']!="" && $_POST['pay_amt']!="")
                        {
                            $temp->c_invoice_id=$_POST['pre_invoice'];
                            $temp->c_invoice_amt=$_POST['inv_amt'];
                            $temp->c_pay_amount=$_POST['pay_amt'];
                            $temp->c_balance=$_POST['inv_bal'];
                            $fill=1;
                        }
                        if($_POST['Prepurchasedclaim']['paid_claim']!="" && $_POST['Prepurchasedclaim']['claim_price']!="" 
                                && $_POST['Prepurchasedclaim']['total_amount']!="") ;
                        {
                            $temp->p_no_claims=$_POST['Prepurchasedclaim']['paid_claim'];
                            $temp->p_claim_price=$_POST['Prepurchasedclaim']['claim_price'];
                            $temp->p_total=$_POST['total_c_amt'];
                            $temp->p_pre_discount=$_POST['Prepurchasedclaim']['pre_discount'];
                            $temp->p_disc_amt=$_POST['dis_amt'];
                            $temp->p_invoice_total=$_POST['Prepurchasedclaim']['total_amount'];
                            $temp->p_pay_amt=$_POST['Prepurchasedclaim']['paid_amount'];
                            $fill=1;
                        }
                        if($_POST['Automaticpayment']['pay_amount']!="" && $_POST['Automaticpayment']['occurance']
                                && $_POST['Automaticpayment']['discount'])
                        {
                            $temp->a_pay_amt=$_POST['Automaticpayment']['pay_amount'];
                            $temp->a_occurance=$_POST['Automaticpayment']['occurance'];
                            $temp->a_auto_disc=$_POST['Automaticpayment']['discount'];
                            $fill=1;
                        }
                        if($fill==1)
                        {
                            $temp->global_discount=$_POST['gran_discount'];
                            $temp->global_pay=$_POST['grand_total'];
                            $temp->by_user=Yii::app()->user->id;
                            $temp->created=date('Y-m-d');
                            $temp->save();
                            $e=$temp->getErrors();
//                            var_dump($e);
                            if($temp->save())
                                    $this->redirect(array('net','id'=>$temp->id));
                        }
                        else {
                           // echo "unfill";
                        }
		}

		$this->render('paymentsetting',array(
			'model'=>$model,
                        'brh'=>$brh,
                        'cmp'=>$cmp,
                        'types'=>$types,
                        'detail'=>$detail,
                        'cmp_id'=>$cmp_id,
                        'account'=>$account,
                        'ac'=>$ac,
                        'totalowed'=>$totalowed,
                        'trans'=>$data,
                        'auto'=>$auto,
                        'dis'=>$dis,
                        'user'=>$user,
		));
        }

        public function actionNet($id=null)
        {
            $model=new Payaccount;
            
            if(isset($_POST['Payaccount']['card_number']))
		{ $uss=User::model()->findByPk(Yii::app()->user->id);
                $temp=  Temp::model()->findByPk($id);
                $cmp=Company::model()->findByPk($temp->company_id);
				$sale = new AuthorizeNetAIM;
				define("AUTHORIZENET_API_LOGIN_ID", "5p6Wqr7PUW3"); //5p6Wqr7PUW3 //6V5reJ6p
				define("AUTHORIZENET_TRANSACTION_KEY", "2D8ahSF679m43y3H"); //2D8ahSF679m43y3H//943Ly8zskJ3a5zRg
				define("AUTHORIZENET_SANDBOX", true); 
				$sale = new AuthorizeNetAIM;  
                                //$sale->amount = $temp->global_pay; 
                                $card=$_POST['Payaccount']['card_number'];
				//$sale->card_num =$_POST['Payaccount']['card_number'];//'6011000000000012';  
				//$sale->exp_date = $_POST['Payaccount']['expiry_month']."/".$_POST['Payaccount']['expiry_year'];//'04/15'; 
				
                                $sale->setFields(
                                        array(
                                                'amount' => ($temp->global_pay),
                                                 'card_num' =>$_POST['Payaccount']['card_number'],
                                                 'exp_date' => $_POST['Payaccount']['expiry_month']."/".$_POST['Payaccount']['expiry_year'],
                                                'first_name' => $uss->first_name,
                                                'last_name' => $uss->last_name,
                                                'address' => $uss->useraddresses->address1. " ".$uss->useraddresses->address2,
                                                'city' => $uss->useraddresses->city,
                                                'state' => $uss->useraddresses->state->name,
                                                'country' => $uss->useraddresses->country->name,
                                                'phone' => $cmp->phone_num,
                                                'zip' => $uss->useraddresses->zip,
                                                'email' => $uss->email,
                                                'company'=>$cmp->name,
                                                'fax'=>$cmp->fax_num,
                                                // 'card_code' => $_POST['x_card_code'],
                                                ));
                                                 
                                $response = $sale->authorizeAndCapture();
                                //var_dump($response);
				if ($response->approved) 
				{  
					echo $transaction_id = $response->transaction_id; 
					if(isset(Yii::app()->user->id)){
                                           
                                                $pay=new Prepurchasedclaim;
                                                $pay->company_id=$temp->company_id;
                                                $pay->claim_price=$temp->p_claim_price;
                                                $pay->pre_discount=$temp->p_pre_discount;
                                                $pay->paid_claim=$temp->p_no_claims;
                                                $pay->total_amount=$temp->p_invoice_total;
                                                $pay->paid_amount=$temp->p_pay_amt;
                                                $pay->pay_date=$temp->created;
                                                $pay->created_by=$temp->by_user;
                                                $pay->invoice_no=date('Ymdhis');
                                                if($temp->p_pay_amt==$temp->p_invoice_total)
                                                    $pay->status="Close";
                                                else {
                                                    $pay->status="Open";
                                                }
                                                if(!$pay->save())
                                                {
                                                   $err=$pay->getErrors();
                                                   foreach ($err as $arr)
                                                   {
                                                       foreach($arr as $e)
                                                           $errors.="Prepurchasedclaim-".$e."<br/>";
                                                   }
                                                }
                                                 
                                                 $q=new CDbCriteria;
                                                 $q->compare('t.company_id',$temp->company_id);
                                                 $cmp=  Companyaccount::model()->find($q);
                                                 if($cmp!=null)
                                                 {   //$cmp=new Companyaccount;
                                                    $cmp->left_claims=$temp->p_no_claims+$cmp->left_claims+$cmp->free_claims;
                                                    $cmp->save();
                                                 }
                                                 else
                                                 {
                                                     $cmp=new Companyaccount;
                                                     $cmp->company_id=$temp->company_id;
                                                     $cmp->left_claims=$temp->p_no_claims;
                                                     $cmp->responsible="Company";
                                                     $cmp->save();
                                                     
                                                 }
                                                $auto=new Automaticpayment;
                                                $auto->company_id=$temp->company_id;
                                                
                                                $auto->created_by=$temp->by_user;
                                                $auto->discount=$temp->a_auto_disc;
                                                $auto->occurance=$temp->a_occurance;
                                                $auto->card_no=substr($card,strlen($card)-4,4);
                                                $auto->pay_type="Authorized.net";
                                                $auto->pay_amount=$temp->a_pay_amt;
                                                // $auto->save();
                                                 if(!$auto->save())
                                                {
                                                   $err=$auto->getErrors();
                                                   foreach ($err as $arr)
                                                   {
                                                       foreach($arr as $e)
                                                          $errors.="Automaticpayment-".$e."<br/>";
                                                   }
                                                }
                                                 $trans=new Transaction;
                                                 $trans->invoice_id=$pay->id;
                                                 $trans->amount=$temp->p_pay_amt;
                                                 $trans->pay_date=$temp->created;
                                                 $trans->paid_by=$temp->by_user;
                                                 $trans->save();
                                                 if(!$trans->save())
                                                {
                                                   $err=$trans->getErrors();
                                                   foreach ($err as $arr)
                                                   {
                                                       foreach($arr as $e)
                                                           $errors.="Transaction-".$e."<br/>";
                                                   }
                                                }
                                                  //$err=$trans->getErrors();
                                                if($temp->c_invoice_id!="" && $temp->c_pay_amount!="")
                                                {
                                                $trans=new Transaction;
                                                 $trans->invoice_id=$temp->c_invoice_id;
                                                 $trans->amount=$temp->c_pay_amount;
                                                 $trans->pay_date=$temp->created;
                                                 $trans->paid_by=$temp->by_user;
                                                  $trans->save();
                                                   if(!$trans->save())
                                                {
                                                   $err=$trans->getErrors();
                                                   foreach ($err as $arr)
                                                   {
                                                       foreach($arr as $e)
                                                           $errors.="Transaction old-".$e."<br/>";
                                                   }
                                                }
                                                
                                                  $sql="Select sum(amount) as tot from transaction where invoice_id=:iid";
                                                  $data= Yii::app()->db->createCommand($sql)->queryAll(true,array(':iid'=>$cid));
                                                  $tot=$data[0]['tot'];
                                                  $q=new CDbCriteria;
                                                  $q->compare('t.id',$temp->c_invoice_id);
                                                  $py=new Prepurchasedclaim;
                                                  $y=$py->find($q);
                                                  if($tot==$y->total_amount)
                                                  {
                                                      $py->status="Close";
                                                      $py->save();
                                                  }
                                                }
                                                 $pp=new Payments;
                                                 $pp->company_id=$temp->company_id;
                                                 $pp->transaction_id=$trans->id;
                                                 $pp->net_transaction_id=$transaction_id;
                                                 $pp->auto_id=$auto->id;
                                                 $pp->pre_purchase_id=$pay->id;
                                                 $pp->discount_code=$temp->global_discount;
                                                 $pp->total_amt=$temp->global_pay;
                                                 $pp->created_by=$temp->by_user;
                                                 //$pp->save();
                                               if(!$pp->save())
                                                {
                                                   $err=$pp->getErrors();
                                                   foreach ($err as $arr)
                                                   {
                                                       foreach($arr as $e)
                                                           $errors.="Payments-".$e."<br/>";
                                                   }
                                                   echo $errors;
                                                }
                                                else
                                                //if($errors=="")
						$this->redirect(array('prepurchasedclaim/thanks'));
                                               // else
                                                //    echo $errors;
					}
				} 
                }
            $this->render('net',array(
                'model'=>$model,
            ));
        }
        public function actionThanks()
        {
            $model=new Temp;
                    
            $this->render('thanks',array(
                'model'=>$model,
            ));
        }

        /**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Prepurchasedclaim']))
		{
			$model->attributes=$_POST['Prepurchasedclaim'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id));
		}

		$this->render('update',array(
			'model'=>$model,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		$this->loadModel($id)->delete();

		// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
		if(!isset($_GET['ajax']))
			$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		$dataProvider=new CActiveDataProvider('Prepurchasedclaim');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new Prepurchasedclaim('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['Prepurchasedclaim']))
			$model->attributes=$_GET['Prepurchasedclaim'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer $id the ID of the model to be loaded
	 * @return Prepurchasedclaim the loaded model
	 * @throws CHttpException
	 */
	public function loadModel($id)
	{
		$model=Prepurchasedclaim::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param Prepurchasedclaim $model the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='prepurchasedclaim-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
}
