<?php

class FlagController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column2';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			//'accessControl', // perform access control for CRUD operations
			//'postOnly + delete', // we only allow deletion via POST request
			'rights',
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}
        public function allowedActions() {
            return 'getsheet';
        }

        public function actionGetsheet()
        {
           $id=$_POST['Flag']['flag_date'];
            $model=  Flag::model()->findByPk($id);
            $q=new CDbCriteria;
		$q->compare('t.flag_id',$model->id);
		$phelpers=Flagbodymanpainterhelper::model()->findAll($q);
		$painters=Flagbodymanpainter::model()->findAll($q);
		$helpers=Flagbodymanheper::model()->findAll($q);
		$bmans= Flagbodyman::model()->findAll($q);
		
		
		$phelper=new Flagbodymanpainterhelper;
		$painter=new Flagbodymanpainter;
		$helper=new Flagbodymanheper;
		$bman=new Flagbodyman;
		
		 

		$this->renderPartial('sheet',array(
			'model'=>$model,
			//'flags'=>$flags,
			'phelper'=>$phelper,
			'painter'=>$painter,
			'helper'=>$helper,
			'bman'=>$bman,
			/*'bodymans'=>$bodymans,
			'bodymanspainters'=>$bodymanspainters,
			'bodymanshelpers'=>$bodymanshelpers,
			'bodymanspaintershelpers'=>$bodymanspaintershelpers,*/
			'phelpers'=>$phelpers,
			'painters'=>$painters,
			'helpers'=>$helpers,
			'bmans'=>$bmans,
			
		));
        }

        /**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView()
	{ 
	$claimid=$_REQUEST['Claim_id'];
	$q=new CDbCriteria;
	$q->compare('t.claim_id',$claimid);
	$model=Flag::model()->find($q);

		//$model=new Flag;
		
		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);
		$flags=Flag::model()->findAll();
		$q=new CDbCriteria;
		$q->compare('t.flag_id',$model->id);
		$phelpers=Flagbodymanpainterhelper::model()->findAll($q);
		$painters=Flagbodymanpainter::model()->findAll($q);
		$helpers=Flagbodymanheper::model()->findAll($q);
		$bmans= Flagbodyman::model()->findAll($q);
		
		
		$phelper=new Flagbodymanpainterhelper;
		$painter=new Flagbodymanpainter;
		$helper=new Flagbodymanheper;
		$bman=new Flagbodyman;
		
		
		/*$usertype=UserController::getTypeid(Yii::app()->user->id);
		$brch=new Branch;
		$q=new CDbCriteria;
		$q->join="left join user on user.branch_id=t.id";
		$q->compare('user.id',Yii::app()->user->id);
		$br=$brch->find($q);
		$cmp_id=$br->company_id;
		$usr=new User;
		$q=new CDbCriteria;
		$q->join="left join authassignment on authassignment.userid=t.id left join branch on branch.id=t.branch_id";
        $q->compare('authassignment.itemname','40');
		 if($usertype!=5)
		 $q->compare('branch.company_id',$cmp_id);
		 $bodymans=$usr->findAll($q);
		 
		 $q=new CDbCriteria;
		$q->join="left join authassignment on authassignment.userid=t.id left join branch on branch.id=t.branch_id";
        $q->compare('authassignment.itemname','38');
		if($usertype!=5)
		 $q->compare('branch.company_id',$cmp_id);
		 $bodymanspainters=$usr->findAll($q);
		 
		 $q=new CDbCriteria;
		$q->join="left join authassignment on authassignment.userid=t.id left join branch on branch.id=t.branch_id";
        $q->compare('authassignment.itemname','41');
		if($usertype!=5)
		 $q->compare('branch.company_id',$cmp_id);
		 $bodymanshelpers=$usr->findAll($q);
		 
		 
		 $q=new CDbCriteria;
		$q->join="left join authassignment on authassignment.userid=t.id left join branch on branch.id=t.branch_id";
        $q->compare('authassignment.itemname','39');
		if($usertype!=5)
		 $q->compare('branch.company_id',$cmp_id);
		 $bodymanspaintershelpers=$usr->findAll($q);*/
	 

		$this->render('view',array(
			'model'=>$model,
			'flags'=>$flags,
			'phelper'=>$phelper,
			'painter'=>$painter,
			'helper'=>$helper,
			'bman'=>$bman,
			/*'bodymans'=>$bodymans,
			'bodymanspainters'=>$bodymanspainters,
			'bodymanshelpers'=>$bodymanshelpers,
			'bodymanspaintershelpers'=>$bodymanspaintershelpers,*/
			'phelpers'=>$phelpers,
			'painters'=>$painters,
			'helpers'=>$helpers,
			'bmans'=>$bmans,
			
		));
		 
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model=new Flag;
		
		$claimid=$_REQUEST['Claim_id'];
		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);
		$flags=Flag::model()->findAll();
		$phelper=new Flagbodymanpainterhelper;
		$painter=new Flagbodymanpainter;
		$helper=new Flagbodymanheper;
		$bman=new Flagbodyman;
		$usertype=UserController::getTypeid(Yii::app()->user->id);
		$brch=new Branch;
		$q=new CDbCriteria;
		$q->join="left join user on user.branch_id=t.id";
		$q->compare('user.id',Yii::app()->user->id);
		$br=$brch->find($q);
		$cmp_id=$br->company_id;
		$usr=new User;
		$q=new CDbCriteria;
		$q->join="left join authassignment on authassignment.userid=t.id left join branch on branch.id=t.branch_id";
        $q->compare('authassignment.itemname','40');
		 if($usertype!=5)
		 $q->compare('branch.company_id',$cmp_id);
		 $bodymans=$usr->findAll($q);
		 
		 $q=new CDbCriteria;
		$q->join="left join authassignment on authassignment.userid=t.id left join branch on branch.id=t.branch_id";
        $q->compare('authassignment.itemname','38');
		if($usertype!=5)
		 $q->compare('branch.company_id',$cmp_id);
		 $bodymanspainters=$usr->findAll($q);
		 
		 $q=new CDbCriteria;
		$q->join="left join authassignment on authassignment.userid=t.id left join branch on branch.id=t.branch_id";
        $q->compare('authassignment.itemname','41');
		if($usertype!=5)
		 $q->compare('branch.company_id',$cmp_id);
		 $bodymanshelpers=$usr->findAll($q);
		 
		 
		 $q=new CDbCriteria;
		$q->join="left join authassignment on authassignment.userid=t.id left join branch on branch.id=t.branch_id";
        $q->compare('authassignment.itemname','39');
		if($usertype!=5)
		 $q->compare('branch.company_id',$cmp_id);
		 $bodymanspaintershelpers=$usr->findAll($q);
		if(isset($_POST['Flag']))
		{
			$model->attributes=$_POST['Flag'];
			$model->claim_id=$claimid;
			$model->flag_date=date('Y-m-d H:i:s');
			$model->created_by=Yii::app()->user->id;
			if($model->save())
			{	
				$size=count($_POST['bodymans']);
				if($size>0)
				{
					for($i=0;$i<$size;$i++)
					{
						$bm=new Flagbodyman;
						$bm->flag_id=$model->id;
						$bm->userid=$_POST['bodymans'][$i];
						$bm->log_hours=$_POST['bodymanslog_hours'][$i];
						$bm->reason=$_POST['bodymansreason'][$i];
						$bm->save();
					}
				}
				$size=count($_POST['bmanhelp']);
				if($size>0)
				{
					for($i=0;$i<$size;$i++)
					{
						$bm=new Flagbodymanheper;
						$bm->flag_id=$model->id;
						$bm->userid=$_POST['bmanhelp'][$i];
						$bm->log_hours=$_POST['bmanhelplog_hours'][$i];
						$bm->reason=$_POST['bmanhelpreason'][$i];
						$bm->save();
					}
				}
						$size=count($_POST['painter']);
				if($size>0)
				{
					for($i=0;$i<$size;$i++)
					{
						$bm=new Flagbodymanpainter;
						$bm->flag_id=$model->id;
						$bm->userid=$_POST['painter'][$i];
						$bm->log_hours=$_POST['painterlog_hours'][$i];
						$bm->reason=$_POST['painterreason'][$i];
						$bm->save();
					}
				}
				
				$size=count($_POST['painterhelper']);
				if($size>0)
				{
					for($i=0;$i<$size;$i++)
					{
						$bm=new Flagbodymanpainterhelper;
						$bm->flag_id=$model->id;
						$bm->userid=$_POST['painterhelper'][$i];
						$bm->log_hours=$_POST['painterhelperlog_hours'][$i];
						$bm->reason=$_POST['painterhelperreason'][$i];
						$bm->save();
					}
				}
                                CallcenterinvoiceController::setautostatus(58,$claimid);
			   $this->redirect(array('view','id'=>$model->id));
			
			}
		}

		$this->render('create',array(
			'model'=>$model,
			'flags'=>$flags,
			'phelper'=>$phelper,
			'painter'=>$painter,
			'helper'=>$helper,
			'bman'=>$bman,
			'bodymans'=>$bodymans,
			'bodymanspainters'=>$bodymanspainters,
			'bodymanshelpers'=>$bodymanshelpers,
			'bodymanspaintershelpers'=>$bodymanspaintershelpers,
			
			
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);

		//$model=new Flag;
		$claimid=$_REQUEST['Claim_id'];
		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);
		$flags=Flag::model()->findAll();
		$q=new CDbCriteria;
		$q->compare('t.flag_id',$model->id);
		$phelpers=Flagbodymanpainterhelper::model()->findAll($q);
		$painters=Flagbodymanpainter::model()->findAll($q);
		$helpers=Flagbodymanheper::model()->findAll($q);
		$bmans= Flagbodyman::model()->findAll($q);
		
		
		$phelper=new Flagbodymanpainterhelper;
		$painter=new Flagbodymanpainter;
		$helper=new Flagbodymanheper;
		$bman=new Flagbodyman;
		
		
		$usertype=UserController::getTypeid(Yii::app()->user->id);
		$brch=new Branch;
		$q=new CDbCriteria;
		$q->join="left join user on user.branch_id=t.id";
		$q->compare('user.id',Yii::app()->user->id);
		$br=$brch->find($q);
		$cmp_id=$br->company_id;
		$usr=new User;
		$q=new CDbCriteria;
		$q->join="left join authassignment on authassignment.userid=t.id left join branch on branch.id=t.branch_id";
        $q->compare('authassignment.itemname','40');
		 if($usertype!=5)
		 $q->compare('branch.company_id',$cmp_id);
		 $bodymans=$usr->findAll($q);
		 
		 $q=new CDbCriteria;
		$q->join="left join authassignment on authassignment.userid=t.id left join branch on branch.id=t.branch_id";
        $q->compare('authassignment.itemname','38');
		if($usertype!=5)
		 $q->compare('branch.company_id',$cmp_id);
		 $bodymanspainters=$usr->findAll($q);
		 
		 $q=new CDbCriteria;
		$q->join="left join authassignment on authassignment.userid=t.id left join branch on branch.id=t.branch_id";
        $q->compare('authassignment.itemname','41');
		if($usertype!=5)
		 $q->compare('branch.company_id',$cmp_id);
		 $bodymanshelpers=$usr->findAll($q);
		 
		 
		 $q=new CDbCriteria;
		$q->join="left join authassignment on authassignment.userid=t.id left join branch on branch.id=t.branch_id";
        $q->compare('authassignment.itemname','39');
		if($usertype!=5)
		 $q->compare('branch.company_id',$cmp_id);
		 $bodymanspaintershelpers=$usr->findAll($q);
		if(isset($_POST['Flag']))
		{
			$model->attributes=$_POST['Flag'];
			$model->claim_id=$claimid;
			$model->flag_date=date('Y-m-d H:i:s');
			$model->created_by=Yii::app()->user->id;
			if($model->save())
			{	
				$size=count($_POST['bodymans']);
				if($size>0)
				{
					for($i=0;$i<$size;$i++)
					{
					$bm=new Flagbodyman;
					if($_POST['bodymansid'][$i]!=null)
						{
						$bm=Flagbodyman::model()->findByPk($_POST['bodymansid'][$i]);
						}
						
						$bm->flag_id=$model->id;
						$bm->userid=$_POST['bodymans'][$i];
						$bm->log_hours=$_POST['bodymanslog_hours'][$i];
						$bm->reason=$_POST['bodymansreason'][$i];
						
						$bm->save();
					}
				}
				$size=count($_POST['bmanhelp']);
				if($size>0)
				{
					for($i=0;$i<$size;$i++)
					{
						$bm=new Flagbodymanheper;
						if($_POST['bmanhelpid'][$i]!=null)
						{
						$bm=Flagbodymanheper::model()->findByPk($_POST['bmanhelpid'][$i]);
						}
						$bm->flag_id=$model->id;
						$bm->userid=$_POST['bmanhelp'][$i];
						$bm->log_hours=$_POST['bmanhelplog_hours'][$i];
						$bm->reason=$_POST['bmanhelpreason'][$i];
						$bm->save();
					}
				}
						$size=count($_POST['painter']);
				if($size>0)
				{
					for($i=0;$i<$size;$i++)
					{
						$bm=new Flagbodymanpainter;
						if($_POST['painterid'][$i]!=null)
						{
						$bm=Flagbodymanpainter::model()->findByPk($_POST['painterid'][$i]);
						}
						$bm->flag_id=$model->id;
						$bm->userid=$_POST['painter'][$i];
						$bm->log_hours=$_POST['painterlog_hours'][$i];
						$bm->reason=$_POST['painterreason'][$i];
						$bm->save();
					}
				}
				
				$size=count($_POST['painterhelper']);
				if($size>0)
				{
					for($i=0;$i<$size;$i++)
					{
						$bm=new Flagbodymanpainterhelper;
						if($_POST['painterhelperid'][$i]!=null)
						{
						$bm=Flagbodymanpainterhelper::model()->findByPk($_POST['painterhelperid'][$i]);
						}
						$bm->flag_id=$model->id;
						$bm->userid=$_POST['painterhelper'][$i];
						$bm->log_hours=$_POST['painterhelperlog_hours'][$i];
						$bm->reason=$_POST['painterhelperreason'][$i];
						$bm->save();
					}
				}
                                CallcenterinvoiceController::setautostatus(58,$claimid);
			   $this->redirect(array('view','id'=>$model->id));
			
			}
		}

		$this->render('update',array(
			'model'=>$model,
			'flags'=>$flags,
			'phelper'=>$phelper,
			'painter'=>$painter,
			'helper'=>$helper,
			'bman'=>$bman,
			'bodymans'=>$bodymans,
			'bodymanspainters'=>$bodymanspainters,
			'bodymanshelpers'=>$bodymanshelpers,
			'bodymanspaintershelpers'=>$bodymanspaintershelpers,
			'phelpers'=>$phelpers,
			'painters'=>$painters,
			'helpers'=>$helpers,
			'bmans'=>$bmans,
			
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		$this->loadModel($id)->delete();

		// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
		if(!isset($_GET['ajax']))
			$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		$dataProvider=new CActiveDataProvider('Flag');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new Flag('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['Flag']))
			$model->attributes=$_GET['Flag'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer $id the ID of the model to be loaded
	 * @return Flag the loaded model
	 * @throws CHttpException
	 */
	public function loadModel($id)
	{
		$model=Flag::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param Flag $model the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='flag-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
}
