<?php

class FilenumbergenerationController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column2';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
			'postOnly + delete', // we only allow deletion via POST request
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model=new Filenumbergeneration;
                $user=User::model()->findByPk(Yii::app()->user->id);
                $utype=  UserController::getTypeid(Yii::app()->user->id);
                if($utype!=12 && $utype!=21 && $utype!=29 && $utype!=37 && $utype>5 && $utype!=50)
                {   $cmp_id=$user->branch->company->id;
                    $cnt=Claim::getNewFileNumber($user->branch_id,$cmp_id);
                }
                else
                {   $cmp_id=$user->company_id;
                      $cnt=Claim::getNewFileNumber("",$cmp_id);
                }
                $file_no='';
                if($cnt!=null)
                {
                 foreach($cnt as $tot)
		{
			$file_no= $tot['file_no'];	
		}
                }
		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);
                 $q=new CDbCriteria;
                $q->compare('t.company_id',$cmp_id);
                $m=$model->find($q);
                if($m!=null)
                  $this->redirect(array('update','id'=>$m->id));
		if(isset($_POST['Filenumbergeneration']))
		{
			$model->attributes=$_POST['Filenumbergeneration'];
                        $model->company_id=$cmp_id;
                        $model->created_by=Yii::app()->user->id;
			if($model->save())
				Yii::app()->user->setFlash('success','File Number generation is set');
                         
		}

		$this->render('create',array(
			'model'=>$model,
                        'file_no'=>$file_no,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);
                $user=User::model()->findByPk(Yii::app()->user->id);
                $utype=  UserController::getTypeid(Yii::app()->user->id);
                if($utype!=12 && $utype!=21 && $utype!=29 && $utype!=37 && $utype>5 && $utype!=50)
                {   $cmp_id=$user->branch->company->id;
                    $cnt=Claim::getNewFileNumber($user->branch_id,$cmp_id);
                }
                else
                {   $cmp_id=$user->company_id;
                      $cnt=Claim::getNewFileNumber("",$cmp_id);
                }
                //$cmp_id=$user->branch->company->id;
               // $cnt=Claim::getNewFileNumber($user->branch_id);
                $file_no='';
                if($cnt!=null)
                {
                 foreach($cnt as $tot)
		{
                      
			$file_no= $tot['file_no'];	
		}
                }
		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Filenumbergeneration']))
		{
			$model->attributes=$_POST['Filenumbergeneration'];
                         $model->created_by=Yii::app()->user->id;
			if($model->save())
				Yii::app()->user->setFlash('success','File Number generation is set');
                         
		}

		$this->render('update',array(
			'model'=>$model,
                        'file_no'=>$file_no,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		$this->loadModel($id)->delete();

		// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
		if(!isset($_GET['ajax']))
			$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		$dataProvider=new CActiveDataProvider('Filenumbergeneration');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new Filenumbergeneration('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['Filenumbergeneration']))
			$model->attributes=$_GET['Filenumbergeneration'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer $id the ID of the model to be loaded
	 * @return Filenumbergeneration the loaded model
	 * @throws CHttpException
	 */
	public function loadModel($id)
	{
		$model=Filenumbergeneration::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param Filenumbergeneration $model the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='filenumbergeneration-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
}
