<?php

class CommunicationController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column2';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			// 'accessControl', // perform access control for CRUD operations
			// 'postOnly + delete', // we only allow deletion via POST request
			'rights',
		);
	}
	
	public function allowedActions()
	{
		return 'getcom,getccom,detail,getu,getcu,marstr,marar,marfg,xadd,xaddc,getsntc,dashboard,getarcc,getacc';
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view','poll'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}
	
	public function actionPoll()
	{
		$this->dbswitch(Yii::app()->user->firm_id);
		$model = new Communication();
		$c = new CDbCriteria;
		// $c->join ='left join cases c on c.id=t.case_id left join client cl on cl.id = c.user_id left join users u on u.id=cl.user_id';
		
		$c->join ='left join communication_user cu on cu.communication_id=t.id';
		$c->compare('cu.user_id',Yii::app()->user->id);
		$c->compare('cu.is_read','0');
		$com = $model->findAll($c);
		
		$c = new CDbCriteria;
		// $c->join ='left join cases c on c.id=t.case_id left join client cl on cl.id = c.user_id left join users u on u.id=cl.user_id';
		$c->join ='left join communication_user cu on cu.communication_id=t.id';
		$c->compare('cu.user_id',Yii::app()->user->id);
		$c->compare('cu.is_read','0');
		$c->compare('t.message_type','Internal');
		$int = $model->findAll($c);
		
		$c = new CDbCriteria;
		// $c->join ='left join cases c on c.id=t.case_id left join client cl on cl.id = c.user_id left join users u on u.id=cl.user_id';
		$c->join ='left join communication_user cu on cu.communication_id=t.id';
		$c->compare('cu.user_id',Yii::app()->user->id);
		$c->compare('cu.is_read','0');
		$c->compare('t.message_type','Client');
		$cli = $model->findAll($c);
		
		$arr['count'] = count($com);
		$arr['int'] = count($int);
		$arr['cli'] = count($cli);
		$arr['plz'] = '0';
		echo json_encode($arr);
	}
        
	public function actionMarstr(){
		$this->dbswitch(Yii::app()->user->firm_id);
		$model = CommunicationUser::model()->findByPk($_REQUEST['q']);
		$data['message'] = 'error';
		if(isset($model)){
			if($model->is_star){
				$model->is_star = '0';
				$data['message'] = 'done';
			}else{
				$model->is_star = '1';
				$data['message'] = 'success';
			}
			$sd = $model->save();
			if($sd){
				// $data['message'] = 'success';
			}
		}
		echo json_encode($data);
	}

	public function actionMarar(){
		$this->dbswitch(Yii::app()->user->firm_id);
		$data = json_decode(file_get_contents("php://input"));
		 
		if(isset($data->q)){
			// var_dump($data->q);
			// die();
			$model = CommunicationUser::model()->findByPk($data->q);
			$dat['message'] = 'error';
			if(isset($model)){
				if($model->is_archive){
					$model->is_archive = '0';
					$dat['message'] = 'success';
				}else{
					$model->is_archive = '1';
					$dat['message'] = 'success';
				}
				$sd = $model->save();
			}
		}
		
		if(isset($data->qa) && !empty($data->qa)){
			$df = json_decode($data->qa);
			$dat['message'] = 'error';
			foreach($df as $d){
				// var_dump($d->cd);
				// die();
				$model = CommunicationUser::model()->findByPk($d->cd);			
				if(isset($model)){
					if($model->is_archive){
						$model->is_archive = '0';
						$dat['message'] = 'success';
					}else{
						$model->is_archive = '1';
						$dat['message'] = 'success';
					}
					$sd = $model->save();
				}
			}
			// die();			
		}
		
		echo json_encode($dat);
	}
	
	public function actionMarfg(){
		$this->dbswitch(Yii::app()->user->firm_id);
		$model = CommunicationUser::model()->findByPk($_REQUEST['q']);
		$data['message'] = 'error';
		if(isset($model)){
			if($model->is_flag){
				$model->is_flag = '0';
				$data['message'] = 'done';
			}else{
				$model->is_flag = '1';
				$data['message'] = 'success';
			}
			$sd = $model->save();
			if($sd){
				// $data['message'] = 'success';
			}
		}
		echo json_encode($data);
	}
	
	public function actionXadd(){
		$data = json_decode(file_get_contents("php://input"));
		$this->dbswitch(Yii::app()->user->firm_id);
		$model = new Communication;
		$su = false;
		$dat['message'] = 'error';
		if(isset($data->a) && (isset($data->b) || isset($data->c))){
			$model->subject = $data->b;
			$model->message = $data->c;
			$model->created_by = Yii::app()->user->id;
			$model->entry_date = date('Y-m-d H:i:s');
			$model->message_type = 'Internal';
			$model->save();
			$mpk = $model->primaryKey;
			if($mpk){
				foreach($data->a as $k){
					$model1 = new CommunicationUser;
					$model1->user_id = $k;
					$model1->communication_id = $mpk ;
					$model1->save();
				}
				$su = true;
				$dat['message'] = 'success';
			}
		}
		if($su){
			echo json_encode($dat);
		}
		// echo json_encode($data);
	}
	
	public function actionXaddc(){
		$data = json_decode(file_get_contents("php://input"));
		$this->dbswitch(Yii::app()->user->firm_id);
		$model = new Communication;
		$su = false;
		$dat['message'] = 'error';
		// var_dump($data);
		if(isset($data->a) && (isset($data->b) || isset($data->c))){
			$model->subject = $data->d;
			$model->message = $data->e;
			$model->created_by = Yii::app()->user->id;
			$model->entry_date = date('Y-m-d H:i:s');
			$model->message_type = 'Client';
			$model->case_id = $data->b;
			$model->save();
			// var_dump($model->getErrors());
			$mpk = $model->primaryKey;
			if($mpk){
				// foreach($data->a as $k){
				$c1 = User::model()->findByPk(Yii::app()->user->id);
				if(!isset($c1->client->id)){
					$model1 = new CommunicationUser;
					$model1->user_id = $data->a;
					$model1->communication_id = $mpk ;
					$model1->save();
				}
				// }
				if(isset($data->c)){
					foreach($data->c as $k){
						$model1 = new CommunicationUser;
						$model1->user_id = $k;
						$model1->communication_id = $mpk ;
						$model1->save();				
					}
				}
				$su = true;
				$dat['message'] = 'success';
			}
		}
		// if($su){
			echo json_encode($dat);
		// }
		Yii::app()->end();
	}
	
	public function mailr($usr = null,$arr = null){
            $us = new User;
            $doc = new Document;
            $c = new CDbCriteria;            
            $c->compare('id',$usr);
            $user = $us->find($c);
            $c = new CDbCriteria;            
            $c->compare('id',$arr['Communication']['created_by']);
            $creator = $user->find($c);            
            $mail = new YiiMailer('communication');  
            $mail->IsSMTP();
            $mail->SMTPAuth = true;			
            $mail->Host = 'mail.plawza.com';
            //$mail->SMTPDebug  = 2;
            $mail->Port = '26';
            $mail->Username = 'no-reply@plawza.com';			
            $mail->Password = 'y*vD@aeU]g8#';			
            $mail->setFrom('no-reply@plawza.com', 'Plawza');
            $mail->setTo($user->email);
            // $mail->setTo('dhimandee@gmail.com');
            $mail->setSubject('Communication Initiated at Intronect');
            $mail->setData(array('user' => $user,'creator'=>$creator, 'data'=>$arr));
            $mail->setBody('Simple message');
            if(isset($arr['CommunicationDocument']['document_id'])){
            foreach($arr['CommunicationDocument']['document_id'] as $key=>$val){
                $q = new CDbCriteria;
                $q->compare('id',$val);
                $dc = $doc->find($q);
                //var_dump(Yii::app()->request->hostInfo . Yii::app()->request->baseURL . '/documents/' . $dc->filename);
                //var_dump(dirname(dirname(dirname(__FILE__))).'/documents/' . $dc->filename);
                $mail->setAttachment(array( dirname(dirname(dirname(__FILE__))).'/documents/' . $dc->filename => $dc->display_name.'.'.$dc->doc_type));
            }}
            if ($mail->send()) {
                    Yii::app()->user->setFlash('contact','Thank you for contacting us. We will respond to you as soon as possible.');
                    // var_dump(error_get_last());
                    // var_dump($mail->getError());
                   // var_dump($mail->ErrorInfo);
            } else {
                    Yii::app()->user->setFlash('error','Error while sending email: '.$mail->getError());
                   // var_dump(error_get_last());
                   // var_dump($mail->getError());
                   // var_dump($mail->ErrorInfo);
            }
           // die();
            /*
            $us = new User;
            $doc = new Document;
            $c = new CDbCriteria;            
            $c->compare('id',$usr);
            $user = $us->find($c);
            $c = new CDbCriteria;            
            $c->compare('id',$arr['Communication']['created_by']);
            $creator = $user->find($c);
            $mail = new YiiMailer();            
            //set properties
            $mail->setFrom('reply@intronect.com');
            $mail->setTo($user->email);
            $mail->setSubject('Intronect Communication Initiated');
            $mail->setBody('Intronect Communication Initiated');
            var_dump($user->email);
            */
            //send
         
            //try {
           // $mail->setView('communication');
            //$mail->setFrom('no-reply@intronect.com', 'Intronect');
            //$mail->setTo($user->email);
            //$mail->setSubject('Intronect :: Communication Initiated');
            //$mail->setData(array('user' => $user,'creator'=>$creator, 'data'=>$arr));
//            if(isset($arr['CommunicationDocument']['document_id'])){foreach($arr['CommunicationDocument']['document_id'] as $key=>$val){
//                $q = new CDbCriteria;
//                $q->compare('id',$val);
//                $dc = $doc->find($q);
//                $mail->setAttachment(array(Yii::app()->request->hostInfo . Yii::app()->request->baseURL . '/documents/' . $dc->filename => $dc->display_name.'.'.$dc->doc_type));
//            }}
//            $mail->send();
//            }catch (phpmailerException $e) {
//                echo $e->errorMessage(); //Pretty error messages from PHPMailer
//                die();
//            } catch (Exception $e) {
//                echo $e->getMessage(); //Boring error messages from anything else!
//                die();
//            }
        }
        
	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{		$this->layout='logged';
		$model=new Communication;
                $case = new Cases;
                $doc = new Document;
                $model1 = new CommunicationDocument;
                $model2 = new CommunicationUser;
                $q = new CDbCriteria;
                $q->join = 'left join user on t.created_by=user.id';
                $q->compare('user.firm_id',Yii::app()->user->firm_id);
                $docs = $doc->findAll($q);
                
                $usr = new User;
		$q = new CDbCriteria;
		$q->join = "left join authassignment on authassignment.userid = t.id";
		$q->compare('authassignment.itemname','Client');
		$q->compare('t.firm_id',Yii::app()->user->firm_id);
		$clients = $usr->findAll($q);
		$q = new CDbCriteria;
		$q->join = "left join authassignment on authassignment.userid = t.id";
		$q->condition = "authassignment.itemname <> 'Client'";
		$q->compare('t.firm_id',Yii::app()->user->firm_id);
		$users = $usr->findAll($q);
                
		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Communication']))
		{
			//var_dump($_POST);
                        $model->attributes=$_POST['Communication'];
                        $model->entry_date = $_POST['Communication']['entry_date'];
			if($model->save()){
                            $cid = $model->primaryKey;
                            if(isset($_POST['CommunicationDocument']['document_id'])){  
                            foreach($_POST['CommunicationDocument']['document_id'] as $key=>$val){
                                $de = new CommunicationDocument;
                                $de->communication_id = $cid;
                                $de->document_id = $val;
                                $de->save();
                            }}
                            if(isset($_POST['CommunicationUser'][0]) && is_array($_POST['CommunicationUser'][0]['user_id'])){
                            foreach($_POST['CommunicationUser'][0]['user_id'] as $ck=>$cu){                                
                                    $de = new CommunicationUser;
                                    $de->communication_id = $cid;
                                    $de->user_id = $cu;                                    
                                    $de->save();
                                    $this->mailr($cu, $_POST);
                            }}
                            if(isset($_POST['CommunicationUser'][1]) && is_array($_POST['CommunicationUser'][1]['user_id'])){
                            foreach($_POST['CommunicationUser'][1]['user_id'] as $ck=>$cu){                                
                                    $de = new CommunicationUser;
                                    $de->communication_id = $cid;
                                    $de->user_id = $cu;                                    
                                    $de->save();
                                    $this->mailr($cu, $_POST);
                            }}
                            foreach(Yii::app()->user->getFlashes() as $key => $message) {
                               echo '<div class="flash-' . $key . '">' . $message . "</div>\n";
                            }
                            $this->redirect(array('admin'));                        
                        }
		}

		$this->render('create',array(
			'model'=>$model,
                        'model1'=>$model1,
                        'model2'=>$model2,
                        'case'=>$case,
                        'docs'=>$docs,
                        'users'=>$users,
			'clients'=>$clients,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);
		$this->layout='logged';
		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Communication']))
		{
			$model->attributes=$_POST['Communication'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id));
		}

		$this->render('update',array(
			'model'=>$model,
		));
	}
	
	public function actionGetdetail(){
		$this->dbswitch(Yii::app()->user->firm_id);    
		$model=new Communication;
		$cd = new CDbCriteria;
		$cd->compare('t.id',$_REQUEST['id']);
		$da = $model->find($cd);
		$str="";
		// die('sads');
		if(isset($da->id)){			
			// Communication::model()->updateByPk($da->id,array('is_read'=>'1'));
			$post = CommunicationUser::model()->find('communication_id=:cid and user_id=:uid', array(':cid'=>$da->id,'uid'=>Yii::app()->user->id));
			// if(!$post->is_read){
				// $post->is_read = '1';
				// $post->save();
			// }			
			$str.='<div class="table_responsive"><table class="table table-bordered table-hover"><tbody><tr><th>Entry Date</th><td>'.date('m/d/Y',strtotime($da->entry_date)).'</td><th>Case Name</th><td>'.$da->case->case_no.'</td></tr><tr><th colspan="4">Subject</th></tr><tr><td colspan="4">'.$da->subject.'</td></tr><tr><th colspan="4">Message</th></tr><tr><td colspan="4">'.$da->message.'</td></tr></tbody></table></div>';
		}
		echo $str;
		Yii::app()->end();
	}
	
	public function actionDashboards()
	{
		$this->layout ="newd1"; 
		$this->dbswitch(Yii::app()->user->firm_id);
		$at=date('Y-m-d');
		$cond=" and t.created>='".$at."'";
		$cond2="  t.created>='".$at."'";
		$order="ASC";
		if(isset($_REQUEST['falert'])) 
		{	
			$at=date('Y-m-d',strtotime($_REQUEST['falert']));
			$cond=" and t.created>='".$at."'";
			$cond2="  t.created>='".$at."'";
			$order="ASC";
		}
		$dataProvider=new CActiveDataProvider('Communication',array(
					'criteria' => array(
						// 'with' =>'sector',
						// 'condition' =>'cu.user_id=:id and t.message_type=:ty',
						'condition' =>' '.$cond2,
						// $cd->compare('c.id',$_SESSION['client']);
						// 'params' => array(':id'=>Yii::app()->user->id,'ty'=>'Internal'),
						'order' => 't.created DESC',
						// 'join' => 'left join cases c on c.id=t.case_id left join client cl on cl.id = c.user_id left join users u on u.id=cl.user_id',
						// 'join' => 'left join communication_user cu on cu.communication_id=t.id',
					)
				));
		// if(isset($_SESSION['dashboard_type'])){
			// if($_SESSION['dashboard_type']=='Client')
				
		$dataProvider1=new CActiveDataProvider('Communication',array(
			'criteria' => array(						
				'condition' =>'cu.user_id=:id and t.message_type=:ty',						
				'params' => array(':id'=>Yii::app()->user->id,'ty'=>'Client'),	
				'order' => 't.created DESC',
				'join' => 'left join communication_user cu on cu.communication_id=t.id',
				'group' => 't.slug'
			)
		));
		// }
			
		$aj='';
		if(isset($_GET['ajax'])){
			$aj=$_GET['ajax'];
			// $this->render('dashboarda',array(
			$this->render('dashboards',array(
				'dataProvider'=>$dataProvider,
				'dataProvider1'=>$dataProvider1,
				'aj'=>$aj
			));		
		}else{
			$this->render('dashboards',array(
				'dataProvider'=>$dataProvider,	
				'dataProvider1'=>$dataProvider1,
			));	
		}
	}
	
	public function actionDashboard()
	{
		$this->layout ="newd1"; 
		$this->dbswitch(Yii::app()->user->firm_id);
		
		$dataProvider=new CActiveDataProvider('Communication',array(
					'criteria' => array(
						// 'with' =>'sector',
						'condition' =>'cu.user_id=:id and t.message_type=:ty',
						// $cd->compare('c.id',$_SESSION['client']);
						'params' => array(':id'=>Yii::app()->user->id,'ty'=>'Internal'),
						'order' => 't.created DESC',
						// 'join' => 'left join cases c on c.id=t.case_id left join client cl on cl.id = c.user_id left join users u on u.id=cl.user_id',
						'join' => 'left join communication_user cu on cu.communication_id=t.id',
					)
				));
		// if(isset($_SESSION['dashboard_type'])){
			// if($_SESSION['dashboard_type']=='Client')
				
		$dataProvider1=new CActiveDataProvider('Communication',array(
			'criteria' => array(						
				'condition' =>'cu.user_id=:id and t.message_type=:ty',						
				'params' => array(':id'=>Yii::app()->user->id,'ty'=>'Client'),	
				'order' => 't.created DESC',
				'join' => 'left join communication_user cu on cu.communication_id=t.id',
			)
		));
		// }
			
		$aj='';
		if(isset($_GET['ajax'])){
			$aj=$_GET['ajax'];
			// $this->render('dashboarda',array(
			$this->render('dashboard',array(
				'dataProvider'=>$dataProvider,
				'dataProvider1'=>$dataProvider1,
				'aj'=>$aj
			));		
		}else{
			$this->render('dashboard',array(
				'dataProvider'=>$dataProvider,	
				'dataProvider1'=>$dataProvider1,
			));	
		}
	}
	
	public function actionGetsntc()
	{
		$this->layout ="ajax"; 
		$this->dbswitch(Yii::app()->user->firm_id);
		$end = ($_GET['cp'] * $_GET['ipp']) - 1;
		$start = $end - ($_GET['ipp']-1);
		$com = new Communication;
		$cd = new CDbCriteria;
		$cd->join = "left join communication_user cu on cu.communication_id=t.id left join cases cs on cs.id = t.case_id";
		$ft = User::model()->getUtype();
		$Cll = User::model()->findByPk($_SESSION['client']);
		// var_dump($_SESSION['client']);
		// var_dump($ft);
		if(array_search('Client',$ft)!==false){
			// echo'588';
			$Cll = User::model()->findByPk(Yii::app()->user->id);
		}
		$C1 = User::model()->findByPk(Yii::app()->user->id);
		// var_dump(!isset($_SESSION['client'])  || (array_search('Client',$ft)===false));
		if(!isset($_SESSION['client'])  || (array_search('Client',$ft)===false)){
			// var_dump(isset($C1->client->id));
			if(isset($C1->client->id)){
				$Cll = $C1;
				// echo'597';
			}else{
				$Cll = User::model()->findByPk($_SESSION['client']);
				// echo'600';
			}
		}
		if(isset($_REQUEST['mn'])){
			if($_REQUEST['mn']=='star'){
				$cd->condition = 't.message_type=:ty and t.created_by=:id and cu.is_star=:st and cs.user_id=:cl';
				// $cd->condition = 't.message_type=:ty and t.created_by=:id and cu.is_star=:st ';
			}			
			if($_REQUEST['mn']=='flag'){
				$cd->condition = 't.message_type=:ty and t.created_by=:id and cu.is_flag=:st and cs.user_id=:cl';				
				// $cd->condition = 't.message_type=:ty and t.created_by=:id and cu.is_flag=:st ';				
			}
			$cd->params = array(':id'=>Yii::app()->user->id,'ty'=>'Client','st'=>'1','cl'=>$Cll->client->id);
			// $cd->params = array(':id'=>Yii::app()->user->id,'ty'=>'Client','st'=>'1');
		}else{
			// var_dump($Cll->client->id);
			// $cd->condition = 't.message_type=:ty and t.created_by=:id';
			// if(isset($_SESSION['dashboard_type']) && ($_SESSION['dashboard_type']=='My' ||$_SESSION['dashboard_type']=='Admin')){
			if(!isset($Cll->client->id)){
				$cd->condition = 't.message_type=:ty and t.created_by=:id';
				$cd->params = array(':id'=>Yii::app()->user->id,'ty'=>'Client');
				// var_dump($Cll->id);
			}else{
				$cd->condition = 't.message_type=:ty and t.created_by=:id and cs.user_id=:cl';
				$cd->params = array(':id'=>Yii::app()->user->id,'ty'=>'Client','cl'=>$Cll->client->id);
			}			
			// $cd->params = array(':id'=>Yii::app()->user->id,'ty'=>'Client');
		}
		$cd->order = 't.created DESC';
		$cd->limit = $_GET['ipp'];
		$cd->offset = $start;
		$comms = $com->findAll($cd);
		
		$cd = new CDbCriteria;
		$cd->join = "left join communication_user cu on cu.communication_id=t.id left join cases cs on cs.id = t.case_id";		
		if(isset($_REQUEST['mn'])){
			if($_REQUEST['mn']=='star'){
				$cd->condition = 't.message_type=:ty and t.created_by=:id and cu.is_star=:st  and cs.user_id=:cl';
			}			
			if($_REQUEST['mn']=='flag'){
				$cd->condition = 't.message_type=:ty and t.created_by=:id and cu.is_flag=:st  and cs.user_id=:cl';				
			}
			$cd->params = array(':id'=>Yii::app()->user->id,'ty'=>'Client','st'=>'1','cl'=>$Cll->client->id);
		}else{
			// $cd->condition = 't.message_type=:ty and t.created_by=:id  and cs.user_id=:cl';
			// $cd->params = array(':id'=>Yii::app()->user->id,'ty'=>'Client','cl'=>$Cll->client->id);
			if(!isset($Cll->client->id)){
				$cd->condition = 't.message_type=:ty and t.created_by=:id';
				$cd->params = array(':id'=>Yii::app()->user->id,'ty'=>'Client');
				// var_dump($Cll->id);
			}else{
				$cd->condition = 't.message_type=:ty and t.created_by=:id and cs.user_id=:cl';
				$cd->params = array(':id'=>Yii::app()->user->id,'ty'=>'Client','cl'=>$Cll->client->id);
			}
		}
		$cd->order = 't.created DESC';
		$commsa = $com->findAll($cd);
		
		$cd = new CDbCriteria;
		$cd->join = "left join communication_user cu on cu.communication_id=t.id  left join cases cs on cs.id = t.case_id";
		$cd->condition = 't.message_type=:ty and cu.user_id=:id and cu.is_read=:read  and cs.user_id=:cl';
		$cd->params = array(':id'=>Yii::app()->user->id,'ty'=>'Client','read'=>'0','cl'=>$Cll->client->id);
		// $cd->order = 't.created DESC';
		$commi = $com->findAll($cd);
		// var_dump(count($commi));
		$data = '';
		
		// var_dump(count($comms));
		$d=0;$k11=1;
		foreach($comms as $co){
			$d=$co->slug;
			$data[$d]['slug'] = $co->slug;
			$fg='To: '; 
			foreach($co->user as $kl){
				if(isset($kl->profile->fullname))
					$fg .= $kl->profile->fullname.' & ';
					
				if(isset($kl->client->fullname))
					$fg .= $kl->client->fullname.' & ';
			}
			$fg = substr($fg,0,-2);
			// $data[$d]['from'] = $co->createdBy->profile->fullname;
			$data[$d]['from'] = $fg;
			$data[$d]['subject'] = $co->subject;
			$data[$d]['message'] = $co->message;
			
			$data[$d]['read'] = 'read';
			$data[$d]['times'] = $k11;$k11++;
			$data[$d]['str'] = 'glyphicon-star-empty';
			$data[$d]['flg'] = 'fa-flag-o';
			foreach($co->cuser as $cj){
				if($cj->user_id == Yii::app()->user->id){
					$data[$d]['cud'] = $cj->id;
					if($cj->is_read)
						$data[$d]['read'] = 'read';
					if($cj->is_star)
						$data[$d]['str'] = 'glyphicon-star active';
					if($cj->is_flag)
						$data[$d]['flg'] = 'fa-flag active';
				}				
			}
			// var_dump($co->created);
			if(date('Y')==date('Y',strtotime($co->created))){
				if(date('Y-m-d')==date('Y-m-d',strtotime($co->created))){
					$data[$d]['time'] = date('h:i A',strtotime($co->created));
				}else{
					$data[$d]['time'] = date('M, d',strtotime($co->created));
				}
			}else{
				$data[$d]['time'] = date('m/d/Y',strtotime($co->created));
			}
			$d++;
		}
		$dat['total'] = count($commsa);
		$dat['totali'] = count($commi);
		$dat['dats'] = $data;
		// array_reverse($dat);
		echo json_encode($dat);
		Yii::app()->end();
	}
	
	public function actionGetarc()
	{
		$this->layout ="ajax"; 
		$this->dbswitch(Yii::app()->user->firm_id);
		$end = ($_GET['cp'] * $_GET['ipp']) - 1;
		$start = $end - ($_GET['ipp']-1);
		$com = new Communication;
		$cd = new CDbCriteria;
		$cd->join = "left join communication_user cu on cu.communication_id=t.id";
		if(isset($_REQUEST['mn'])){
			if($_REQUEST['mn']=='star'){
				$cd->condition = 't.message_type=:ty and t.created_by=:id and cu.is_star=:st';
			}			
			if($_REQUEST['mn']=='flag'){
				$cd->condition = 't.message_type=:ty and t.created_by=:id and cu.is_flag=:st';				
			}
			$cd->params = array(':id'=>Yii::app()->user->id,'st'=>'1');
		}else{
			// $cd->condition = 't.created_by=:id and cu.is_archive=:ar';
			// $cd->params = array(':id'=>Yii::app()->user->id,'ar'=>'1');
			$cd->condition = 't.message_type=:ty and cu.user_id=:id and cu.is_archive=:ar';
			$cd->params = array(':id'=>Yii::app()->user->id,'ty'=>'Internal','ar'=>'1');
		}
		$cd->order = 't.created DESC';
		$cd->limit = $_GET['ipp'];
		$cd->offset = $start;
		$comms = $com->findAll($cd);
		
		$cd = new CDbCriteria;
		$cd->join = "left join communication_user cu on cu.communication_id=t.id";		
		if(isset($_REQUEST['mn'])){
			if($_REQUEST['mn']=='star'){
				$cd->condition = 't.message_type=:ty and t.created_by=:id and cu.is_star=:st';
			}			
			if($_REQUEST['mn']=='flag'){
				$cd->condition = 't.message_type=:ty and t.created_by=:id and cu.is_flag=:st';				
			}
			$cd->params = array(':id'=>Yii::app()->user->id,'ty'=>'Internal','st'=>'1');
		}else{
			// $cd->condition = 't.created_by=:id and cu.is_archive=:ar';
			// $cd->params = array(':id'=>Yii::app()->user->id,'ar'=>'1');
			$cd->condition = 't.message_type=:ty and cu.user_id=:id and cu.is_archive=:ar';
			$cd->params = array(':id'=>Yii::app()->user->id,'ty'=>'Internal','ar'=>'1');
		}
		$cd->order = 't.created DESC';
		$commsa = $com->findAll($cd);
		
		$cd = new CDbCriteria;
		$cd->join = "left join communication_user cu on cu.communication_id=t.id";
		// $cd->condition = 'cu.user_id=:id and cu.is_archive=:read';
		// $cd->params = array(':id'=>Yii::app()->user->id,'read'=>'0');
		$cd->condition = 't.message_type=:ty and cu.user_id=:id and cu.is_archive=:ar';
		$cd->params = array(':id'=>Yii::app()->user->id,'ty'=>'Internal','ar'=>'1');
		// $cd->order = 't.created DESC';
		$commi = $com->findAll($cd);
		
		$data = '';
		
		// var_dump(count($comms));
		$d=0;
		foreach($comms as $co){
			$data[$d]['slug'] = $co->slug;
			// $fg='To: ';
			// foreach($co->user as $kl){
				// $fg .= $kl->profile->fullname.' & ';
			// }
			// $fg = substr($fg,0,-2);
			// $data[$d]['from'] = $co->createdBy->profile->fullname;
			if(isset($co->createdBy->profile->fullname)){
				$data[$d]['from'] = $co->createdBy->profile->fullname;
			}else{
				$data[$d]['from'] = $co->createdBy->client->fullname;
			}
			// $data[$d]['from'] = $fg;
			$data[$d]['subject'] = $co->subject;
			$data[$d]['message'] = $co->message;
			
			$data[$d]['read'] = '';
			$data[$d]['str'] = 'glyphicon-star-empty';
			$data[$d]['flg'] = 'fa-flag-o';
			foreach($co->cuser as $cj){
				if($cj->user_id == Yii::app()->user->id){
					$data[$d]['cud'] = $cj->id;
					if($cj->is_read)
						$data[$d]['read'] = 'read';
					if($cj->is_star)
						$data[$d]['str'] = 'glyphicon-star active';
					if($cj->is_flag)
						$data[$d]['flg'] = 'fa-flag active';
				}				
			}
			// var_dump($co->created);
			if(date('Y')==date('Y',strtotime($co->created))){
				if(date('Y-m-d')==date('Y-m-d',strtotime($co->created))){
					$data[$d]['time'] = date('h:i A',strtotime($co->created));
				}else{
					$data[$d]['time'] = date('M, d',strtotime($co->created));
				}
			}else{
				$data[$d]['time'] = date('m/d/Y',strtotime($co->created));
			}
			$d++;
		}
		$dat['total'] = count($commsa);
		$dat['totali'] = count($commi);
		$dat['dats'] = $data;
		echo json_encode($dat);
		Yii::app()->end();
	}
	
	
	public function actionGetarcc()
	{
		$this->layout ="ajax"; 
		$this->dbswitch(Yii::app()->user->firm_id);
		$end = ($_GET['cp'] * $_GET['ipp']) - 1;
		$start = $end - ($_GET['ipp']-1);
		$com = new Communication;
		$cd = new CDbCriteria;
		// $cd->join = "left join communication_user cu on cu.communication_id=t.id";
		$cd->join = "left join communication_user cu on cu.communication_id=t.id left join cases cs on cs.id = t.case_id";
		$Cll = User::model()->findByPk($_SESSION['client']);
		$C1 = User::model()->findByPk(Yii::app()->user->id);
		if(!isset($_SESSION['client'])){			
			if($C1->client->id){
				$Cll = $C1;
			}
		}
		if(isset($_REQUEST['mn'])){
			// if($_REQUEST['mn']=='star'){
				// $cd->condition = 't.message_type=:ty and t.created_by=:id and cu.is_star=:st';
			// }			
			// if($_REQUEST['mn']=='flag'){
				// $cd->condition = 't.message_type=:ty and t.created_by=:id and cu.is_flag=:st';				
			// }
			// $cd->params = array(':id'=>Yii::app()->user->id,'st'=>'1');
			
			if($_REQUEST['mn']=='star'){
				$cd->condition = 't.message_type=:ty and t.created_by=:id and cu.is_star=:st and cs.user_id=:cl';
			}			
			if($_REQUEST['mn']=='flag'){
				$cd->condition = 't.message_type=:ty and t.created_by=:id and cu.is_flag=:st and cs.user_id=:cl';				
			}
			$cd->params = array(':id'=>Yii::app()->user->id,'st'=>'1','cl'=>$Cll->client->id);
		}else{
			// $cd->condition = 't.created_by=:id and cu.is_archive=:ar';
			// $cd->params = array(':id'=>Yii::app()->user->id,'ar'=>'1');
			// $cd->condition = 't.message_type=:ty and cu.user_id=:id and cu.is_archive=:ar and cs.user_id=:cl';
			// $cd->params = array(':id'=>Yii::app()->user->id,'ty'=>'Client','ar'=>'1','cl'=>$Cll->client->id);
			if(isset($_SESSION['client'])){
				// $cd->condition = 't.message_type=:ty and cu.user_id=:id and cu.is_archive=:ar and cs.user_id=:cl';
				// $cd->condition = 't.message_type=:ty and cu.user_id=:id and cu.is_archive<>:ar';  //In Case of reply client is null
				// $cd->params = array('id'=>Yii::app()->user->id,'ty'=>'Client','ar'=>'1','cl'=>$Cll->client->id);
				  // $cd->params = array('id'=>Yii::app()->user->id,'ty'=>'Client','ar'=>'1');
				// var_dump(Yii::app()->user->id);
				// var_dump($cd->params);
				$ft = User::model()->getUtype();		
				if(array_search('Client',$ft)!==false){
					$cd->condition = 't.message_type=:ty and cu.user_id=:id and cu.is_archive=:ar';
					// $cd->condition = 't.message_type=:ty and cu.user_id=:id and cu.is_archive<>:ar';  //In Case of reply client is null
					$cd->params = array('id'=>Yii::app()->user->id,'ty'=>'Client','ar'=>'1');
				}else{
					$cd->condition = 't.message_type=:ty and cu.user_id=:id and cu.is_archive=:ar and cs.user_id=:cl';
					// $cd->condition = 't.message_type=:ty and cu.user_id=:id and cu.is_archive<>:ar';  //In Case of reply client is null
					$cd->params = array('id'=>Yii::app()->user->id,'ty'=>'Client','ar'=>'1','cl'=>$Cll->client->id);
				}
			}else{
				if(isset($Cll->client->id)){
					// $cd->condition = 't.message_type=:ty and cu.user_id=:id and cu.is_archive=:ar and cs.user_id=:cl';
					$cd->condition = 't.message_type=:ty and cu.user_id=:id and cu.is_archive=:ar';
					//$cd->params = array('id'=>Yii::app()->user->id,'ty'=>'Client','ar'=>'1','cl'=>$Cll->client->id);
					// var_dump('1181');
					// $cd->params = array('id'=>Yii::app()->user->id,'ty'=>'Client','ar'=>'0','cl'=>$Cll->client->id);
					$cd->params = array('id'=>Yii::app()->user->id,'ty'=>'Client','ar'=>'1');
				}else{					
					$cd->condition = 't.message_type=:ty and cu.user_id=:id and cu.is_archive=:ar';
					//$cd->params = array('id'=>Yii::app()->user->id,'ty'=>'Client','ar'=>'1');
					// var_dump('1185');
					// var_dump(Yii::app()->user->id);
					$cd->params = array('id'=>Yii::app()->user->id,'ty'=>'Client','ar'=>'1');
				}
			}	
		}
		$cd->order = 't.created DESC';
		$cd->limit = $_GET['ipp'];
		$cd->offset = $start;
		$comms = $com->findAll($cd);
		
		$cd = new CDbCriteria;
		$cd->join = "left join communication_user cu on cu.communication_id=t.id left join cases cs on cs.id=t.case_id";
		if(isset($_REQUEST['mn'])){
			if($_REQUEST['mn']=='star'){
				$cd->condition = 't.message_type=:ty and t.created_by=:id and cu.is_star=:st and cs.user_id = :cl';
			}			
			if($_REQUEST['mn']=='flag'){
				$cd->condition = 't.message_type=:ty and t.created_by=:id and cu.is_flag=:st and cs.user_id = :cl';				
			}
			$cd->params = array(':id'=>Yii::app()->user->id,'ty'=>'Client','st'=>'1','cl'=>$Cll->client->id);
		}else{
			// $cd->condition = 't.created_by=:id and cu.is_archive=:ar';
			// $cd->params = array(':id'=>Yii::app()->user->id,'ar'=>'1');
			$cd->condition = 't.message_type=:ty and cu.user_id=:id and cu.is_archive=:ar and cs.user_id=:cl';
			$cd->params = array(':id'=>Yii::app()->user->id,'ty'=>'Client','ar'=>'1','cl'=>$Cll->client->id);
		}
		$cd->order = 't.created DESC';
		$commsa = $com->findAll($cd);
		
		$cd = new CDbCriteria;
		$cd->join = "left join communication_user cu on cu.communication_id=t.id";
		// $cd->condition = 'cu.user_id=:id and cu.is_archive=:read';
		// $cd->params = array(':id'=>Yii::app()->user->id,'read'=>'0');
		$cd->condition = 't.message_type=:ty and cu.user_id=:id and cu.is_archive=:ar';
		$cd->params = array(':id'=>Yii::app()->user->id,'ty'=>'Client','ar'=>'1');
		// $cd->order = 't.created DESC';
		$commi = $com->findAll($cd);
		
		$data = '';
		
		// var_dump(count($comms));
		$d=0;
		foreach($comms as $co){
			$data[$d]['slug'] = $co->slug;
			// $fg='To: ';
			// foreach($co->user as $kl){
				// $fg .= $kl->profile->fullname.' & ';
			// }
			// $fg = substr($fg,0,-2);
			if(isset($co->createdBy->profile->fullname)){
				$data[$d]['from'] = $co->createdBy->profile->fullname;
			}else{
				$data[$d]['from'] = $co->createdBy->client->fullname;
			}
			
			// $data[$d]['from'] = $fg;
			$data[$d]['subject'] = $co->subject;
			$data[$d]['message'] = $co->message;			
			$data[$d]['read'] = '';
			$data[$d]['str'] = 'glyphicon-star-empty';
			$data[$d]['flg'] = 'fa-flag-o';
			foreach($co->cuser as $cj){
				if($cj->user_id == Yii::app()->user->id){
					$data[$d]['cud'] = $cj->id;
					if($cj->is_read)
						$data[$d]['read'] = 'read';
					if($cj->is_star)
						$data[$d]['str'] = 'glyphicon-star active';
					if($cj->is_flag)
						$data[$d]['flg'] = 'fa-flag active';
				}				
			}
			// var_dump($co->created);
			if(date('Y')==date('Y',strtotime($co->created))){
				if(date('Y-m-d')==date('Y-m-d',strtotime($co->created))){
					$data[$d]['time'] = date('h:i A',strtotime($co->created));
				}else{
					$data[$d]['time'] = date('M, d',strtotime($co->created));
				}
			}else{
				$data[$d]['time'] = date('m/d/Y',strtotime($co->created));
			}
			$d++;
		}
		$dat['total'] = count($commsa);
		$dat['totali'] = count($commi);
		$dat['dats'] = $data;
		echo json_encode($dat);
		Yii::app()->end();
	}
	
	
	public function actionGetsnt()
	{
		// die();
		// var_dump(Yii::app()->user->id);
		// var_dump(Yii::app()->user->email);
		$this->layout ="ajax"; 
		$this->dbswitch(Yii::app()->user->firm_id);
		$end = ($_GET['cp'] * $_GET['ipp']) - 1;
		$start = $end - ($_GET['ipp']-1);
		$com = new Communication;
		$cd = new CDbCriteria;
		$cd->join = "left join communication_user cu on cu.communication_id=t.id";
		if(isset($_REQUEST['mn'])){
			if($_REQUEST['mn']=='star'){
				$cd->condition = 't.message_type=:ty and t.created_by=:id and cu.is_star=:st';
			}			
			if($_REQUEST['mn']=='flag'){
				$cd->condition = 't.message_type=:ty and t.created_by=:id and cu.is_flag=:st';				
			}
			$cd->params = array(':id'=>Yii::app()->user->id,'ty'=>'Internal','st'=>'1');
		}else{
			$cd->condition = 't.message_type=:ty and t.created_by=:id';
			// $cd->condition = ' t.created_by=:id';
			$cd->params = array(':id'=>Yii::app()->user->id,'ty'=>'Internal');
			// $cd->params = array(':id'=>Yii::app()->user->id);
		}
		$cd->order = 't.created DESC';
		$cd->limit = $_GET['ipp'];
		$cd->offset = $start;
		$comms = $com->findAll($cd);
		
		$cd = new CDbCriteria;
		$cd->join = "left join communication_user cu on cu.communication_id=t.id";		
		if(isset($_REQUEST['mn'])){
			if($_REQUEST['mn']=='star'){
				$cd->condition = 't.message_type=:ty and t.created_by=:id and cu.is_star=:st';
			}			
			if($_REQUEST['mn']=='flag'){
				$cd->condition = 't.message_type=:ty and t.created_by=:id and cu.is_flag=:st';				
			}
			$cd->params = array(':id'=>Yii::app()->user->id,'ty'=>'Internal','st'=>'1');
		}else{
			$cd->condition = 't.message_type=:ty and t.created_by=:id';
			// $cd->condition = ' t.created_by=:id';
			$cd->params = array(':id'=>Yii::app()->user->id,'ty'=>'Internal');
			// $cd->params = array(':id'=>Yii::app()->user->id);
		}
		$cd->order = 't.created DESC';
		$commsa = $com->findAll($cd);
		
		$cd = new CDbCriteria;
		$cd->join = "left join communication_user cu on cu.communication_id=t.id";
		$cd->condition = 't.message_type=:ty and cu.user_id=:id and cu.is_read=:read';
		$cd->params = array(':id'=>Yii::app()->user->id,'ty'=>'Internal','read'=>'0');
		// $cd->order = 't.created DESC';
		$commi = $com->findAll($cd);
		
		$data = '';
		
		// var_dump(count($comms));
		$d=0;
		foreach($comms as $co){
			$data[$d]['slug'] = $co->slug;
			$fg='To: ';
			foreach($co->user as $kl){
				if(isset($kl->profile->fullname)){
					$fg .= $kl->profile->fullname.' & ';
				}else{
					$fg .= $kl->client->fullname.' & ';
				}				
			}
			$fg = substr($fg,0,-2);
			// $data[$d]['from'] = $co->createdBy->profile->fullname;
			$data[$d]['from'] = $fg;
			$data[$d]['subject'] = $co->subject;
			$data[$d]['message'] = $co->message;			
			$data[$d]['read'] = 'read';
			$data[$d]['str'] = 'glyphicon-star-empty';
			$data[$d]['flg'] = 'fa-flag-o';
			foreach($co->cuser as $cj){
				if($cj->user_id == Yii::app()->user->id){
					$data[$d]['cud'] = $cj->id;
					if($cj->is_read)
						$data[$d]['read'] = 'read';
					if($cj->is_star)
						$data[$d]['str'] = 'glyphicon-star active';
					if($cj->is_flag)
						$data[$d]['flg'] = 'fa-flag active';
				}				
			}
			if(date('Y')==date('Y',strtotime($co->created))){
				if(date('Y-m-d')==date('Y-m-d',strtotime($co->created))){
					$data[$d]['time'] = date('h:i A',strtotime($co->created));
				}else{
					$data[$d]['time'] = date('M, d',strtotime($co->created));
				}
			}else{
				$data[$d]['time'] = date('m/d/Y',strtotime($co->created));
			}
			$d++;
		}
		$dat['total'] = count($commsa);
		$dat['totali'] = count($commi);
		$dat['dats'] = $data;
		echo json_encode($dat);
		Yii::app()->end();
	}
	
	
	public function actionGetcom()
	{
		$this->layout ="ajax"; 
		$this->dbswitch(Yii::app()->user->firm_id);
		$end = ($_GET['cp'] * $_GET['ipp']) - 1;
		$start = $end - ($_GET['ipp']-1);
		$com = new Communication;
		$cd = new CDbCriteria;
		$cd->join = "left join communication_user cu on cu.communication_id=t.id left join cases cs on cs.id = t.case_id";
		if(isset($_REQUEST['mn'])){
			if(isset($cll->client->id)){
				if($_REQUEST['mn']=='star'){
					$cd->condition = 't.message_type=:ty and cu.user_id=:id and cu.is_star=:st and cu.is_archive<>:ar and cs.user_id=:cl';
				}			
				if($_REQUEST['mn']=='flag'){
					$cd->condition = 't.message_type=:ty and cu.user_id=:id and cu.is_flag=:st and cu.is_archive<>:ar and cs.user_id=:cl';				
				}
			}else{
				if($_REQUEST['mn']=='star'){
					$cd->condition = 't.message_type=:ty and cu.user_id=:id and cu.is_star=:st and cu.is_archive<>:ar';
				}			
				if($_REQUEST['mn']=='flag'){
					$cd->condition = 't.message_type=:ty and cu.user_id=:id and cu.is_flag=:st and cu.is_archive<>:ar';				
				}
			}
			// $cd->params = array(':id'=>Yii::app()->user->id,'ty'=>'Internal','st'=>'1','ar'=>'1');
			$cll = User::model()->findByPk(Yii::app()->user->id);
			if(isset($cll->client->id)){
				$cd->params = array(':id'=>Yii::app()->user->id,'cl'=>$cll->client->id,'ty'=>'Client','st'=>'1','ar'=>'1');
			}else{
				$cd->params = array(':id'=>Yii::app()->user->id,'ty'=>'Internal','st'=>'1','ar'=>'1');
			}
		}else{
			$cd->condition = 't.message_type=:ty and cu.user_id=:id and cu.is_archive<>:ar';
			$cll = User::model()->findByPk(Yii::app()->user->id);
			if(isset($cll->client->id)){
				$cd->params = array(':id'=>Yii::app()->user->id,'ty'=>'Client','ar'=>'1');
			}else{
				$cd->params = array(':id'=>Yii::app()->user->id,'ty'=>'Internal','ar'=>'1');
			}
		}		
		$cd->order = 't.created DESC';
		$cd->limit = $_GET['ipp'];
		$cd->offset = $start;
		$comms = $com->findAll($cd);
		
		$cd = new CDbCriteria;
		$cd->join = "left join communication_user cu on cu.communication_id=t.id";		
		if(isset($_REQUEST['mn'])){
			if($_REQUEST['mn']=='star'){
				$cd->condition = 't.message_type=:ty and cu.user_id=:id and cu.is_star=:st and cu.is_archive<>:ar';
			}			
			if($_REQUEST['mn']=='flag'){
				$cd->condition = 't.message_type=:ty and cu.user_id=:id and cu.is_flag=:st and cu.is_archive<>:ar';				
			}
			$cd->params = array(':id'=>Yii::app()->user->id,'ty'=>'Internal','st'=>'1','ar'=>'1');
		}else{
			$cd->condition = 't.message_type=:ty and cu.user_id=:id and cu.is_archive<>:ar';
			$cd->params = array(':id'=>Yii::app()->user->id,'ty'=>'Internal','ar'=>'1');
		}
		$cd->order = 't.created DESC';
		$commsa = $com->findAll($cd);
		
		$cd = new CDbCriteria;
		$cd->join = "left join communication_user cu on cu.communication_id=t.id";
		$cd->condition = 't.message_type=:ty and cu.user_id=:id and cu.is_read=:read and cu.is_archive<>:ar';
		// $cd->params = array(':id'=>Yii::app()->user->id,'ty'=>'Internal','read'=>'0','ar'=>'1');
		$cll = User::model()->findByPk(Yii::app()->user->id);
		if(isset($cll->client->id)){
			$cd->params = array(':id'=>Yii::app()->user->id,'ty'=>'Client','read'=>'0','ar'=>'1');
		}else{
			$cd->params = array(':id'=>Yii::app()->user->id,'ty'=>'Internal','read'=>'0','ar'=>'1');
		}
		// $cd->order = 't.created DESC';
		$commi = $com->findAll($cd);
		
		$data = '';
		
		// var_dump(count($comms));
		$d=0;
		foreach($comms as $co){
			$data[$d]['slug'] = $co->slug;
			// $data[$d]['from'] = $co->createdBy->profile->fullname;
			if(isset($co->createdBy->profile->fullname)){
				$data[$d]['from'] = $co->createdBy->profile->fullname;
			}else{
				$data[$d]['from'] = $co->createdBy->client->fullname;
			}
			$data[$d]['subject'] = $co->subject;
			$data[$d]['message'] = $co->message;
			
			$data[$d]['read'] = '';
			$data[$d]['str'] = 'glyphicon-star-empty';
			$data[$d]['flg'] = 'fa-flag-o';
			foreach($co->cuser as $cj){
				if($cj->user_id == Yii::app()->user->id){
					$data[$d]['cud'] = $cj->id;
					if($cj->is_read)
						$data[$d]['read'] = 'read';
					if($cj->is_star)
						$data[$d]['str'] = 'glyphicon-star active';
					if($cj->is_flag)
						$data[$d]['flg'] = 'fa-flag active';
				}				
			}
			if(date('Y')==date('Y',strtotime($co->created))){
				if(date('Y-m-d')==date('Y-m-d',strtotime($co->created))){
					$data[$d]['time'] = date('h:i A',strtotime($co->created));
				}else{
					$data[$d]['time'] = date('M, d',strtotime($co->created));
				}
			}else{
				$data[$d]['time'] = date('m/d/Y',strtotime($co->created));
			}
			$d++;
		}
		$dat['total'] = count($commsa);
		$dat['totali'] = count($commi);
		$dat['dats'] = $data;
		echo json_encode($dat);
		Yii::app()->end();
	}
	
	public function actionGetccom()
	{
		$this->layout ="ajax"; 
		$this->dbswitch(Yii::app()->user->firm_id);
		$end = ($_GET['cp'] * $_GET['ipp']) - 1;
		$start = $end - ($_GET['ipp']-1);
		$com = new Communication;
		$cd = new CDbCriteria;
		$ft = User::model()->getUtype();
		 
		$Cll = User::model()->findByPk($_SESSION['client']);
		// var_dump(Yii::app()->user->firm_id);
		if(array_search('Client',$ft)!==false){
			$Cll = User::model()->findByPk(Yii::app()->user->id);
		}
		$C1 = User::model()->findByPk(Yii::app()->user->id);
		if(!isset($_SESSION['client'])){			
			if($C1->client->id || (array_search('Client',$ft)!==false)){
				$Cll = $C1;
				 
			}
		}
		// var_dump($Cll->client->id);
		$cd->join = "left join communication_user cu on cu.communication_id=t.id left join cases cs on cs.id = t.case_id";		
		if(isset($_REQUEST['mn'])){
			if($_REQUEST['mn']=='star'){
				//$cd->condition = 't.message_type=:ty and cu.user_id=:id and cu.is_star=:st and cu.is_archive<>:ar and cs.user_id=:cl';
				// $cd->condition = 't.message_type=:ty and cu.user_id=:id and cu.is_star=:st and cu.is_archive<>:ar';
				if(isset($_SESSION['client'])){
					$cd->condition = 't.message_type=:ty and cu.user_id=:id and cu.is_star=:st and cu.is_archive<>:ar and cs.user_id=:cl';
					$cd->params = array('id'=>Yii::app()->user->id,'ty'=>'Client','st'=>'1','ar'=>'1','cl'=>$Cll->client->id);
				}else{
					$cd->condition = 't.message_type=:ty and cu.user_id=:id and cu.is_star=:st and cu.is_archive<>:ar';
					$cd->params = array('id'=>Yii::app()->user->id,'ty'=>'Client','st'=>'1','ar'=>'1');
				}
			}			
			if($_REQUEST['mn']=='flag'){
				// $cd->condition = 't.message_type=:ty and cu.user_id=:id and cu.is_flag=:st and cu.is_archive<>:ar and cs.user_id=:cl';
				// $cd->condition = 't.message_type=:ty and cu.user_id=:id and cu.is_flag=:st and cu.is_archive<>:ar';
				if(isset($_SESSION['client'])){
					$cd->condition = 't.message_type=:ty and cu.user_id=:id and cu.is_flag=:st and cu.is_archive<>:ar and cs.user_id=:cl';
					$cd->params = array('id'=>Yii::app()->user->id,'ty'=>'Client','st'=>'1','ar'=>'1','cl'=>$Cll->client->id);
				}else{
					$cd->condition = 't.message_type=:ty and cu.user_id=:id and cu.is_flag=:st and cu.is_archive<>:ar';
					$cd->params = array('id'=>Yii::app()->user->id,'ty'=>'Client','st'=>'1','ar'=>'1');
				}
			}
			// $cd->params = array('id'=>Yii::app()->user->id,'ty'=>'Client','st'=>'1','ar'=>'1','cl'=>$Cll->client->id);
			// $cd->params = array('id'=>Yii::app()->user->id,'ty'=>'Client','st'=>'1','ar'=>'1');
		}else{
			if(isset($_SESSION['client'])){
				$cd->condition = 't.message_type=:ty and cu.user_id=:id and cu.is_archive<>:ar and cs.user_id=:cl';
				// $cd->condition = 't.message_type=:ty and cu.user_id=:id and cu.is_archive<>:ar';  //In Case of reply client is null
				$cd->params = array('id'=>Yii::app()->user->id,'ty'=>'Client','ar'=>'1','cl'=>$Cll->client->id);
				  // $cd->params = array('id'=>Yii::app()->user->id,'ty'=>'Client','ar'=>'1');
				// var_dump($cd->params);
			}else{
				if(isset($Cll->client->id)){
					// $cd->condition = 't.message_type=:ty and cu.user_id=:id and cu.is_archive=:ar and cs.user_id=:cl';
					$cd->condition = 't.message_type=:ty and cu.user_id=:id and cu.is_archive=:ar';
					//$cd->params = array('id'=>Yii::app()->user->id,'ty'=>'Client','ar'=>'1','cl'=>$Cll->client->id);
					// var_dump('1181');
					// $cd->params = array('id'=>Yii::app()->user->id,'ty'=>'Client','ar'=>'0','cl'=>$Cll->client->id);
					$cd->params = array('id'=>Yii::app()->user->id,'ty'=>'Client','ar'=>'0');
				}else{					
					$cd->condition = 't.message_type=:ty and cu.user_id=:id and cu.is_archive=:ar';
					//$cd->params = array('id'=>Yii::app()->user->id,'ty'=>'Client','ar'=>'1');
					// var_dump('1185');
					// var_dump(Yii::app()->user->id);
					$cd->params = array('id'=>Yii::app()->user->id,'ty'=>'Client','ar'=>'0');
				}
			}			
		}
		$cd->order = 't.created DESC';
		
		$cd->limit = $_GET['ipp'];
		$cd->offset = $start;
		// var_dump(Yii::app()->user->id);
		$cda = $cd;
		$comms = $com->findAll($cd);
		
		$cd = new CDbCriteria;
		// $cd->join = "left join communication_user cu on cu.communication_id=t.id left join cases cs on cs.id = t.case_id";
		// if(isset($Cll->client->id)){
			// $cd->condition = 't.message_type=:ty and cu.user_id=:id and cu.is_archive<>:ar and cs.user_id=:cl';
			// $cd->params = array(':id'=>Yii::app()->user->id,'ty'=>'Client','ar'=>'1','cl'=>$Cll->client->id);
		// }else{					
			// $cd->condition = 't.message_type=:ty and cu.user_id=:id and cu.is_archive<>:ar';
			// $cd->params = array(':id'=>Yii::app()->user->id,'ty'=>'Client','ar'=>'0');
		// }
		
		$cd->join = "left join communication_user cu on cu.communication_id=t.id left join cases cs on cs.id = t.case_id";		
		if(isset($_REQUEST['mn'])){
			if($_REQUEST['mn']=='star'){
				if(isset($_SESSION['client'])){
					$cd->condition = 't.message_type=:ty and cu.user_id=:id and cu.is_star=:st and cu.is_archive<>:ar and cs.user_id=:cl';
					$cd->params = array('id'=>Yii::app()->user->id,'ty'=>'Client','st'=>'1','ar'=>'1','cl'=>$Cll->client->id);
				}else{
					$cd->condition = 't.message_type=:ty and cu.user_id=:id and cu.is_star=:st and cu.is_archive<>:ar';
					$cd->params = array('id'=>Yii::app()->user->id,'ty'=>'Client','st'=>'1','ar'=>'1');
				}
			}			
			if($_REQUEST['mn']=='flag'){
				if(isset($_SESSION['client'])){
					$cd->condition = 't.message_type=:ty and cu.user_id=:id and cu.is_flag=:st and cu.is_archive<>:ar and cs.user_id=:cl';
					$cd->params = array('id'=>Yii::app()->user->id,'ty'=>'Client','st'=>'1','ar'=>'1','cl'=>$Cll->client->id);
				}else{
					$cd->condition = 't.message_type=:ty and cu.user_id=:id and cu.is_flag=:st and cu.is_archive<>:ar';
					$cd->params = array('id'=>Yii::app()->user->id,'ty'=>'Client','st'=>'1','ar'=>'1');
				}
			}
		}else{
			if(isset($_SESSION['client'])){
				$cd->condition = 't.message_type=:ty and cu.user_id=:id and cu.is_archive<>:ar and cs.user_id=:cl';
				$cd->params = array('id'=>Yii::app()->user->id,'ty'=>'Client','ar'=>'1','cl'=>$Cll->client->id);
			}else{
				if(isset($Cll->client->id)){
					$cd->condition = 't.message_type=:ty and cu.user_id=:id and cu.is_archive=:ar';
					$cd->params = array('id'=>Yii::app()->user->id,'ty'=>'Client','ar'=>'0');
				}else{					
					$cd->condition = 't.message_type=:ty and cu.user_id=:id and cu.is_archive=:ar';
					$cd->params = array('id'=>Yii::app()->user->id,'ty'=>'Client','ar'=>'0');
				}
			}			
		}
		
		$cd->order = 't.created DESC';
		
		$commsa = $com->findAll($cd);
		// var_dump(count($commsa));
		$data = '';
		
		// var_dump(count($comms));
		$d=0;
		foreach($comms as $co){
			$data[$d]['slug'] = $co->slug;
			if(isset($C1->client->id)){
				$data[$d]['from'] = $co->createdBy->profile->fullname;
			}else{
				$data[$d]['from'] = $co->createdBy->client->fullname;
			}
			$data[$d]['subject'] = $co->subject;
			$data[$d]['message'] = $co->message;			
			$data[$d]['str'] = 'glyphicon-star-empty';
			$data[$d]['flg'] = 'fa-flag-o';
			foreach($co->cuser as $cj){
				if($cj->user_id == Yii::app()->user->id){
					$data[$d]['cud'] = $cj->id;
					if($cj->is_read)
						$data[$d]['read'] = 'read';
					if($cj->is_star)
						$data[$d]['str'] = 'glyphicon-star active';
					if($cj->is_flag)
						$data[$d]['flg'] = 'fa-flag active';
				}				
			}
			// var_dump($co->created);
			if(date('Y')==date('Y',strtotime($co->created))){
				if(date('Y-m-d')==date('Y-m-d',strtotime($co->created))){
					$data[$d]['time'] = date('h:i A',strtotime($co->created));
				}else{
					$data[$d]['time'] = date('M, d',strtotime($co->created));
				}
			}else{
				$data[$d]['time'] = date('m/d/Y',strtotime($co->created));
			}
			$d++;
		}
		$dat['total'] = count($commsa);
		$dat['dats'] = $data;
		echo json_encode($dat);
		Yii::app()->end();
	}
	
	public function actionDetail($slug = null)
	{
		// var_dump($slug);
		$this->layout ="ajax";
		$this->dbswitch(Yii::app()->user->firm_id);
		$com = new Communication;
		$cd = new CDbCriteria;
		$usr = new User;
		$cd->join = "left join communication_user cu on cu.communication_id=t.id";
		// $cd->condition = ' cu.user_id=:id and t.slug = :slug';
		$cd->condition = 't.slug = :slug';
		// $cd->params = array(':id'=>Yii::app()->user->id,'slug'=>$slug);
		$cd->params = array('slug'=>$slug);
		$co = $com->find($cd);
		$cmmuu=new CommunicationUser;
		$q=new CDbCriteria;
		$q->compare('t.communication_id',$co->id);
		$q->compare('t.user_id',Yii::app()->user->id);
		$q->compare('t.is_read',0);
		$cummail=$cmmuu->find($q);
		$clo = CommunicationUser::model()->findByPk($cummail->id);
			if($clo){
				$clo->is_read = '1';
				$clo->save();
			}		
		//Deepak code
		/*if(!$co->cuser->is_read){
			$clo = CommunicationUser::model()->findByPk($co->cuser->id);
			if($clo){
				$clo->is_read = '1';
				$clo->save();
			}			
		}*/
		//Deepak code end//
		$c = new CDbCriteria;
		$c->compare('t.is_sadmin','0');
		$usres = $usr->findAll($c);
		$lusr = '';
		$i = 0;
		foreach($usres as $u){
			$lusr[$i]['id'] = $u->id;
			if(isset($u->profile->fullname)){
				$lusr[$i]['name'] = $u->profile->fullname." (".$u->email.")" ;
			}else{
				$lusr[$i]['name'] = $u->client->fullname." (".$u->email.")" ;
			}				
			$i++;
		}
		$data['cdd'] = $co->id;
		foreach($co->cuser as $cv){
			// var_dump($cv->id);
			if($cv->user_id==Yii::app()->user->id)
				$data['cud'] = $cv->id;
			// $data['cud'] = $co->cuser->id;
		}		
		$data['cudd'] = $co->slug;
		$data['subject'] = $co->subject;
		$data['message'] = html_entity_decode($co->message);
		if(isset($co->createdBy->profile->fullname))
			$data['createdby'] = $co->createdBy->profile->fullname;
		if(isset($co->createdBy->client->fullname))
			$data['createdby'] = $co->createdBy->client->fullname;
		$data['createdbyemail'] = $co->createdBy->email;
		$data['createdbyd'] = $co->created_by;
		$data['createdbyimage'] = $co->createdBy->profile->image;
		// var_dump($co->createdBy->profile->image);
		if(!empty($co->createdBy->profile->image) && count($co->createdBy->profile->image)>=3){
			$data['cim'] = 'yes';
		}else{
			$data['cim'] = 'no';
		}
		$data['users'] = $lusr;
		$my = User::model()->findByPk(Yii::app()->user->id);
		$data['myimage'] = $my->profile->image;
		$data['time'] = date('m/d/Y h:i A',strtotime($co->created));
		echo json_encode($data);
		Yii::app()->end();
	}
	
	public function actionGetacc(){
		$lusr['a'] = 'false';
		$ft = User::model()->getUtype();		
		if(array_search('Client',$ft)!==false){
			$lusr['a'] = 'true';
		}
		echo json_encode($lusr);
	}
	
	public function actionGetu(){
		$usr = new User;
		$c = new CDbCriteria;
		// $c->compare('t.is_sadmin','0');
		// $c->compare('t.id','<>',Yii::app()->user->id);
		$cLt=User::model()->findByPk(Yii::app()->user->id);
		if(isset($cLt->client->id)){
			$c->condition = "t.is_sadmin=:is ";
			$c->params = array('is'=>'0');
		}else{
			$c->condition = "t.is_sadmin=:is and t.id <> :di";
			$c->params = array('is'=>'0','di'=>Yii::app()->user->id);
		}
		// var_dump($c);
		$usres = $usr->findAll($c);
		$lusr = '';
		$i = 0;
		foreach($usres as $u){
			if(isset($u->profile->fullname)){
				if(!empty($u->profile->fullname)){
					$lusr[$i]['id'] = $u->id;
					$lusr[$i]['name'] = $u->profile->fullname." (".$u->email.")" ;
				}
			}else{
				if(!empty($u->client->fullname)){
					$lusr[$i]['name'] = $u->client->fullname." (".$u->email.")" ;
					$lusr[$i]['id'] = $u->id;
					// $lusr['client'][$i]['name'] = $u->client->fullname." (".$u->email.")" ;
					// $lusr['client'][$i]['id'] = $u->id;
				}
			}				
			$i++;
		}
		echo json_encode($lusr);
	}
	
	public function actionGetcu(){
		$usr = new User;
		$c = new CDbCriteria;
		$cLt=User::model()->findByPk(Yii::app()->user->id);
		if(isset($cLt->client->id)){
			$c->condition = "t.is_sadmin=:is ";
			$c->params = array('is'=>'0');
		}else{
			$c->condition = "t.is_sadmin=:is and t.id <> :di";
			$c->params = array('is'=>'0','di'=>Yii::app()->user->id);
		}		
		$usres = $usr->findAll($c);
		$lusr = '';
		$i = 0;
		foreach($usres as $u){
			if(isset($u->profile->fullname)){
				if(!empty($u->profile->fullname)){
					// $lusr[$i]['id'] = $u->id;
					// $lusr[$i]['name'] = $u->profile->fullname." (".$u->email.")" ;
				}
			}else{
				if(!empty($u->client->fullname)){
					$lusr[$i]['name'] = $u->client->fullname." (".$u->email.")" ;
					$lusr[$i]['id'] = $u->id;
					// $lusr['client'][$i]['name'] = $u->client->fullname." (".$u->email.")" ;
					// $lusr['client'][$i]['id'] = $u->id;
				}
			}				
			$i++;
		}
		echo json_encode($lusr);
	}
	
	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		$this->loadModel($id)->delete();
		// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
		if(!isset($_GET['ajax']))
			$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
	}
	
	public function actionSnd($y){
		$this->dbswitch(Yii::app()->user->firm_id);
		$com = new Communication;
		$cu = new CommunicationUser;
		if($y=='for'){
			$com->subject = "Fwd: ".$_REQUEST['sub'];			
		}
		if($y=='rep'){
			$com->subject = "Re: ".$_REQUEST['sub'];
			$com->in_reply = $_REQUEST['cdd'];
			$c1 = new Communication;
			$c1d =  new CDbCriteria;
			$c1d->compare('id',$_REQUEST['cdd']);
			$c11 = $c1->find($c1d);
			$com->case_id=$c11->case_id;
		}
		$com->message = $_REQUEST['ms'];		
		$com->message_type = 'Internal';
		$ft = User::model()->getUtype($_REQUEST['cbd']);
		//var_dump($ft);
		if( (array_search('Client',$ft)!==false) ){
			$com->message_type = 'Client';
		}
		$com->created_by = Yii::app()->user->id;
		$com->entry_date = date('Y-m-d H:i:s');
		$com->save();
		$ck = $com->primaryKey;
		if($y=='rep'){
			$cu->communication_id = $ck;
			$cu->user_id = $_REQUEST['cbd'];
			$g = $cu->save();
			if($g){
				$data['message'] = 'success';
				echo json_encode($data);
			}
		}
		if($y=='for'){
			$uu = explode(',',$_REQUEST['t']);
			// var_dump($uu);
			// die();
			foreach($uu as $u){
				$cu = new CommunicationUser;
				$cu->communication_id = $ck;
				$cu->user_id = $u;
				$g = $cu->save();
			}			
			if($g){
				$data['message'] = 'success';
				echo json_encode($data);
			}
		}
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
                $this->redirect('admin');
		$dataProvider=new CActiveDataProvider('Communication');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{	$this->layout='logged';
		$model=new Communication('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['Communication']))
			$model->attributes=$_GET['Communication'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer $id the ID of the model to be loaded
	 * @return Communication the loaded model
	 * @throws CHttpException
	 */
	public function loadModel($id)
	{
		$model=Communication::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param Communication $model the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='communication-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
}
